/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.ExplainOptions;
import com.google.cloud.firestore.ExplainResults;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.cloud.firestore.StreamableQuery;
import com.google.cloud.firestore.VectorQueryOptions;
import com.google.cloud.firestore.VectorQuerySnapshot;
import com.google.cloud.firestore.VectorValue;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.StructuredQuery;
import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class VectorQuery
extends StreamableQuery<VectorQuerySnapshot> {
    final Query query;
    final FieldPath vectorField;
    final VectorValue queryVector;
    final int limit;
    final DistanceMeasure distanceMeasure;
    final VectorQueryOptions options;

    VectorQuery(Query query, FieldPath vectorField, VectorValue queryVector, int limit, DistanceMeasure distanceMeasure, VectorQueryOptions options) {
        super(query.rpcContext, query.options);
        this.query = query;
        this.options = options;
        this.vectorField = vectorField;
        this.queryVector = queryVector;
        this.limit = limit;
        this.distanceMeasure = distanceMeasure;
    }

    @Override
    @Nonnull
    public ApiFuture<VectorQuerySnapshot> get() {
        return this.get(null, null);
    }

    @Override
    @Nonnull
    public ApiFuture<ExplainResults<VectorQuerySnapshot>> explain(ExplainOptions options) {
        return super.explain(options);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof VectorQuery)) {
            return false;
        }
        VectorQuery otherQuery = (VectorQuery)obj;
        return Objects.equals(this.query, otherQuery.query) && Objects.equals(this.vectorField, otherQuery.vectorField) && Objects.equals(this.queryVector, otherQuery.queryVector) && Objects.equals(this.options, otherQuery.options) && this.limit == otherQuery.limit && this.distanceMeasure == otherQuery.distanceMeasure;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.query, this.options, this.vectorField, this.queryVector, this.limit, this.distanceMeasure});
    }

    @Override
    protected RunQueryRequest.Builder toRunQueryRequestBuilder(@Nullable ByteString transactionId, @Nullable Timestamp readTime, @Nullable ExplainOptions explainOptions) {
        RunQueryRequest.Builder requestBuilder = this.query.toRunQueryRequestBuilder(transactionId, readTime, explainOptions);
        StructuredQuery.FindNearest.Builder findNearestBuilder = requestBuilder.getStructuredQueryBuilder().getFindNearestBuilder();
        findNearestBuilder.getQueryVectorBuilder().setMapValue(this.queryVector.toProto());
        findNearestBuilder.getLimitBuilder().setValue(this.limit);
        findNearestBuilder.setDistanceMeasure(VectorQuery.toProto(this.distanceMeasure));
        findNearestBuilder.getVectorFieldBuilder().setFieldPath(this.vectorField.toString());
        if (this.options != null) {
            if (this.options.getDistanceThreshold() != null) {
                findNearestBuilder.getDistanceThresholdBuilder().setValue(this.options.getDistanceThreshold().doubleValue());
            }
            if (this.options.getDistanceResultField() != null) {
                findNearestBuilder.setDistanceResultField(this.options.getDistanceResultField().toString());
            }
        }
        return requestBuilder;
    }

    private static StructuredQuery.FindNearest.DistanceMeasure toProto(DistanceMeasure distanceMeasure) {
        switch (distanceMeasure) {
            case COSINE: {
                return StructuredQuery.FindNearest.DistanceMeasure.COSINE;
            }
            case EUCLIDEAN: {
                return StructuredQuery.FindNearest.DistanceMeasure.EUCLIDEAN;
            }
            case DOT_PRODUCT: {
                return StructuredQuery.FindNearest.DistanceMeasure.DOT_PRODUCT;
            }
        }
        return StructuredQuery.FindNearest.DistanceMeasure.UNRECOGNIZED;
    }

    @Override
    boolean isRetryableWithCursor() {
        return false;
    }

    VectorQuery startAfter(@Nonnull DocumentSnapshot snapshot) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    VectorQuerySnapshot createSnaphot(Timestamp readTime, List<QueryDocumentSnapshot> documents) {
        return VectorQuerySnapshot.withDocuments(this, readTime, documents);
    }

    @Override
    public String toString() {
        return String.format("VectorQuery{query=%s, vectorField=%s, queryVector=%s, limit=%d, distanceMeasure=%s, options=%s, options=%s}", new Object[]{this.query, this.vectorField, this.queryVector, this.limit, this.distanceMeasure, this.options, this.options});
    }

    public static enum DistanceMeasure {
        COSINE,
        EUCLIDEAN,
        DOT_PRODUCT;

    }
}

