/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.config.Keys;
import org.traccar.helper.Checksum;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.model.Command;

public class MeitrackProtocolEncoder
extends StringProtocolEncoder {
    public MeitrackProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private Object formatCommand(Command command, String content) {
        String uniqueId = this.getUniqueId(command.getDeviceId());
        int length = 1 + uniqueId.length() + 1 + content.length() + 5;
        Object result = String.format("@@A%02d,%s,%s*", length, uniqueId, content);
        result = (String)result + Checksum.sum((String)result) + "\r\n";
        return result;
    }

    @Override
    protected Object encodeCommand(Command command) {
        boolean alternative = AttributeUtil.lookup(this.getCacheManager(), Keys.PROTOCOL_ALTERNATIVE.withPrefix(this.getProtocolName()), command.getDeviceId());
        return switch (command.getType()) {
            case "custom" -> this.formatCommand(command, command.getString("data"));
            case "positionSingle" -> this.formatCommand(command, "A10");
            case "engineStop" -> this.formatCommand(command, "C01,0,12222");
            case "engineResume" -> this.formatCommand(command, "C01,0,02222");
            case "alarmArm" -> this.formatCommand(command, alternative ? "B21,1" : "C01,0,22122");
            case "alarmDisarm" -> this.formatCommand(command, alternative ? "B21,0" : "C01,0,22022");
            case "requestPhoto" -> {
                int index = command.getInteger("index");
                yield this.formatCommand(command, "D03," + (index > 0 ? index : 1) + ",camera_picture.jpg");
            }
            case "sendSms" -> {
                String phone = command.getString("phone");
                String message = command.getString("message");
                yield this.formatCommand(command, "C02,0," + phone + "," + message);
            }
            default -> null;
        };
    }
}

