/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class NetProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("@L").number("ddd").number("(d{15})").number("xx").number("(dd)(dd)(dd)").number("(dd)(dd)(dd)").number("(x)").number("(dd)(dd)(dddd)").number("(ddd)(dd)(dddd)").number("(x{8})").number("(x{4})").number("(x{6})").number("(xxx)").number("(xxx)").any().compile();

    public NetProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        int flags = parser.nextHexInt();
        position.setValid(BitUtil.check(flags, 3));
        int hemisphereLatitude = BitUtil.check(flags, 1) ? -1 : 1;
        int hemisphereLongitude = BitUtil.check(flags, 0) ? -1 : 1;
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_MIN_MIN) * (double)hemisphereLatitude);
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_MIN_MIN) * (double)hemisphereLongitude);
        position.set("status", parser.nextHexLong());
        position.setSpeed((double)parser.nextHexInt().intValue() * 0.01);
        position.set("odometer", (double)parser.nextHexInt().intValue() * 1852.0 / 16.0);
        position.setCourse(parser.nextHexInt().intValue());
        parser.nextHexInt();
        return position;
    }
}

