/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Locale;
import org.traccar.api.security.LoginResult;
import org.traccar.api.security.LoginService;

public class McpAuthFilter
implements Filter {
    public static final String ATTRIBUTE_USER_ID = "userId";
    private final LoginService loginService;

    public McpAuthFilter(LoginService loginService) {
        this.loginService = loginService;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String authorization = httpRequest.getHeader("Authorization");
        if (authorization == null || authorization.isBlank()) {
            this.unauthorized(httpResponse, "Missing Authorization header");
            return;
        }
        String[] parts = authorization.split(" ", 2);
        if (parts.length != 2 || !"bearer".equals(parts[0].toLowerCase(Locale.ROOT)) || parts[1].isBlank()) {
            this.unauthorized(httpResponse, "Authorization header must be a Bearer token");
            return;
        }
        try {
            LoginResult loginResult = this.loginService.login(parts[1].trim());
            if (loginResult == null || loginResult.getUser() == null) {
                this.unauthorized(httpResponse, "Invalid access token");
                return;
            }
            httpRequest.setAttribute(ATTRIBUTE_USER_ID, (Object)loginResult.getUser().getId());
        }
        catch (Exception e) {
            this.unauthorized(httpResponse, "Invalid access token");
            return;
        }
        chain.doFilter(request, response);
    }

    private void unauthorized(HttpServletResponse response, String message) throws IOException {
        response.setStatus(401);
        response.setHeader("WWW-Authenticate", "Bearer error=\"invalid_token\"");
        response.setContentType("application/json");
        response.getWriter().write("{\"error\":\"unauthorized\",\"error_description\":\"" + message + "\"}");
    }
}

