# This file was automatically generated by bifcl from /usr/obj/ports/zeek-8.0.3/zeek-8.0.3/src/iosource/pcap/pcap.bif (alternative mode).

export {

module Pcap;









## Precompiles a PCAP filter and binds it to a given identifier.
##
## id: The PCAP identifier to reference the filter *s* later on.
##
## s: The PCAP filter. See ``man tcpdump`` for valid expressions.
##
## Returns: True if *s* is valid and precompiles successfully.
##
## .. zeek:see:: Pcap::install_pcap_filter
##          install_src_addr_filter
##          install_src_net_filter
##          uninstall_src_addr_filter
##          uninstall_src_net_filter
##          install_dst_addr_filter
##          install_dst_net_filter
##          uninstall_dst_addr_filter
##          uninstall_dst_net_filter
##          Pcap::error
global precompile_pcap_filter: function(id: PcapFilterID , s: string ): bool ;


## Installs a PCAP filter that has been precompiled with
## :zeek:id:`Pcap::precompile_pcap_filter`.
##
## id: The PCAP filter id of a precompiled filter.
##
## Returns: True if the filter associated with *id* has been installed
##          successfully.
##
## .. zeek:see:: Pcap::precompile_pcap_filter
##              install_src_addr_filter
##              install_src_net_filter
##              uninstall_src_addr_filter
##              uninstall_src_net_filter
##              install_dst_addr_filter
##              install_dst_net_filter
##              uninstall_dst_addr_filter
##              uninstall_dst_net_filter
##              Pcap::error
global Pcap::install_pcap_filter: function(id: PcapFilterID ): bool ;


## Returns a string representation of the last PCAP error.
##
## Returns: A descriptive error message of the PCAP function that failed.
##
## .. zeek:see:: Pcap::precompile_pcap_filter
##              Pcap::install_pcap_filter
##              install_src_addr_filter
##              install_src_net_filter
##              uninstall_src_addr_filter
##              uninstall_src_net_filter
##              install_dst_addr_filter
##              install_dst_net_filter
##              uninstall_dst_addr_filter
##              uninstall_dst_net_filter
global error: function(): string ;


## Returns the initialization state of a PCAP filter, or OK if the either
## there's no active packet source or the pcap filter ID does not exist.
##
## id: The PCAP filter id of a precompiled filter.
##
## Returns: A state value denoting whether any warnings or errors were
##          encountered while initializing the filter.
##
## .. zeek:see:: Pcap::precompile_pcap_filter
##               Pcap::install_pcap_filter
global get_filter_state: function(id: PcapFilterID ): filter_state ;


## Returns a string containing any error messages that were reported by
## filter initialization.
##
## id: The PCAP filter id of a precompiled filter.
##
## Returns: Warning/error strings from the initialization process, a blank
##          string if none were encountered, or '<unknown>' if either there
##          is no active packet source or the filter ID doesn't exist.
##
## .. zeek:see:: Pcap::precompile_pcap_filter
##               Pcap::install_pcap_filter
global get_filter_state_string: function(id: PcapFilterID ): string ;


global findalldevs: function(): Pcap::Interfaces ;

} # end of export section
module GLOBAL;
