/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
export declare const GOOGLE_ACCOUNTS_FILENAME = "google_accounts.json";
export declare const OAUTH_FILE = "oauth_creds.json";
export declare class Storage {
    private readonly targetDir;
    private readonly sessionId;
    private projectIdentifier;
    private initPromise;
    constructor(targetDir: string, sessionId?: string);
    static getGlobalGeminiDir(): string;
    static getGlobalAgentsDir(): string;
    static getMcpOAuthTokensPath(): string;
    static getGlobalSettingsPath(): string;
    static getInstallationIdPath(): string;
    static getGoogleAccountsPath(): string;
    static getUserCommandsDir(): string;
    static getUserSkillsDir(): string;
    static getUserAgentSkillsDir(): string;
    static getGlobalMemoryFilePath(): string;
    static getUserPoliciesDir(): string;
    static getUserAgentsDir(): string;
    static getAcknowledgedAgentsPath(): string;
    private static getSystemConfigDir;
    static getSystemSettingsPath(): string;
    static getSystemPoliciesDir(): string;
    static getGlobalTempDir(): string;
    static getGlobalBinDir(): string;
    getGeminiDir(): string;
    getAgentsDir(): string;
    getProjectTempDir(): string;
    ensureProjectTempDirExists(): void;
    static getOAuthCredsPath(): string;
    getProjectRoot(): string;
    private getFilePathHash;
    private getProjectIdentifier;
    /**
     * Initializes storage by setting up the project registry and performing migrations.
     */
    initialize(): Promise<void>;
    /**
     * Performs migration of legacy hash-based directories to the new slug-based format.
     * This is called internally by initialize().
     */
    private performMigration;
    getHistoryDir(): string;
    getWorkspaceSettingsPath(): string;
    getProjectCommandsDir(): string;
    getProjectSkillsDir(): string;
    getProjectAgentSkillsDir(): string;
    getProjectAgentsDir(): string;
    getProjectTempCheckpointsDir(): string;
    getProjectTempLogsDir(): string;
    getProjectTempPlansDir(): string;
    getProjectTempTasksDir(): string;
    getExtensionsDir(): string;
    getExtensionsConfigPath(): string;
    getHistoryFilePath(): string;
}
