/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;

class LookupThrottler {
    private final ObjectCounter<ReplyTunnel> counter;
    private static final TunnelId DUMMY_ID = new TunnelId();
    private static final int DEFAULT_MAX_LOOKUPS = 14;
    private static final int DEFAULT_MAX_NON_FF_LOOKUPS = 3;
    private static final long DEFAULT_CLEAN_TIME = 120000L;
    private final int MAX_LOOKUPS;
    private final int MAX_NON_FF_LOOKUPS;
    private final long CLEAN_TIME;
    private final FloodfillNetworkDatabaseFacade _facade;
    private int _max;

    LookupThrottler(FloodfillNetworkDatabaseFacade facade) {
        this(facade, 14, 3, 120000L);
    }

    LookupThrottler(FloodfillNetworkDatabaseFacade facade, int maxlookups, int maxnonfflookups, long cleanTime) {
        this._facade = facade;
        this.MAX_LOOKUPS = maxlookups;
        this.MAX_NON_FF_LOOKUPS = maxnonfflookups;
        this.CLEAN_TIME = cleanTime;
        this.counter = new ObjectCounter();
        SimpleTimer2.getInstance().addPeriodicEvent(new Cleaner(), this.CLEAN_TIME);
    }

    boolean shouldThrottle(Hash key, TunnelId id) {
        return this.counter.increment(new ReplyTunnel(key, id)) > this._max;
    }

    private class Cleaner
    implements SimpleTimer.TimedEvent {
        private Cleaner() {
        }

        @Override
        public void timeReached() {
            LookupThrottler.this.counter.clear();
            LookupThrottler.this._max = LookupThrottler.this._facade.floodfillEnabled() ? LookupThrottler.this.MAX_LOOKUPS : LookupThrottler.this.MAX_NON_FF_LOOKUPS;
        }
    }

    private static class ReplyTunnel {
        public final Hash h;
        public final TunnelId id;

        ReplyTunnel(Hash h, TunnelId id) {
            this.h = h;
            this.id = id != null ? id : DUMMY_ID;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ReplyTunnel)) {
                return false;
            }
            return this.h.equals(((ReplyTunnel)obj).h) && this.id.equals(((ReplyTunnel)obj).id);
        }

        public int hashCode() {
            return this.h.hashCode() ^ this.id.hashCode();
        }
    }
}

