/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpProperty;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpPropertyImpl
extends RegExpElementImpl
implements RegExpProperty {
    private static final String[] UNICODE_BLOCKS;

    public RegExpPropertyImpl(ASTNode astNode) {
        super(astNode);
    }

    public PsiReference getReference() {
        ASTNode lbrace = this.getNode().findChildByType(RegExpTT.LBRACE);
        if (lbrace == null) {
            return null;
        }
        return new MyPsiReference();
    }

    @Override
    public boolean isNegated() {
        ASTNode node1 = this.getNode().findChildByType(RegExpTT.PROPERTY);
        ASTNode node2 = this.getNode().findChildByType(RegExpTT.CARET);
        return (node1 != null && node1.textContains('P')) ^ node2 != null;
    }

    @Override
    @Nullable
    public ASTNode getCategoryNode() {
        return this.getNode().findChildByType(RegExpTT.NAME);
    }

    @Override
    @Nullable
    public ASTNode getValueNode() {
        ASTNode node = this.getNode();
        ASTNode eq = node.findChildByType(RegExpTT.EQ);
        return eq != null ? node.findChildByType(RegExpTT.NAME, eq) : null;
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpProperty(this);
    }

    static {
        Field[] fields = Character.UnicodeBlock.class.getFields();
        ArrayList<CallSite> unicodeBlocks = new ArrayList<CallSite>(fields.length);
        for (Field field : fields) {
            if (!field.getType().equals(Character.UnicodeBlock.class) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
            unicodeBlocks.add((CallSite)((Object)("In" + field.getName())));
        }
        UNICODE_BLOCKS = ArrayUtilRt.toStringArray(unicodeBlocks);
    }

    private class MyPsiReference
    implements PsiReference {
        private MyPsiReference() {
        }

        @NotNull
        public PsiElement getElement() {
            RegExpPropertyImpl regExpPropertyImpl = RegExpPropertyImpl.this;
            if (regExpPropertyImpl == null) {
                MyPsiReference.$$$reportNull$$$0(0);
            }
            return regExpPropertyImpl;
        }

        @NotNull
        public TextRange getRangeInElement() {
            ASTNode node = RegExpPropertyImpl.this.getNode();
            ASTNode firstNode = node.findChildByType(RegExpTT.CARET);
            if (firstNode == null) {
                firstNode = node.findChildByType(RegExpTT.LBRACE);
            }
            assert (firstNode != null);
            ASTNode eq = node.findChildByType(RegExpTT.EQ);
            ASTNode rbrace = node.findChildByType(RegExpTT.RBRACE);
            int to = eq != null ? eq.getTextRange().getEndOffset() - 1 : (rbrace != null ? rbrace.getTextRange().getEndOffset() - 1 : RegExpPropertyImpl.this.getTextRange().getEndOffset());
            TextRange t = new TextRange(firstNode.getStartOffset() + 1, to);
            TextRange textRange = t.shiftRight(-RegExpPropertyImpl.this.getTextRange().getStartOffset());
            if (textRange == null) {
                MyPsiReference.$$$reportNull$$$0(1);
            }
            return textRange;
        }

        @Nullable
        public PsiElement resolve() {
            return RegExpPropertyImpl.this;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.getRangeInElement().substring(this.getElement().getText());
            if (string == null) {
                MyPsiReference.$$$reportNull$$$0(2);
            }
            return string;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                MyPsiReference.$$$reportNull$$$0(3);
            }
            throw new IncorrectOperationException();
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                MyPsiReference.$$$reportNull$$$0(4);
            }
            throw new IncorrectOperationException();
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            if (element == null) {
                MyPsiReference.$$$reportNull$$$0(5);
            }
            return false;
        }

        public Object @NotNull [] getVariants() {
            ASTNode categoryNode = RegExpPropertyImpl.this.getCategoryNode();
            if (categoryNode != null && categoryNode.getText().startsWith("In") && !categoryNode.getText().startsWith("Intelli")) {
                if (UNICODE_BLOCKS == null) {
                    MyPsiReference.$$$reportNull$$$0(6);
                }
                return UNICODE_BLOCKS;
            }
            boolean startsWithIs = categoryNode != null && categoryNode.getText().startsWith("Is");
            ArrayList<LookupElement> result = new ArrayList<LookupElement>();
            for (Object[] objectArray : RegExpLanguageHosts.getInstance().getAllKnownProperties(this.getElement())) {
                String name = (String)ArrayUtil.getFirstElement((Object[])objectArray);
                if (name == null) continue;
                Object typeText = objectArray.length > 1 ? objectArray[1] : "Character.is" + name.substring("java".length()) + "()";
                result.add(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)name).withPresentableText((String)(startsWithIs ? "Is" + name : name)).withIcon(PlatformIcons.PROPERTY_ICON).withTypeText((String)typeText), (double)this.getPriority(name)));
            }
            Object[] objectArray = ArrayUtil.toObjectArray(result);
            if (objectArray == null) {
                MyPsiReference.$$$reportNull$$$0(7);
            }
            return objectArray;
        }

        private int getPriority(@NotNull String propertyName) {
            if (propertyName == null) {
                MyPsiReference.$$$reportNull$$$0(8);
            }
            if (propertyName.equals("all")) {
                return 3;
            }
            if (propertyName.startsWith("java")) {
                return 1;
            }
            if (propertyName.length() > 2) {
                return 2;
            }
            return 0;
        }

        public boolean isSoft() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4, 5, 8 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/psi/impl/RegExpPropertyImpl$MyPsiReference";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/psi/impl/RegExpPropertyImpl$MyPsiReference";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getPriority";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4, 5, 8 -> new IllegalArgumentException(string);
            };
        }
    }
}

