/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.workflows;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.common.util.MultivaluedHashMap;

public final class MultivaluedHashMapValueSerializer
extends JsonSerializer<MultivaluedHashMap<String, String>> {
    public void serialize(MultivaluedHashMap<String, String> map, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        Set<String> ignoredProperties = MultivaluedHashMapValueSerializer.getIgnoredProperties(gen);
        gen.writeStartObject();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            if (ignoredProperties.contains(key)) continue;
            List values = (List)entry.getValue();
            if (values.size() == 1) {
                String value = (String)values.get(0);
                if (Boolean.TRUE.toString().equalsIgnoreCase(value) || Boolean.FALSE.toString().equalsIgnoreCase(value)) {
                    gen.writeBooleanField(key, Boolean.parseBoolean(value));
                    continue;
                }
                gen.writeObjectField(key, (Object)value);
                continue;
            }
            gen.writeArrayFieldStart(key);
            for (String v : values) {
                gen.writeString(v);
            }
            gen.writeEndArray();
        }
        gen.writeEndObject();
    }

    public boolean isEmpty(SerializerProvider provider, MultivaluedHashMap<String, String> value) {
        return MultivaluedHashMapValueSerializer.getIgnoredProperties(provider.getGenerator()).containsAll(value.keySet());
    }

    private static Set<String> getIgnoredProperties(JsonGenerator gen) {
        Class<?> parentClazz = gen.currentValue().getClass();
        return Arrays.stream(parentClazz.getDeclaredMethods()).map(Method::getName).filter(name -> name.startsWith("get")).map(name -> name.substring(3).toLowerCase()).collect(Collectors.toSet());
    }
}

