/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.LockOptions;
import org.hibernate.Locking;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.TableDetails;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.BasicValuedCollectionPart;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.internal.PessimisticLockKind;
import org.hibernate.sql.ast.spi.LockingClauseStrategy;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.model.TableMapping;

public class StandardLockingClauseStrategy
implements LockingClauseStrategy {
    private final Dialect dialect;
    private final RowLockStrategy rowLockStrategy;
    private final PessimisticLockKind lockKind;
    private final Locking.Scope lockingScope;
    private final int timeout;
    private boolean queryHasOuterJoins = false;
    private Set<TableGroup> rootsToLock;
    private Set<TableGroupJoin> joinsToLock;

    public StandardLockingClauseStrategy(Dialect dialect, PessimisticLockKind lockKind, RowLockStrategy rowLockStrategy, LockOptions lockOptions) {
        assert (lockKind != PessimisticLockKind.NONE);
        this.dialect = dialect;
        this.rowLockStrategy = rowLockStrategy;
        this.lockKind = lockKind;
        this.lockingScope = lockOptions.getScope();
        this.timeout = lockOptions.getTimeout().milliseconds();
    }

    @Override
    public void registerRoot(TableGroup root) {
        if (!this.queryHasOuterJoins && !this.dialect.supportsOuterJoinForUpdate() && CollectionHelper.isNotEmpty(root.getTableReferenceJoins())) {
            this.queryHasOuterJoins = true;
        }
        if (this.rowLockStrategy != RowLockStrategy.NONE) {
            if (this.rootsToLock == null) {
                this.rootsToLock = new HashSet<TableGroup>();
            }
            this.rootsToLock.add(root);
        }
    }

    @Override
    public void registerJoin(TableGroupJoin join) {
        if (this.lockingScope == Locking.Scope.INCLUDE_COLLECTIONS) {
            PluralAttributeMapping attrMapping;
            ModelPartContainer modelPartContainer = join.getJoinedGroup().getModelPart();
            if (modelPartContainer instanceof PluralAttributeMapping && !(attrMapping = (PluralAttributeMapping)modelPartContainer).getCollectionDescriptor().isInverse() && attrMapping.getElementDescriptor() instanceof BasicValuedCollectionPart) {
                this.trackJoin(join);
            }
        } else if (this.lockingScope == Locking.Scope.INCLUDE_FETCHES && join.getJoinedGroup().isFetched()) {
            this.trackJoin(join);
        }
    }

    private void trackJoin(TableGroupJoin join) {
        if (!this.queryHasOuterJoins && !this.dialect.supportsOuterJoinForUpdate()) {
            TableGroup joinedGroup = join.getJoinedGroup();
            if (join.isInitialized() && join.getJoinType() != SqlAstJoinType.INNER && !joinedGroup.isVirtual()) {
                this.queryHasOuterJoins = true;
            } else {
                EntityPersister entityMapping;
                ModelPartContainer modelPartContainer = joinedGroup.getModelPart();
                if (modelPartContainer instanceof EntityPersister && (entityMapping = (EntityPersister)modelPartContainer).hasMultipleTables()) {
                    this.queryHasOuterJoins = true;
                }
            }
        }
        if (this.rowLockStrategy != RowLockStrategy.NONE) {
            if (this.joinsToLock == null) {
                this.joinsToLock = new LinkedHashSet<TableGroupJoin>();
            }
            this.joinsToLock.add(join);
        }
    }

    @Override
    public boolean containsOuterJoins() {
        return this.queryHasOuterJoins;
    }

    @Override
    public void render(SqlAppender sqlAppender) {
        this.renderLockFragment(sqlAppender);
        this.renderResultSetOptions(sqlAppender);
    }

    protected void renderLockFragment(SqlAppender sqlAppender) {
        String fragment;
        if (this.rowLockStrategy == RowLockStrategy.NONE) {
            fragment = this.lockKind == PessimisticLockKind.SHARE ? this.dialect.getReadLockString(this.timeout) : this.dialect.getWriteLockString(this.timeout);
        } else {
            String lockItemsFragment = this.collectLockItems();
            fragment = this.lockKind == PessimisticLockKind.SHARE ? this.dialect.getReadLockString(lockItemsFragment, this.timeout) : this.dialect.getWriteLockString(lockItemsFragment, this.timeout);
        }
        sqlAppender.append(fragment);
    }

    private String collectLockItems() {
        ArrayList<String> lockItems = new ArrayList<String>();
        for (TableGroup root : this.rootsToLock) {
            this.collectLockItems(root, lockItems);
        }
        if (this.joinsToLock != null) {
            for (TableGroupJoin join : this.joinsToLock) {
                this.collectLockItems(join.getJoinedGroup(), lockItems);
            }
        }
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (String lockItem : lockItems) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            buffer.append(lockItem);
        }
        return buffer.toString();
    }

    protected void renderResultSetOptions(SqlAppender sqlAppender) {
    }

    private void collectLockItems(TableGroup tableGroup, List<String> lockItems) {
        if (this.rowLockStrategy == RowLockStrategy.TABLE) {
            this.addTableAliases(tableGroup, lockItems);
        } else if (this.rowLockStrategy == RowLockStrategy.COLUMN) {
            this.addColumnRefs(tableGroup, lockItems);
        }
    }

    private void addTableAliases(TableGroup tableGroup, List<String> lockItems) {
        String tableAlias = tableGroup.getPrimaryTableReference().getIdentificationVariable();
        lockItems.add(tableAlias);
        List<TableReferenceJoin> tableReferenceJoins = tableGroup.getTableReferenceJoins();
        if (CollectionHelper.isNotEmpty(tableReferenceJoins)) {
            for (int i = 0; i < tableReferenceJoins.size(); ++i) {
                lockItems.add(tableReferenceJoins.get(i).getJoinedTableReference().getIdentificationVariable());
            }
        }
    }

    private void addColumnRefs(TableGroup tableGroup, List<String> lockItems) {
        String[] keyColumns = this.determineKeyColumnNames(tableGroup.getModelPart());
        String tableAlias = tableGroup.getPrimaryTableReference().getIdentificationVariable();
        for (int i = 0; i < keyColumns.length; ++i) {
            assert (!keyColumns[i].contains("."));
            lockItems.add(tableAlias + "." + keyColumns[i]);
        }
        List<TableReferenceJoin> tableReferenceJoins = tableGroup.getTableReferenceJoins();
        if (CollectionHelper.isNotEmpty(tableReferenceJoins)) {
            EntityPersister entityPersister = this.determineEntityPersister(tableGroup.getModelPart());
            for (int i = 0; i < tableReferenceJoins.size(); ++i) {
                TableReferenceJoin tableReferenceJoin = tableReferenceJoins.get(i);
                NamedTableReference joinedTableReference = tableReferenceJoin.getJoinedTableReference();
                String tableJoinAlias = joinedTableReference.getIdentificationVariable();
                TableMapping tableMapping = this.determineTableMapping(entityPersister, tableReferenceJoin);
                for (TableDetails.KeyColumn keyColumn : tableMapping.getKeyDetails().getKeyColumns()) {
                    lockItems.add(tableJoinAlias + "." + keyColumn.getColumnName());
                }
            }
        }
    }

    private TableMapping determineTableMapping(EntityPersister entityPersister, TableReferenceJoin tableReferenceJoin) {
        NamedTableReference joinedTableReference = tableReferenceJoin.getJoinedTableReference();
        for (EntityTableMapping tableMapping : entityPersister.getTableMappings()) {
            if (!joinedTableReference.containsAffectedTableName(tableMapping.getTableName())) continue;
            return tableMapping;
        }
        for (EntityMappingType subMappingType : entityPersister.getSubMappingTypes()) {
            for (EntityTableMapping tableMapping : subMappingType.getEntityPersister().getTableMappings()) {
                if (!joinedTableReference.containsAffectedTableName(tableMapping.getTableName())) continue;
                return tableMapping;
            }
        }
        throw new IllegalArgumentException("Couldn't find subclass index for joined table reference " + String.valueOf(joinedTableReference));
    }

    private EntityPersister determineEntityPersister(ModelPartContainer modelPart) {
        if (modelPart instanceof EntityPersister) {
            EntityPersister entityPersister = (EntityPersister)modelPart;
            return entityPersister;
        }
        if (modelPart instanceof PluralAttributeMapping) {
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)modelPart;
            return pluralAttributeMapping.getCollectionDescriptor().getElementPersister();
        }
        if (modelPart instanceof EntityAssociationMapping) {
            EntityAssociationMapping entityAssociationMapping = (EntityAssociationMapping)modelPart;
            return entityAssociationMapping.getAssociatedEntityMappingType().getEntityPersister();
        }
        throw new IllegalArgumentException("Expected table group with table joins to have an entity typed model part but got: " + String.valueOf(modelPart));
    }

    private String[] determineKeyColumnNames(ModelPart modelPart) {
        if (modelPart instanceof EntityPersister) {
            EntityPersister entityPersister = (EntityPersister)modelPart;
            return entityPersister.getIdentifierColumnNames();
        }
        if (modelPart instanceof PluralAttributeMapping) {
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)modelPart;
            ForeignKeyDescriptor keyDescriptor = pluralAttributeMapping.getKeyDescriptor();
            ValuedModelPart keyPart = keyDescriptor.getKeyPart();
            if (keyPart.getJdbcTypeCount() == 1) {
                return new String[]{keyPart.getSelectable(0).getSelectableName()};
            }
            ArrayList<String> results = CollectionHelper.arrayList(keyPart.getJdbcTypeCount());
            keyPart.forEachSelectable((index, selectable) -> {
                if (!selectable.isFormula()) {
                    results.add(selectable.getSelectableName());
                }
            });
            return results.toArray(new String[0]);
        }
        if (modelPart instanceof EntityAssociationMapping) {
            EntityAssociationMapping entityAssociationMapping = (EntityAssociationMapping)modelPart;
            return this.determineKeyColumnNames(entityAssociationMapping.getAssociatedEntityMappingType());
        }
        return null;
    }
}

