/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph;

import java.util.BitSet;
import org.hibernate.Incubating;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.DomainResultGraphNode;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;

@Incubating
public interface FetchParent
extends DomainResultGraphNode {
    public FetchableContainer getReferencedMappingContainer();

    public FetchableContainer getReferencedMappingType();

    default public NavigablePath resolveNavigablePath(Fetchable fetchable) {
        EntityMappingType entityMappingType;
        String fetchableName = fetchable.getFetchableName();
        if (fetchable instanceof EntityIdentifierMapping) {
            return new EntityIdentifierNavigablePath(this.getNavigablePath(), fetchableName);
        }
        FetchableContainer referencedMappingContainer = this.getReferencedMappingContainer();
        EntityMappingType fetchableEntityType = fetchable.findContainingEntityMapping();
        EntityMappingType fetchParentType = referencedMappingContainer instanceof EmbeddableMappingType || referencedMappingContainer instanceof EmbeddableValuedModelPart ? referencedMappingContainer.findContainingEntityMapping() : (referencedMappingContainer instanceof EntityMappingType ? (entityMappingType = (EntityMappingType)referencedMappingContainer) : fetchableEntityType);
        if (fetchParentType != null && !fetchParentType.isTypeOrSuperType(fetchableEntityType)) {
            return this.getNavigablePath().treatAs(fetchableEntityType.getEntityName()).append(fetchableName);
        }
        return this.getNavigablePath().append(fetchableName);
    }

    default public ModelPart getReferencedModePart() {
        return this.getReferencedMappingContainer();
    }

    @Override
    public NavigablePath getNavigablePath();

    public ImmutableFetchList getFetches();

    public Fetch findFetch(Fetchable var1);

    public boolean hasJoinFetches();

    public boolean containsCollectionFetches();

    default public int getCollectionFetchesCount() {
        return this.getFetches().getCollectionFetchesCount();
    }

    @Override
    default public void collectValueIndexesToCache(BitSet valueIndexes) {
        for (Fetch fetch : this.getFetches()) {
            fetch.collectValueIndexesToCache(valueIndexes);
        }
    }

    public Initializer<?> createInitializer(InitializerParent<?> var1, AssemblerCreationState var2);

    default public FetchParent getRoot() {
        FetchParent fetchParent;
        FetchParent fetchParent2 = this;
        if (fetchParent2 instanceof Fetch) {
            Fetch fetch = (Fetch)((Object)fetchParent2);
            fetchParent = fetch.getFetchParent().getRoot();
        } else {
            fetchParent = this;
        }
        return fetchParent;
    }

    default public Fetch generateFetchableFetch(Fetchable fetchable, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        return fetchable.generateFetch(this, fetchablePath, fetchTiming, selected, resultVariable, creationState);
    }
}

