/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.common;

import java.nio.charset.Charset;
import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.logstash.RubyUtil;
import org.logstash.common.BufferedTokenizer;

@JRubyClass(name={"BufferedTokenizer"})
public class BufferedTokenizerExt
extends RubyObject {
    private static final long serialVersionUID = 1L;
    private String encodingName;
    private transient BufferedTokenizer tokenizer;

    public BufferedTokenizerExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    @JRubyMethod(name={"initialize"}, optional=2)
    public IRubyObject init(ThreadContext context, IRubyObject[] args) {
        String delimiter = "\n";
        if (args.length >= 1) {
            delimiter = args[0].convertToString().asJavaString();
        }
        if (args.length == 2) {
            int sizeLimit = args[1].convertToInteger().getIntValue();
            this.tokenizer = new BufferedTokenizer(delimiter, sizeLimit);
        } else {
            this.tokenizer = new BufferedTokenizer(delimiter);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject extract(final ThreadContext context, IRubyObject data) {
        RubyEncoding encoding = (RubyEncoding)data.convertToString().encoding(context);
        this.encodingName = encoding.getEncoding().getCharsetName();
        Iterable<String> extractor = this.tokenizer.extract(data.asJavaString());
        BufferedTokenizer.IteratorDecorator<CharSequence> rubyStringAdpaterIterator = new BufferedTokenizer.IteratorDecorator<CharSequence>(extractor.iterator()){

            @Override
            public CharSequence next() {
                return BufferedTokenizerExt.this.toEncodedRubyString(context, (String)this.iterator.next());
            }
        };
        return RubyUtil.toRubyObject(new IterableAdapterWithEmptyCheck((Iterator<CharSequence>)rubyStringAdpaterIterator));
    }

    private RubyString toEncodedRubyString(ThreadContext context, String input) {
        RubyString result = RubyUtil.RUBY.newString(new ByteList(input.getBytes(Charset.forName(this.encodingName))));
        result.force_encoding(context, (IRubyObject)RubyUtil.RUBY.newString(this.encodingName));
        return result;
    }

    @JRubyMethod
    public IRubyObject flush(ThreadContext context) {
        String s = this.tokenizer.flush();
        if (this.encodingName != null) {
            return this.toEncodedRubyString(context, s);
        }
        if (!s.isEmpty()) {
            throw new IllegalStateException("invoked flush with unassigned encoding but not empty head token, this shouldn't happen");
        }
        return RubyUtil.toRubyObject(s);
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject isEmpty(ThreadContext context) {
        return RubyUtil.RUBY.newBoolean(this.tokenizer.isEmpty());
    }

    public static class IterableAdapterWithEmptyCheck
    implements Iterable<CharSequence> {
        private final Iterator<CharSequence> origIterator;

        public IterableAdapterWithEmptyCheck(Iterator<CharSequence> origIterator) {
            this.origIterator = origIterator;
        }

        @Override
        public Iterator<CharSequence> iterator() {
            return this.origIterator;
        }

        public boolean isEmpty() {
            return !this.origIterator.hasNext();
        }
    }
}

