/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.common;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Util {
    public static MessageDigest defaultMessageDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String digest(String base) {
        MessageDigest digest = Util.defaultMessageDigest();
        byte[] hash = digest.digest(base.getBytes(StandardCharsets.UTF_8));
        return Util.bytesToHexString(hash);
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte aHash : bytes) {
            String hex = Integer.toHexString(0xFF & aHash);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

