/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.factory;

import co.elastic.logstash.api.Codec;
import co.elastic.logstash.api.Context;
import co.elastic.logstash.api.Plugin;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.common.EnvironmentVariableProvider;
import org.logstash.common.SourceWithMetadata;
import org.logstash.config.ir.PipelineIR;
import org.logstash.config.ir.compiler.AbstractFilterDelegatorExt;
import org.logstash.config.ir.compiler.AbstractOutputDelegatorExt;
import org.logstash.config.ir.compiler.OutputDelegatorExt;
import org.logstash.config.ir.compiler.OutputStrategyExt;
import org.logstash.config.ir.compiler.RubyIntegration;
import org.logstash.config.ir.graph.Vertex;
import org.logstash.execution.ExecutionContextExt;
import org.logstash.instrument.metrics.AbstractMetricExt;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.instrument.metrics.MetricKeys;
import org.logstash.plugins.ConfigVariableExpander;
import org.logstash.plugins.PluginLookup;
import org.logstash.plugins.discovery.PluginRegistry;
import org.logstash.plugins.factory.AbstractPluginCreator;
import org.logstash.plugins.factory.CodecPluginCreator;
import org.logstash.plugins.factory.ContextualizerExt;
import org.logstash.plugins.factory.ExecutionContextFactoryExt;
import org.logstash.plugins.factory.FilterPluginCreator;
import org.logstash.plugins.factory.InputPluginCreator;
import org.logstash.plugins.factory.OutputPluginCreator;
import org.logstash.plugins.factory.PluginMetricsFactoryExt;
import org.logstash.plugins.factory.RubyCodecDelegator;

@JRubyClass(name={"PluginFactory"})
public final class PluginFactoryExt
extends RubyBasicObject
implements RubyIntegration.PluginFactory {
    private static final long serialVersionUID = 1L;
    private static final RubyString ID_KEY = RubyUtil.RUBY.newString("id");
    private final transient Collection<String> pluginsById = ConcurrentHashMap.newKeySet();
    private transient PipelineIR lir;
    private ExecutionContextFactoryExt executionContextFactory;
    private PluginMetricsFactoryExt metrics;
    private RubyClass filterDelegatorClass;
    private transient ConfigVariableExpander configVariables;
    private transient PluginResolver pluginResolver;
    private final transient Map<PluginLookup.PluginType, AbstractPluginCreator<? extends Plugin>> pluginCreatorsRegistry = new HashMap<PluginLookup.PluginType, AbstractPluginCreator<? extends Plugin>>(4);

    @JRubyMethod(name={"filter_delegator"}, meta=true, required=5)
    public static IRubyObject filterDelegator(ThreadContext context, IRubyObject recv, IRubyObject ... args) {
        RubyClass filterDelegatorClass = (RubyClass)args[0];
        RubyClass klass = (RubyClass)args[1];
        RubyHash arguments = (RubyHash)args[2];
        AbstractMetricExt typeScopedMetric = (AbstractMetricExt)args[3];
        ExecutionContextExt executionContext = (ExecutionContextExt)args[4];
        IRubyObject filterInstance = ContextualizerExt.initializePlugin(context, executionContext, klass, arguments);
        RubyString id = (RubyString)arguments.op_aref(context, (IRubyObject)ID_KEY);
        filterInstance.callMethod(context, "metric=", (IRubyObject)typeScopedMetric.namespace(context, (IRubyObject)id.intern()));
        return filterDelegatorClass.newInstance(context, filterInstance, (IRubyObject)id, Block.NULL_BLOCK);
    }

    public PluginFactoryExt(Ruby runtime, RubyClass metaClass) {
        this(runtime, metaClass, new PluginLookup(PluginRegistry.getInstance()));
    }

    PluginFactoryExt(Ruby runtime, RubyClass metaClass, PluginResolver pluginResolver) {
        super(runtime, metaClass);
        this.pluginResolver = pluginResolver;
    }

    public PluginFactoryExt init(PipelineIR lir, PluginMetricsFactoryExt metrics, ExecutionContextFactoryExt executionContextFactoryExt, RubyClass filterClass) {
        return this.init(lir, metrics, executionContextFactoryExt, filterClass, EnvironmentVariableProvider.defaultProvider());
    }

    PluginFactoryExt init(PipelineIR lir, PluginMetricsFactoryExt metrics, ExecutionContextFactoryExt executionContextFactoryExt, RubyClass filterClass, EnvironmentVariableProvider envVars) {
        this.lir = lir;
        this.metrics = metrics;
        this.executionContextFactory = executionContextFactoryExt;
        this.filterDelegatorClass = filterClass;
        this.pluginCreatorsRegistry.put(PluginLookup.PluginType.INPUT, new InputPluginCreator(this));
        this.pluginCreatorsRegistry.put(PluginLookup.PluginType.CODEC, new CodecPluginCreator());
        this.pluginCreatorsRegistry.put(PluginLookup.PluginType.FILTER, new FilterPluginCreator());
        this.pluginCreatorsRegistry.put(PluginLookup.PluginType.OUTPUT, new OutputPluginCreator(this));
        this.configVariables = ConfigVariableExpander.withoutSecret(envVars);
        return this;
    }

    @Override
    public IRubyObject buildInput(RubyString name, IRubyObject args, SourceWithMetadata source) {
        return this.plugin(RubyUtil.RUBY.getCurrentContext(), PluginLookup.PluginType.INPUT, name.asJavaString(), (RubyHash)args, source);
    }

    @Override
    public AbstractOutputDelegatorExt buildOutput(RubyString name, IRubyObject args, SourceWithMetadata source) {
        return (AbstractOutputDelegatorExt)this.plugin(RubyUtil.RUBY.getCurrentContext(), PluginLookup.PluginType.OUTPUT, name.asJavaString(), (RubyHash)args, source);
    }

    @Override
    public AbstractFilterDelegatorExt buildFilter(RubyString name, IRubyObject args, SourceWithMetadata source) {
        return (AbstractFilterDelegatorExt)this.plugin(RubyUtil.RUBY.getCurrentContext(), PluginLookup.PluginType.FILTER, name.asJavaString(), (RubyHash)args, source);
    }

    @Override
    public IRubyObject buildCodec(RubyString name, IRubyObject args, SourceWithMetadata source) {
        return this.plugin(RubyUtil.RUBY.getCurrentContext(), PluginLookup.PluginType.CODEC, name.asJavaString(), (RubyHash)args, source);
    }

    @Override
    public Codec buildDefaultCodec(String codecName) {
        IRubyObject pluginInstance = this.plugin(RubyUtil.RUBY.getCurrentContext(), PluginLookup.PluginType.CODEC, codecName, RubyHash.newHash((Ruby)RubyUtil.RUBY), null);
        Codec codec = (Codec)JavaUtil.unwrapJavaValue((IRubyObject)pluginInstance);
        if (codec != null) {
            return codec;
        }
        return new RubyCodecDelegator(RubyUtil.RUBY.getCurrentContext(), pluginInstance);
    }

    @Override
    public Codec buildRubyCodecWrapper(RubyObject rubyCodec) {
        return new RubyCodecDelegator(RubyUtil.RUBY.getCurrentContext(), (IRubyObject)rubyCodec);
    }

    @JRubyMethod(required=3, optional=1)
    public IRubyObject plugin(ThreadContext context, IRubyObject[] args) {
        SourceWithMetadata source = args.length > 3 ? (SourceWithMetadata)JavaUtil.unwrapIfJavaObject((IRubyObject)args[3]) : null;
        return this.plugin(context, PluginLookup.PluginType.valueOf(args[0].asJavaString().toUpperCase(Locale.ENGLISH)), args[1].asJavaString(), (RubyHash)args[2], source);
    }

    private IRubyObject plugin(ThreadContext context, PluginLookup.PluginType type, String name, RubyHash args, SourceWithMetadata source) {
        String id = this.generateOrRetrievePluginId(type, source, (Map<String, ?>)args);
        if (id == null) {
            throw context.runtime.newRaiseException(RubyUtil.CONFIGURATION_ERROR_CLASS, String.format("Could not determine ID for %s/%s", type.rubyLabel().asJavaString(), name));
        }
        if (!this.pluginsById.add(id)) {
            throw context.runtime.newRaiseException(RubyUtil.CONFIGURATION_ERROR_CLASS, String.format("Two plugins have the id '%s', please fix this conflict", id));
        }
        AbstractNamespacedMetricExt typeScopedMetric = this.metrics.create(context, (IRubyObject)type.rubyLabel());
        PluginLookup.PluginClass pluginClass = this.pluginResolver.resolve(type, name);
        if (pluginClass.language() == PluginLookup.PluginLanguage.RUBY) {
            HashMap<String, String> newArgs = new HashMap<String, String>((Map<String, String>)args);
            newArgs.put("id", id);
            RubyClass klass = (RubyClass)pluginClass.klass();
            ExecutionContextExt executionCntx = this.executionContextFactory.create(context, (IRubyObject)RubyUtil.RUBY.newString(id), klass.callMethod(context, "config_name"));
            RubyHash rubyArgs = RubyHash.newHash((Ruby)context.runtime);
            rubyArgs.putAll(newArgs);
            if (type == PluginLookup.PluginType.OUTPUT) {
                return new OutputDelegatorExt(context.runtime, RubyUtil.RUBY_OUTPUT_DELEGATOR_CLASS).initialize(context, new IRubyObject[]{klass, typeScopedMetric, executionCntx, OutputStrategyExt.OutputStrategyRegistryExt.instance(context, null), rubyArgs});
            }
            if (type == PluginLookup.PluginType.FILTER) {
                return PluginFactoryExt.filterDelegator(context, null, new IRubyObject[]{this.filterDelegatorClass, klass, rubyArgs, typeScopedMetric, executionCntx});
            }
            IRubyObject pluginInstance = ContextualizerExt.initializePlugin(context, executionCntx, klass, rubyArgs);
            AbstractNamespacedMetricExt scopedMetric = typeScopedMetric.namespace(context, (IRubyObject)RubyUtil.RUBY.newString(id).intern());
            scopedMetric.gauge(context, (IRubyObject)MetricKeys.NAME_KEY, pluginInstance.callMethod(context, "config_name"));
            pluginInstance.callMethod(context, "metric=", (IRubyObject)scopedMetric);
            return pluginInstance;
        }
        AbstractPluginCreator<? extends Plugin> pluginCreator = this.pluginCreatorsRegistry.get((Object)type);
        if (pluginCreator == null) {
            throw new IllegalStateException("Unable to create plugin: " + pluginClass.toReadableString());
        }
        Context contextWithMetrics = this.executionContextFactory.toContext(type, this.metrics.getRoot(context));
        return pluginCreator.createDelegator(name, this.convertToJavaCoercible((Map<String, Object>)args), id, typeScopedMetric, pluginClass, contextWithMetrics);
    }

    private Map<String, Object> convertToJavaCoercible(Map<String, Object> input) {
        HashMap<String, Object> output = new HashMap<String, Object>(input);
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            Object unwrapped;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof IRubyObject) || !((unwrapped = JavaUtil.unwrapJavaValue((IRubyObject)((IRubyObject)value))) instanceof Codec)) continue;
            output.put(key, unwrapped);
        }
        return output;
    }

    private String generateOrRetrievePluginId(PluginLookup.PluginType type, SourceWithMetadata source, Map<String, ?> args) {
        Optional<String> unprocessedId = source == null ? this.extractId(() -> this.extractIdFromArgs(args), this::generateUUID) : this.extractId(() -> this.extractIdFromLIR(source), () -> this.extractIdFromArgs(args), () -> this.generateUUIDForCodecs(type));
        return unprocessedId.map(this.configVariables::expand).filter(String.class::isInstance).map(String.class::cast).orElse(null);
    }

    private Optional<String> extractId(IdExtractor ... extractors) {
        for (IdExtractor extractor : extractors) {
            Optional<String> extracted = extractor.extract();
            if (!extracted.isPresent()) continue;
            return extracted;
        }
        return Optional.empty();
    }

    private Optional<String> extractIdFromArgs(Map<String, ?> args) {
        if (!args.containsKey("id")) {
            return Optional.empty();
        }
        Object explicitId = args.get("id");
        if (explicitId instanceof String) {
            return Optional.of((String)explicitId);
        }
        if (explicitId instanceof RubyString) {
            return Optional.of(((RubyString)explicitId).asJavaString());
        }
        return Optional.empty();
    }

    private Optional<String> generateUUID() {
        return Optional.of(UUID.randomUUID().toString());
    }

    private Optional<String> generateUUIDForCodecs(PluginLookup.PluginType pluginType) {
        if (pluginType == PluginLookup.PluginType.CODEC) {
            return this.generateUUID();
        }
        return Optional.empty();
    }

    private Optional<String> extractIdFromLIR(SourceWithMetadata source) {
        return this.lir.getGraph().vertices().filter(v -> v.getSourceWithMetadata() != null && v.getSourceWithMetadata().equalsWithoutText(source)).findFirst().map(Vertex::getId);
    }

    ExecutionContextFactoryExt getExecutionContextFactory() {
        return this.executionContextFactory;
    }

    @FunctionalInterface
    public static interface PluginResolver {
        public PluginLookup.PluginClass resolve(PluginLookup.PluginType var1, String var2);
    }

    @FunctionalInterface
    static interface IdExtractor {
        public Optional<String> extract();
    }
}

