"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsService = void 0;
var _ = require(".");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class MetricsService {
  constructor(logger) {
    this.logger = logger;
    _defineProperty(this, "interval", _.METRIC_INTERVAL.ONE_MINUTE);
    _defineProperty(this, "windowSize", _.DEFAULT_WINDOW_SIZE);
    _defineProperty(this, "data", {});
    _defineProperty(this, "componentCounts", {});
    _defineProperty(this, "statusCodeCounts", {});
    _defineProperty(this, "overall", {});
  }
  setup(interval = _.METRIC_INTERVAL.ONE_MINUTE, windowSize = _.DEFAULT_WINDOW_SIZE) {
    this.interval = interval;
    this.windowSize = windowSize;
    const addMetric = (componentName, action, statusCode, value) => {
      const currInterval = Math.floor(Date.now() / this.interval);
      this.trim();
      if (!this.data[currInterval]) {
        this.data[currInterval] = {};
        this.overall[currInterval] = {
          response_time_total: 0,
          count: 0
        };
        this.componentCounts[currInterval] = {};
        this.statusCodeCounts[currInterval] = {};
      }
      if (!this.data[currInterval][componentName]) {
        this.data[currInterval][componentName] = {};
        this.componentCounts[currInterval][componentName] = 0;
      }
      if (!this.statusCodeCounts[currInterval][statusCode]) {
        this.statusCodeCounts[currInterval][statusCode] = 0;
      }
      if (!this.data[currInterval][componentName][action]) {
        this.data[currInterval][componentName][action] = {};
      }
      if (!this.data[currInterval][componentName][action][statusCode]) {
        this.data[currInterval][componentName][action][statusCode] = {
          response_time_total: 0,
          count: 0
        };
      }
      const {
        response_time_total,
        count
      } = this.data[currInterval][componentName][action][statusCode];
      this.data[currInterval][componentName][action][statusCode] = {
        response_time_total: response_time_total + value,
        count: count + 1
      };
      this.componentCounts[currInterval][componentName]++;
      this.statusCodeCounts[currInterval][statusCode]++;
      this.overall[currInterval].response_time_total += value;
      this.overall[currInterval].count++;
    };
    const getStats = () => {
      const prevInterval = Math.floor(Date.now() / this.interval) - 1;
      const data = {
        ...this.data[prevInterval]
      } || {};
      const overall = {
        ...this.overall[prevInterval]
      } || {};
      let requestsPerSecond = 0,
        responseTimeAvg = 0;
      if (Object.keys(overall).length !== 0 && overall.count !== 0) {
        responseTimeAvg = overall.response_time_total / overall.count;
        requestsPerSecond = overall.count / (this.interval / 1000);
      }
      return {
        data,
        overall: {
          response_time_avg: responseTimeAvg,
          requests_per_second: requestsPerSecond
        },
        counts_by_component: {
          ...this.componentCounts[prevInterval]
        } || {},
        counts_by_status_code: {
          ...this.statusCodeCounts[prevInterval]
        } || {}
      };
    };
    return {
      addMetric,
      getStats
    };
  }
  start() {}
  stop() {
    this.resetMetrics();
  }
  resetMetrics() {
    this.data = {};
    this.overall = {};
    this.componentCounts = {};
    this.statusCodeCounts = {};
  }
  trim() {
    const oldestTimestampToKeep = Math.floor((Date.now() - this.windowSize * this.interval) / this.interval);
    for (const timestampStr in this.data) {
      const timestamp = parseInt(timestampStr);
      if (timestamp < oldestTimestampToKeep) {
        delete this.data[timestamp];
      }
    }
  }
}
exports.MetricsService = MetricsService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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