/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec4(-64, 72, 88, -76) | (- abs(12))) => ivec4(-12, -4, -4, -12)
 * (ivec4(-64, 72, 88, -76) | (- abs(-6))) => ivec4(-6, -6, -6, -2)
 * (ivec4(-64, 72, 88, -76) | (- abs(76))) => ivec4(-12, -4, -4, -76)
 * (ivec4(-64, 72, 88, -76) | (- abs(-32))) => ivec4(-32, -24, -8, -12)
 * (ivec4(-64, 72, 88, -76) | (- abs(0))) => ivec4(-64, 72, 88, -76)
 * (ivec4(64, 72, 88, 76) | (- abs(12))) => ivec4(-12, -4, -4, -4)
 * (ivec4(64, 72, 88, 76) | (- abs(-6))) => ivec4(-6, -6, -6, -2)
 * (ivec4(64, 72, 88, 76) | (- abs(76))) => ivec4(-12, -4, -4, -4)
 * (ivec4(64, 72, 88, 76) | (- abs(-32))) => ivec4(-32, -24, -8, -20)
 * (ivec4(64, 72, 88, 76) | (- abs(0))) => ivec4(64, 72, 88, 76)
 * (ivec4(-24, 40, -23, 64) | (- abs(12))) => ivec4(-4, -4, -3, -12)
 * (ivec4(-24, 40, -23, 64) | (- abs(-6))) => ivec4(-6, -6, -5, -6)
 * (ivec4(-24, 40, -23, 64) | (- abs(76))) => ivec4(-4, -68, -3, -12)
 * (ivec4(-24, 40, -23, 64) | (- abs(-32))) => ivec4(-24, -24, -23, -32)
 * (ivec4(-24, 40, -23, 64) | (- abs(0))) => ivec4(-24, 40, -23, 64)
 * (ivec4(24, 40, 23, 64) | (- abs(12))) => ivec4(-4, -4, -9, -12)
 * (ivec4(24, 40, 23, 64) | (- abs(-6))) => ivec4(-6, -6, -1, -6)
 * (ivec4(24, 40, 23, 64) | (- abs(76))) => ivec4(-68, -68, -73, -12)
 * (ivec4(24, 40, 23, 64) | (- abs(-32))) => ivec4(-8, -24, -9, -32)
 * (ivec4(24, 40, 23, 64) | (- abs(0))) => ivec4(24, 40, 23, 64)
 */
#version 150

void main()
{
  float[all(equal((ivec4(-64, 72, 88, -76) | (- abs(12))), ivec4(-12, -4, -4, -12))) ? 1 : -1] array0;
  float[all(equal((ivec4(-64, 72, 88, -76) | (- abs(-6))), ivec4(-6, -6, -6, -2))) ? 1 : -1] array1;
  float[all(equal((ivec4(-64, 72, 88, -76) | (- abs(76))), ivec4(-12, -4, -4, -76))) ? 1 : -1] array2;
  float[all(equal((ivec4(-64, 72, 88, -76) | (- abs(-32))), ivec4(-32, -24, -8, -12))) ? 1 : -1] array3;
  float[all(equal((ivec4(-64, 72, 88, -76) | (- abs(0))), ivec4(-64, 72, 88, -76))) ? 1 : -1] array4;
  float[all(equal((ivec4(64, 72, 88, 76) | (- abs(12))), ivec4(-12, -4, -4, -4))) ? 1 : -1] array5;
  float[all(equal((ivec4(64, 72, 88, 76) | (- abs(-6))), ivec4(-6, -6, -6, -2))) ? 1 : -1] array6;
  float[all(equal((ivec4(64, 72, 88, 76) | (- abs(76))), ivec4(-12, -4, -4, -4))) ? 1 : -1] array7;
  float[all(equal((ivec4(64, 72, 88, 76) | (- abs(-32))), ivec4(-32, -24, -8, -20))) ? 1 : -1] array8;
  float[all(equal((ivec4(64, 72, 88, 76) | (- abs(0))), ivec4(64, 72, 88, 76))) ? 1 : -1] array9;
  float[all(equal((ivec4(-24, 40, -23, 64) | (- abs(12))), ivec4(-4, -4, -3, -12))) ? 1 : -1] array10;
  float[all(equal((ivec4(-24, 40, -23, 64) | (- abs(-6))), ivec4(-6, -6, -5, -6))) ? 1 : -1] array11;
  float[all(equal((ivec4(-24, 40, -23, 64) | (- abs(76))), ivec4(-4, -68, -3, -12))) ? 1 : -1] array12;
  float[all(equal((ivec4(-24, 40, -23, 64) | (- abs(-32))), ivec4(-24, -24, -23, -32))) ? 1 : -1] array13;
  float[all(equal((ivec4(-24, 40, -23, 64) | (- abs(0))), ivec4(-24, 40, -23, 64))) ? 1 : -1] array14;
  float[all(equal((ivec4(24, 40, 23, 64) | (- abs(12))), ivec4(-4, -4, -9, -12))) ? 1 : -1] array15;
  float[all(equal((ivec4(24, 40, 23, 64) | (- abs(-6))), ivec4(-6, -6, -1, -6))) ? 1 : -1] array16;
  float[all(equal((ivec4(24, 40, 23, 64) | (- abs(76))), ivec4(-68, -68, -73, -12))) ? 1 : -1] array17;
  float[all(equal((ivec4(24, 40, 23, 64) | (- abs(-32))), ivec4(-8, -24, -9, -32))) ? 1 : -1] array18;
  float[all(equal((ivec4(24, 40, 23, 64) | (- abs(0))), ivec4(24, 40, 23, 64))) ? 1 : -1] array19;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
