/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.jediterm.core.compatibility.Point;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalSelection;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;

public class SelectionUtil {
    private static final List<Character> SEPARATORS = new ArrayList<Character>();

    public static Pair<Point, Point> sortPoints(Point a, Point b) {
        if (a.y == b.y) {
            return new Pair((Object)(a.x <= b.x ? a : b), (Object)(a.x > b.x ? a : b));
        }
        return new Pair((Object)(a.y < b.y ? a : b), (Object)(a.y > b.y ? a : b));
    }

    public static String getSelectionText(TerminalSelection selection, TerminalTextBuffer terminalTextBuffer) {
        return SelectionUtil.getSelectionText(selection.getStart(), selection.getEnd(), terminalTextBuffer);
    }

    @NotNull
    public static String getSelectionText(@NotNull Point selectionStart, @NotNull Point selectionEnd, @NotNull TerminalTextBuffer terminalTextBuffer) {
        Pair<Point, Point> pair = SelectionUtil.sortPoints(selectionStart, selectionEnd);
        ((Point)pair.getFirst()).y = Math.max(((Point)pair.getFirst()).y, -terminalTextBuffer.getHistoryLinesCount());
        pair = SelectionUtil.sortPoints((Point)pair.getFirst(), (Point)pair.getSecond());
        Point top = (Point)pair.getFirst();
        Point bottom = (Point)pair.getSecond();
        StringBuilder selectionText = new StringBuilder();
        for (int i = top.y; i <= bottom.y; ++i) {
            TerminalLine line = terminalTextBuffer.getLine(i);
            String text = line.getText();
            if (i == top.y) {
                if (i == bottom.y) {
                    selectionText.append(SelectionUtil.processForSelection(text.substring(Math.min(text.length(), top.x), Math.min(text.length(), bottom.x))));
                } else {
                    selectionText.append(SelectionUtil.processForSelection(text.substring(Math.min(text.length(), top.x))));
                }
            } else if (i == bottom.y) {
                selectionText.append(SelectionUtil.processForSelection(text.substring(0, Math.min(text.length(), bottom.x))));
            } else {
                selectionText.append(SelectionUtil.processForSelection(line.getText()));
            }
            if ((line.isWrapped() || i >= bottom.y) && bottom.x <= text.length()) continue;
            selectionText.append("\n");
        }
        return selectionText.toString();
    }

    private static String processForSelection(String text) {
        if (text.indexOf(57344) != 0) {
            StringBuilder sb = new StringBuilder();
            for (char c : text.toCharArray()) {
                if (c == '\ue000') continue;
                sb.append(c);
            }
            return sb.toString();
        }
        return text;
    }

    public static Point getPreviousSeparator(Point charCoords, TerminalTextBuffer terminalTextBuffer) {
        return SelectionUtil.getPreviousSeparator(charCoords, terminalTextBuffer, SEPARATORS);
    }

    public static Point getPreviousSeparator(Point charCoords, TerminalTextBuffer terminalTextBuffer, @NotNull List<Character> separators) {
        int x = charCoords.x;
        int y = charCoords.y;
        int terminalWidth = terminalTextBuffer.getWidth();
        if (separators.contains(Character.valueOf(terminalTextBuffer.getBuffersCharAt(x, y)))) {
            return new Point(x, y);
        }
        String line = terminalTextBuffer.getLine(y).getText();
        while (x < line.length() && !separators.contains(Character.valueOf(line.charAt(x)))) {
            if (--x >= 0) continue;
            if (y <= -terminalTextBuffer.getHistoryLinesCount()) {
                return new Point(0, y);
            }
            x = terminalWidth - 1;
            line = terminalTextBuffer.getLine(--y).getText();
        }
        if (++x >= terminalWidth) {
            ++y;
            x = 0;
        }
        return new Point(x, y);
    }

    public static Point getNextSeparator(Point charCoords, TerminalTextBuffer terminalTextBuffer) {
        return SelectionUtil.getNextSeparator(charCoords, terminalTextBuffer, SEPARATORS);
    }

    public static Point getNextSeparator(Point charCoords, TerminalTextBuffer terminalTextBuffer, @NotNull List<Character> separators) {
        int x = charCoords.x;
        int y = charCoords.y;
        int terminalWidth = terminalTextBuffer.getWidth();
        int terminalHeight = terminalTextBuffer.getHeight();
        if (separators.contains(Character.valueOf(terminalTextBuffer.getBuffersCharAt(x, y)))) {
            return new Point(x, y);
        }
        String line = terminalTextBuffer.getLine(y).getText();
        while (x < line.length() && !separators.contains(Character.valueOf(line.charAt(x)))) {
            if (++x < terminalWidth) continue;
            if (y >= terminalHeight - 1) {
                return new Point(terminalWidth - 1, terminalHeight - 1);
            }
            x = 0;
            line = terminalTextBuffer.getLine(++y).getText();
        }
        if (--x < 0) {
            --y;
            x = terminalWidth - 1;
        }
        return new Point(x, y);
    }

    static {
        SEPARATORS.add(Character.valueOf(' '));
        SEPARATORS.add(Character.valueOf('\u00a0'));
        SEPARATORS.add(Character.valueOf('\t'));
        SEPARATORS.add(Character.valueOf('\''));
        SEPARATORS.add(Character.valueOf('\"'));
        SEPARATORS.add(Character.valueOf('$'));
        SEPARATORS.add(Character.valueOf('('));
        SEPARATORS.add(Character.valueOf(')'));
        SEPARATORS.add(Character.valueOf('['));
        SEPARATORS.add(Character.valueOf(']'));
        SEPARATORS.add(Character.valueOf('{'));
        SEPARATORS.add(Character.valueOf('}'));
        SEPARATORS.add(Character.valueOf('<'));
        SEPARATORS.add(Character.valueOf('>'));
    }
}

