/*
 * Decompiled with CFR 0.152.
 */
package coil3.decode;

import coil3.size.Dimension;
import coil3.size.Scale;
import coil3.size.Size;
import coil3.size.SizeKt;
import coil3.util.IntPair;
import coil3.util.UtilsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007J0\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007J0\u0010\f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0007J0\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0007J7\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0014\u0010\u0016\u001a\u00020\u0005*\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0018"}, d2={"Lcoil3/decode/DecodeUtils;", "", "<init>", "()V", "calculateInSampleSize", "", "srcWidth", "srcHeight", "dstWidth", "dstHeight", "scale", "Lcoil3/size/Scale;", "computeSizeMultiplier", "", "", "computeDstSize", "Lcoil3/util/IntPair;", "targetSize", "Lcoil3/size/Size;", "maxSize", "computeDstSize-sEdh43o", "(IILcoil3/size/Size;Lcoil3/size/Scale;Lcoil3/size/Size;)J", "toPx", "Lcoil3/size/Dimension;", "coil-core"})
@SourceDebugExtension(value={"SMAP\nDecodeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecodeUtils.kt\ncoil3/decode/DecodeUtils\n+ 2 Dimension.kt\ncoil3/size/DimensionKt\n*L\n1#1,127:1\n43#2:128\n*S KotlinDebug\n*F\n+ 1 DecodeUtils.kt\ncoil3/decode/DecodeUtils\n*L\n120#1:128\n*E\n"})
public final class DecodeUtils {
    @NotNull
    public static final DecodeUtils INSTANCE = new DecodeUtils();

    private DecodeUtils() {
    }

    @JvmStatic
    public static final int calculateInSampleSize(int srcWidth, int srcHeight, int dstWidth, int dstHeight, @NotNull Scale scale) {
        int n;
        int widthInSampleSize = Integer.highestOneBit(srcWidth / dstWidth);
        int heightInSampleSize = Integer.highestOneBit(srcHeight / dstHeight);
        switch (WhenMappings.$EnumSwitchMapping$0[scale.ordinal()]) {
            case 1: {
                n = Math.min(widthInSampleSize, heightInSampleSize);
                break;
            }
            case 2: {
                n = Math.max(widthInSampleSize, heightInSampleSize);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return RangesKt.coerceAtLeast((int)n, (int)1);
    }

    @JvmStatic
    public static final double computeSizeMultiplier(int srcWidth, int srcHeight, int dstWidth, int dstHeight, @NotNull Scale scale) {
        double d;
        double widthPercent = (double)dstWidth / (double)srcWidth;
        double heightPercent = (double)dstHeight / (double)srcHeight;
        switch (WhenMappings.$EnumSwitchMapping$0[scale.ordinal()]) {
            case 1: {
                d = Math.max(widthPercent, heightPercent);
                break;
            }
            case 2: {
                d = Math.min(widthPercent, heightPercent);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    @JvmStatic
    public static final float computeSizeMultiplier(float srcWidth, float srcHeight, float dstWidth, float dstHeight, @NotNull Scale scale) {
        float f;
        float widthPercent = dstWidth / srcWidth;
        float heightPercent = dstHeight / srcHeight;
        switch (WhenMappings.$EnumSwitchMapping$0[scale.ordinal()]) {
            case 1: {
                f = Math.max(widthPercent, heightPercent);
                break;
            }
            case 2: {
                f = Math.min(widthPercent, heightPercent);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    @JvmStatic
    public static final double computeSizeMultiplier(double srcWidth, double srcHeight, double dstWidth, double dstHeight, @NotNull Scale scale) {
        double d;
        double widthPercent = dstWidth / srcWidth;
        double heightPercent = dstHeight / srcHeight;
        switch (WhenMappings.$EnumSwitchMapping$0[scale.ordinal()]) {
            case 1: {
                d = Math.max(widthPercent, heightPercent);
                break;
            }
            case 2: {
                d = Math.min(widthPercent, heightPercent);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    @JvmStatic
    public static final long computeDstSize-sEdh43o(int srcWidth, int srcHeight, @NotNull Size targetSize, @NotNull Scale scale, @NotNull Size maxSize) {
        int dstWidth = 0;
        int dstHeight = 0;
        if (SizeKt.isOriginal(targetSize)) {
            dstWidth = srcWidth;
            dstHeight = srcHeight;
        } else {
            dstWidth = INSTANCE.toPx(targetSize.getWidth(), scale);
            dstHeight = INSTANCE.toPx(targetSize.getHeight(), scale);
        }
        if (maxSize.getWidth() instanceof Dimension.Pixels && !UtilsKt.isMinOrMax(dstWidth)) {
            dstWidth = RangesKt.coerceAtMost((int)dstWidth, (int)((Dimension.Pixels)maxSize.getWidth()).unbox-impl());
        }
        if (maxSize.getHeight() instanceof Dimension.Pixels && !UtilsKt.isMinOrMax(dstHeight)) {
            dstHeight = RangesKt.coerceAtMost((int)dstHeight, (int)((Dimension.Pixels)maxSize.getHeight()).unbox-impl());
        }
        return IntPair.constructor-impl(dstWidth, dstHeight);
    }

    private final int toPx(Dimension $this$toPx, Scale scale) {
        int n;
        Dimension $this$pxOrElse$iv = $this$toPx;
        boolean $i$f$pxOrElse = false;
        if ($this$pxOrElse$iv instanceof Dimension.Pixels) {
            n = ((Dimension.Pixels)$this$pxOrElse$iv).unbox-impl();
        } else {
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[scale.ordinal()]) {
                case 1: {
                    n = Integer.MIN_VALUE;
                    break;
                }
                case 2: {
                    n = Integer.MAX_VALUE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return n;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Scale.values().length];
            try {
                nArray[Scale.FILL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scale.FIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

