/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.tasks;

import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GHAccountsUtil;
import org.jetbrains.plugins.github.authentication.GHLoginData;
import org.jetbrains.plugins.github.authentication.GHLoginRequest;
import org.jetbrains.plugins.github.authentication.GHLoginSource;
import org.jetbrains.plugins.github.authentication.ui.GHLoginModel;
import org.jetbrains.plugins.github.exceptions.GithubParseException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u0005H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/tasks/GHRepositoryEditor;", "", "<init>", "()V", "askToken", "", "project", "Lcom/intellij/openapi/project/Project;", "host", "tryParse", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "intellij.vcs.github.tracker"})
public final class GHRepositoryEditor {
    @NotNull
    public static final GHRepositoryEditor INSTANCE = new GHRepositoryEditor();

    private GHRepositoryEditor() {
    }

    @Nullable
    public final String askToken(@NotNull Project project, @NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        GithubServerPath githubServerPath = this.tryParse(host);
        if (githubServerPath == null) {
            return null;
        }
        GithubServerPath server = githubServerPath;
        var model2 = new GHLoginModel(){
            private String token;

            public final String getToken() {
                return this.token;
            }

            public final void setToken(String string) {
                this.token = string;
            }

            public boolean isAccountUnique(GithubServerPath server, String login) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)login, (String)"login");
                return true;
            }

            public Object saveLogin(GithubServerPath server, String login, String token, Continuation<? super Unit> $completion) {
                this.token = token;
                return Unit.INSTANCE;
            }
        };
        GHAccountsUtil.login((GHLoginModel)model2, (GHLoginRequest)new GHLoginRequest(null, null, server, false, null, false, null, new GHLoginData(GHLoginSource.TRACKER, false, null, null, 14, null), 123, null), (Project)project, null);
        return model2.getToken();
    }

    private final GithubServerPath tryParse(String host) {
        GithubServerPath githubServerPath;
        try {
            githubServerPath = GithubServerPath.from((String)host);
        }
        catch (GithubParseException ignored) {
            githubServerPath = null;
        }
        return githubServerPath;
    }
}

