/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.utils;

import com.intellij.grazie.utils.Text;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class NaturalTextDetector {
    public static boolean seemsNatural(CharSequence text) {
        int spaceCount = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c2 = text.charAt(i);
            if (c2 == ' ' && ++spaceCount > 3) {
                return true;
            }
            if (Character.getType(c2) != 5) continue;
            return true;
        }
        if (spaceCount < 1) {
            return false;
        }
        if (spaceCount == 1) {
            return text.chars().noneMatch(c -> Text.INSTANCE.isPunctuation((char)c));
        }
        return text.chars().allMatch(NaturalTextDetector::isExpectedInText);
    }

    private static boolean isExpectedInText(int c) {
        return Character.isWhitespace(c) || Character.isLetterOrDigit(c) || Text.INSTANCE.isPunctuation((char)c);
    }
}

