/*
 * Decompiled with CFR 0.152.
 */
package scala.math;

import java.io.Serializable;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.Enumeration;
import scala.Float$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Range$BigDecimal$;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.Ordered;
import scala.math.ScalaNumber;
import scala.math.ScalaNumericAnyConversions;
import scala.math.ScalaNumericConversions;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichFloat$;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

public final class BigDecimal
extends ScalaNumber
implements ScalaNumericConversions,
Ordered<BigDecimal> {
    private final java.math.BigDecimal bigDecimal;
    private final MathContext mc;
    private int computedHashCode;

    public static BigDecimal binary(double d) {
        return BigDecimal$.MODULE$.binary(d);
    }

    public static BigDecimal binary(double d, MathContext mathContext) {
        return BigDecimal$.MODULE$.binary(d, mathContext);
    }

    public static BigDecimal decimal(java.math.BigDecimal bigDecimal, MathContext mathContext) {
        return BigDecimal$.MODULE$.decimal(bigDecimal, mathContext);
    }

    public static BigDecimal decimal(double d) {
        return BigDecimal$.MODULE$.decimal(d);
    }

    public static BigDecimal decimal(double d, MathContext mathContext) {
        return BigDecimal$.MODULE$.decimal(d, mathContext);
    }

    public static BigDecimal decimal(float f) {
        return BigDecimal$.MODULE$.decimal(f);
    }

    public static BigDecimal decimal(float f, MathContext mathContext) {
        return BigDecimal$.MODULE$.decimal(f, mathContext);
    }

    public static BigDecimal decimal(long l) {
        return BigDecimal$.MODULE$.decimal(l);
    }

    public static BigDecimal decimal(long l, MathContext mathContext) {
        return BigDecimal$.MODULE$.decimal(l, mathContext);
    }

    public static MathContext defaultMathContext() {
        return BigDecimal$.MODULE$.defaultMathContext();
    }

    public static BigDecimal double2bigDecimal(double d) {
        return BigDecimal$.MODULE$.double2bigDecimal(d);
    }

    public static BigDecimal exact(java.math.BigDecimal bigDecimal) {
        return BigDecimal$.MODULE$.exact(bigDecimal);
    }

    public static BigDecimal exact(BigInt bigInt) {
        return BigDecimal$.MODULE$.exact(bigInt);
    }

    public static BigDecimal exact(char[] cArray) {
        return BigDecimal$.MODULE$.exact(cArray);
    }

    public static BigDecimal exact(double d) {
        return BigDecimal$.MODULE$.exact(d);
    }

    public static BigDecimal exact(long l) {
        return BigDecimal$.MODULE$.exact(l);
    }

    public static BigDecimal exact(String string2) {
        return BigDecimal$.MODULE$.exact(string2);
    }

    public static BigDecimal int2bigDecimal(int n) {
        return BigDecimal$.MODULE$.int2bigDecimal(n);
    }

    public static BigDecimal javaBigDecimal2bigDecimal(java.math.BigDecimal bigDecimal) {
        return BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(bigDecimal);
    }

    public static BigDecimal long2bigDecimal(long l) {
        return BigDecimal$.MODULE$.long2bigDecimal(l);
    }

    public static BigDecimal valueOf(double d) {
        return BigDecimal$.MODULE$.valueOf(d);
    }

    public static BigDecimal valueOf(long l) {
        return BigDecimal$.MODULE$.valueOf(l);
    }

    public BigDecimal(java.math.BigDecimal bigDecimal, MathContext mc) {
        this.bigDecimal = bigDecimal;
        this.mc = mc;
        ScalaNumericAnyConversions.$init$(this);
        Ordered.$init$(this);
        if (bigDecimal == null) {
            throw new IllegalArgumentException("null value for BigDecimal");
        }
        if (mc == null) {
            throw new IllegalArgumentException("null MathContext for BigDecimal");
        }
        this.computedHashCode = 1565550863;
    }

    @Override
    public char toChar() {
        return ScalaNumericAnyConversions.toChar$(this);
    }

    @Override
    public byte toByte() {
        return ScalaNumericAnyConversions.toByte$(this);
    }

    @Override
    public short toShort() {
        return ScalaNumericAnyConversions.toShort$(this);
    }

    @Override
    public int toInt() {
        return ScalaNumericAnyConversions.toInt$(this);
    }

    @Override
    public long toLong() {
        return ScalaNumericAnyConversions.toLong$(this);
    }

    @Override
    public float toFloat() {
        return ScalaNumericAnyConversions.toFloat$(this);
    }

    @Override
    public double toDouble() {
        return ScalaNumericAnyConversions.toDouble$(this);
    }

    @Override
    public int unifiedPrimitiveHashcode() {
        return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$(this);
    }

    @Override
    public boolean unifiedPrimitiveEquals(Object x) {
        return ScalaNumericAnyConversions.unifiedPrimitiveEquals$(this, x);
    }

    @Override
    public boolean $less(Object that) {
        return Ordered.$less$(this, that);
    }

    @Override
    public boolean $greater(Object that) {
        return Ordered.$greater$(this, that);
    }

    @Override
    public boolean $less$eq(Object that) {
        return Ordered.$less$eq$(this, that);
    }

    @Override
    public boolean $greater$eq(Object that) {
        return Ordered.$greater$eq$(this, that);
    }

    @Override
    public int compareTo(Object that) {
        return Ordered.compareTo$(this, that);
    }

    public java.math.BigDecimal bigDecimal() {
        return this.bigDecimal;
    }

    public MathContext mc() {
        return this.mc;
    }

    public BigDecimal(java.math.BigDecimal bigDecimal) {
        this(bigDecimal, BigDecimal$.MODULE$.defaultMathContext());
    }

    private final void computeHashCode() {
        int n;
        if (this.isWhole() && this.precision() - this.scale() < 4934) {
            n = this.toBigInt().hashCode();
        } else if (this.isDecimalDouble()) {
            n = Statics.doubleHash(this.doubleValue());
        } else {
            java.math.BigDecimal temp = this.bigDecimal().stripTrailingZeros();
            n = MurmurHash3$.MODULE$.mixLast(temp.scaleByPowerOfTen(temp.scale()).toBigInteger().hashCode(), temp.scale());
        }
        this.computedHashCode = n;
    }

    public int hashCode() {
        if (this.computedHashCode == 1565550863) {
            this.computeHashCode();
        }
        return this.computedHashCode;
    }

    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal;
            BigDecimal that2 = bigDecimal = (BigDecimal)object;
            return this.equals(that2);
        }
        if (object instanceof BigInt) {
            BigInt bigInt = (BigInt)object;
            BigInt that3 = bigInt;
            return (double)that3.bitLength() > (double)(this.precision() - this.scale() - 2) * 3.3219280948873626 && this.toBigIntExact().exists((Function1<BigInt, Object>)(Function1<BigInt, Boolean> & Serializable)_$1 -> that3.equals((BigInt)_$1));
        }
        if (object instanceof Double) {
            double d;
            double d2 = BoxesRunTime.unboxToDouble(object);
            double that4 = d2;
            return !RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(that4)) && !RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(d = this.toDouble())) && d == that4 && this.equals(BigDecimal$.MODULE$.decimal(d));
        }
        if (object instanceof Float) {
            float f;
            float f2 = BoxesRunTime.unboxToFloat(object);
            float that5 = f2;
            return !RichFloat$.MODULE$.isInfinity$extension(Predef$.MODULE$.floatWrapper(that5)) && !RichFloat$.MODULE$.isInfinity$extension(Predef$.MODULE$.floatWrapper(f = this.toFloat())) && f == that5 && this.equals(BigDecimal$.MODULE$.decimal((double)f));
        }
        return this.isValidLong() && this.unifiedPrimitiveEquals(that);
    }

    @Override
    public boolean isValidByte() {
        return this.noArithmeticException((Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
            this.isValidByte$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean isValidShort() {
        return this.noArithmeticException((Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
            this.isValidShort$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean isValidChar() {
        return this.isValidInt() && this.toIntExact() >= 0 && this.toIntExact() <= 65535;
    }

    @Override
    public boolean isValidInt() {
        return this.noArithmeticException((Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
            this.isValidInt$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public boolean isValidLong() {
        return this.noArithmeticException((Function0<BoxedUnit>)(Function0<Object> & Serializable)() -> {
            this.isValidLong$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public boolean isDecimalDouble() {
        double d = this.toDouble();
        return !RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(d)) && this.equals(BigDecimal$.MODULE$.decimal(d));
    }

    public boolean isDecimalFloat() {
        float f = this.toFloat();
        return !RichFloat$.MODULE$.isInfinity$extension(Predef$.MODULE$.floatWrapper(f)) && this.equals(BigDecimal$.MODULE$.decimal(f));
    }

    public boolean isBinaryDouble() {
        double d = this.toDouble();
        return !RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(d)) && this.equals(BigDecimal$.MODULE$.binary(d, this.mc()));
    }

    public boolean isBinaryFloat() {
        float f = this.toFloat();
        return !RichFloat$.MODULE$.isInfinity$extension(Predef$.MODULE$.floatWrapper(f)) && this.equals(BigDecimal$.MODULE$.binary(Float$.MODULE$.float2double(f), this.mc()));
    }

    public boolean isExactDouble() {
        double d = this.toDouble();
        return !RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(d)) && this.equals(BigDecimal$.MODULE$.exact(d));
    }

    public boolean isExactFloat() {
        float f = this.toFloat();
        return !RichFloat$.MODULE$.isInfinity$extension(Predef$.MODULE$.floatWrapper(f)) && this.equals(BigDecimal$.MODULE$.exact(f));
    }

    private boolean noArithmeticException(Function0<BoxedUnit> body) {
        boolean bl;
        try {
            body.apply();
            bl = true;
        }
        catch (ArithmeticException arithmeticException) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isWhole() {
        return this.scale() <= 0 || this.bigDecimal().stripTrailingZeros().scale() <= 0;
    }

    @Override
    public java.math.BigDecimal underlying() {
        return this.bigDecimal();
    }

    public boolean equals(BigDecimal that) {
        return this.compare(that) == 0;
    }

    @Override
    public int compare(BigDecimal that) {
        return this.bigDecimal().compareTo(that.bigDecimal());
    }

    public BigDecimal $plus(BigDecimal that) {
        return new BigDecimal(this.bigDecimal().add(that.bigDecimal(), this.mc()), this.mc());
    }

    public BigDecimal $minus(BigDecimal that) {
        return new BigDecimal(this.bigDecimal().subtract(that.bigDecimal(), this.mc()), this.mc());
    }

    public BigDecimal $times(BigDecimal that) {
        return new BigDecimal(this.bigDecimal().multiply(that.bigDecimal(), this.mc()), this.mc());
    }

    public BigDecimal $div(BigDecimal that) {
        return new BigDecimal(this.bigDecimal().divide(that.bigDecimal(), this.mc()), this.mc());
    }

    public Tuple2<BigDecimal, BigDecimal> $div$percent(BigDecimal that) {
        java.math.BigDecimal[] qr = this.bigDecimal().divideAndRemainder(that.bigDecimal(), this.mc());
        return Tuple2$.MODULE$.apply(new BigDecimal(qr[0], this.mc()), new BigDecimal(qr[1], this.mc()));
    }

    public BigDecimal quot(BigDecimal that) {
        return new BigDecimal(this.bigDecimal().divideToIntegralValue(that.bigDecimal(), this.mc()), this.mc());
    }

    public BigDecimal min(BigDecimal that) {
        int n = this.compare(that);
        int x = n;
        if (x <= 0) {
            return this;
        }
        return that;
    }

    public BigDecimal max(BigDecimal that) {
        int n = this.compare(that);
        int x = n;
        if (x >= 0) {
            return this;
        }
        return that;
    }

    public BigDecimal remainder(BigDecimal that) {
        return new BigDecimal(this.bigDecimal().remainder(that.bigDecimal(), this.mc()), this.mc());
    }

    public BigDecimal $percent(BigDecimal that) {
        return this.remainder(that);
    }

    public BigDecimal pow(int n) {
        return new BigDecimal(this.bigDecimal().pow(n, this.mc()), this.mc());
    }

    public BigDecimal unary_$minus() {
        return new BigDecimal(this.bigDecimal().negate(this.mc()), this.mc());
    }

    public BigDecimal abs() {
        if (this.signum() < 0) {
            return this.unary_$minus();
        }
        return this;
    }

    public int signum() {
        return this.bigDecimal().signum();
    }

    public BigDecimal sign() {
        return BigDecimal$.MODULE$.int2bigDecimal(this.signum());
    }

    public int precision() {
        return this.bigDecimal().precision();
    }

    public BigDecimal round(MathContext mc) {
        java.math.BigDecimal r = this.bigDecimal().round(mc);
        if (r == this.bigDecimal()) {
            return this;
        }
        return new BigDecimal(r, this.mc());
    }

    public BigDecimal rounded() {
        java.math.BigDecimal r = this.bigDecimal().round(this.mc());
        if (r == this.bigDecimal()) {
            return this;
        }
        return new BigDecimal(r, this.mc());
    }

    public int scale() {
        return this.bigDecimal().scale();
    }

    public BigDecimal ulp() {
        return new BigDecimal(this.bigDecimal().ulp(), this.mc());
    }

    public BigDecimal apply(MathContext mc) {
        return new BigDecimal(this.bigDecimal().round(mc), mc);
    }

    public BigDecimal setScale(int scale) {
        if (this.scale() == scale) {
            return this;
        }
        return new BigDecimal(this.bigDecimal().setScale(scale), this.mc());
    }

    public BigDecimal setScale(int scale, Enumeration.Value mode) {
        if (this.scale() == scale) {
            return this;
        }
        return new BigDecimal(this.bigDecimal().setScale(scale, RoundingMode.valueOf(mode.id())), this.mc());
    }

    @Override
    public byte byteValue() {
        return (byte)this.intValue();
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    public char charValue() {
        return (char)this.intValue();
    }

    @Override
    public int intValue() {
        return this.bigDecimal().intValue();
    }

    @Override
    public long longValue() {
        return this.bigDecimal().longValue();
    }

    @Override
    public float floatValue() {
        return this.bigDecimal().floatValue();
    }

    @Override
    public double doubleValue() {
        return this.bigDecimal().doubleValue();
    }

    public byte toByteExact() {
        return this.bigDecimal().byteValueExact();
    }

    public short toShortExact() {
        return this.bigDecimal().shortValueExact();
    }

    public int toIntExact() {
        return this.bigDecimal().intValueExact();
    }

    public long toLongExact() {
        return this.bigDecimal().longValueExact();
    }

    public Function1 until(BigDecimal end) {
        return (Function1<BigDecimal, NumericRange.Exclusive> & Serializable)_$2 -> this.until(end, (BigDecimal)_$2);
    }

    public NumericRange.Exclusive<BigDecimal> until(BigDecimal end, BigDecimal step) {
        package$.MODULE$.Range();
        return Range$BigDecimal$.MODULE$.apply(this, end, step);
    }

    public Function1 to(BigDecimal end) {
        return (Function1<BigDecimal, NumericRange.Inclusive> & Serializable)_$3 -> this.to(end, (BigDecimal)_$3);
    }

    public NumericRange.Inclusive<BigDecimal> to(BigDecimal end, BigDecimal step) {
        package$.MODULE$.Range();
        return Range$BigDecimal$.MODULE$.inclusive(this, end, step);
    }

    public BigInt toBigInt() {
        return new BigInt(this.bigDecimal().toBigInteger());
    }

    public Option<BigInt> toBigIntExact() {
        if (this.isWhole()) {
            Option option;
            try {
                option = Some$.MODULE$.apply(new BigInt(this.bigDecimal().toBigIntegerExact()));
            }
            catch (ArithmeticException arithmeticException) {
                option = None$.MODULE$;
            }
            return option;
        }
        return None$.MODULE$;
    }

    public String toString() {
        return this.bigDecimal().toString();
    }

    private final void isValidByte$$anonfun$1() {
        this.toByteExact();
    }

    private final void isValidShort$$anonfun$1() {
        this.toShortExact();
    }

    private final void isValidInt$$anonfun$1() {
        this.toIntExact();
    }

    private final void isValidLong$$anonfun$1() {
        this.toLongExact();
    }
}

