/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.builders;

import java.util.function.Consumer;
import redis.clients.jedis.MultiDbConfig;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.builders.AbstractClientBuilder;
import redis.clients.jedis.executors.CommandExecutor;
import redis.clients.jedis.mcf.DatabaseSwitchEvent;
import redis.clients.jedis.mcf.MultiDbCommandExecutor;
import redis.clients.jedis.mcf.MultiDbConnectionProvider;
import redis.clients.jedis.providers.ConnectionProvider;

@Experimental
public abstract class MultiDbClientBuilder<C>
extends AbstractClientBuilder<MultiDbClientBuilder<C>, C> {
    private MultiDbConfig multiDbConfig = null;
    private Consumer<DatabaseSwitchEvent> databaseSwitchListener = null;

    public MultiDbClientBuilder<C> multiDbConfig(MultiDbConfig config) {
        this.multiDbConfig = config;
        return this;
    }

    public MultiDbClientBuilder<C> databaseSwitchListener(Consumer<DatabaseSwitchEvent> listener) {
        this.databaseSwitchListener = listener;
        return this;
    }

    @Override
    protected MultiDbClientBuilder<C> self() {
        return this;
    }

    @Override
    protected ConnectionProvider createDefaultConnectionProvider() {
        if (this.multiDbConfig == null || this.multiDbConfig.getDatabaseConfigs() == null || this.multiDbConfig.getDatabaseConfigs().length < 1) {
            throw new IllegalArgumentException("At least one endpoint must be specified");
        }
        MultiDbConnectionProvider provider = new MultiDbConnectionProvider(this.multiDbConfig);
        if (this.databaseSwitchListener != null) {
            provider.setDatabaseSwitchListener(this.databaseSwitchListener);
        }
        return provider;
    }

    @Override
    protected CommandExecutor createDefaultCommandExecutor() {
        return new MultiDbCommandExecutor((MultiDbConnectionProvider)this.connectionProvider);
    }

    @Override
    protected void validateSpecificConfiguration() {
    }
}

