/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Period;
import org.traccar.model.ExtendedModel;
import org.traccar.storage.QueryIgnore;
import org.traccar.storage.StorageName;

@StorageName(value="tc_calendars")
public class Calendar
extends ExtendedModel {
    private String name;
    private byte[] data;
    private net.fortuna.ical4j.model.Calendar calendar;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) throws IOException, ParserException {
        CalendarBuilder builder = new CalendarBuilder();
        this.calendar = builder.build(new ByteArrayInputStream(data));
        this.data = data;
    }

    @QueryIgnore
    @JsonIgnore
    public net.fortuna.ical4j.model.Calendar getCalendar() {
        return this.calendar;
    }

    public Set<Period<Instant>> findPeriods(Date date) {
        if (this.calendar != null) {
            Instant instant = date.toInstant();
            return this.calendar.getComponents("VEVENT").stream().flatMap(event -> {
                Object sample = event.getDateTimeStart().getDate();
                Period<Temporal> period = new Period<Temporal>(Calendar.convertToMatchingTemporal(instant, sample), Duration.ZERO);
                return event.calculateRecurrenceSet(period).stream();
            }).map(p -> new Period<Instant>(Calendar.temporalToInstant(p.getStart()), Calendar.temporalToInstant(p.getEnd()))).collect(Collectors.toUnmodifiableSet());
        }
        return Set.of();
    }

    public boolean checkMoment(Date date) {
        return !this.findPeriods(date).isEmpty();
    }

    private static Temporal convertToMatchingTemporal(Instant instant, Temporal sample) {
        if (sample instanceof LocalDate) {
            return instant.atZone(ZoneOffset.UTC).toLocalDate();
        }
        if (sample instanceof LocalDateTime) {
            return instant.atZone(ZoneOffset.UTC).toLocalDateTime();
        }
        if (sample instanceof ZonedDateTime) {
            return instant.atZone(((ZonedDateTime)sample).getZone());
        }
        if (sample instanceof OffsetDateTime) {
            return instant.atOffset(((OffsetDateTime)sample).getOffset());
        }
        return instant;
    }

    private static Instant temporalToInstant(Temporal temporal) {
        if (temporal instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporal).toInstant();
        }
        if (temporal instanceof OffsetDateTime) {
            return ((OffsetDateTime)temporal).toInstant();
        }
        if (temporal instanceof LocalDateTime) {
            return ((LocalDateTime)temporal).toInstant(ZoneOffset.UTC);
        }
        if (temporal instanceof LocalDate) {
            return ((LocalDate)temporal).atStartOfDay(ZoneOffset.UTC).toInstant();
        }
        if (temporal instanceof Instant) {
            return (Instant)temporal;
        }
        throw new IllegalArgumentException("Unsupported Temporal type");
    }
}

