/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class DualcamProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_INIT = 0;
    public static final int MSG_START = 1;
    public static final int MSG_RESUME = 2;
    public static final int MSG_SYNC = 3;
    public static final int MSG_DATA = 4;
    public static final int MSG_COMPLETE = 5;
    public static final int MSG_FILE_REQUEST = 8;
    public static final int MSG_INIT_REQUEST = 9;
    public static final int MSG_PATH_REQUEST = 12;
    public static final int MSG_PATH_RESPONSE = 13;
    private String model;
    private String uniqueId;
    private int dataSize;
    private int dataCurrent;
    private boolean video;
    private ByteBuf media;

    public DualcamProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private boolean isPacketData() {
        if (this.model == null) {
            return this.dataSize < 8192;
        }
        return !"DSM".equals(this.model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        int type = buf.readUnsignedShort();
        switch (type) {
            case 0: {
                buf.readUnsignedShort();
                this.uniqueId = String.valueOf(buf.readLong());
                DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, this.uniqueId);
                long settings = buf.readUnsignedInt();
                if (channel == null || deviceSession == null) break;
                this.model = this.getDeviceModel(deviceSession);
                ByteBuf response = Unpooled.buffer();
                if (BitUtil.check(settings, 25)) {
                    response.writeShort(12);
                    response.writeShort(2);
                    response.writeShort(0);
                } else if (BitUtil.between(settings, 26, 30) > 0L) {
                    String file;
                    response.writeShort(8);
                    if (BitUtil.check(settings, 26)) {
                        this.video = false;
                        file = "%photof";
                    } else if (BitUtil.check(settings, 27)) {
                        this.video = false;
                        file = "%photor";
                    } else if (BitUtil.check(settings, 28)) {
                        this.video = true;
                        file = "%videof";
                    } else {
                        this.video = true;
                        file = "%videor";
                    }
                    response.writeShort(file.length());
                    response.writeCharSequence((CharSequence)file, StandardCharsets.US_ASCII);
                } else {
                    response.writeShort(0);
                }
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
                break;
            }
            case 1: {
                buf.readUnsignedShort();
                this.dataSize = buf.readInt();
                this.dataCurrent = this.isPacketData() ? 1 : 0;
                this.media = Unpooled.buffer();
                if (channel == null) break;
                ByteBuf response = Unpooled.buffer();
                response.writeShort(2);
                response.writeShort(4);
                response.writeInt(this.dataCurrent);
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
                break;
            }
            case 4: {
                boolean finished;
                int length = buf.readUnsignedShort() - 2;
                this.media.writeBytes(buf, length);
                if (this.isPacketData()) {
                    finished = this.dataCurrent == this.dataSize;
                    ++this.dataCurrent;
                } else {
                    finished = this.dataCurrent + length == this.dataSize;
                    this.dataCurrent += length;
                }
                if (!finished) break;
                DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                this.getLastLocation(position, null);
                try {
                    if (this.video) {
                        position.set("video", this.writeMediaFile(this.uniqueId, this.media, "h265"));
                    } else {
                        position.set("image", this.writeMediaFile(this.uniqueId, this.media, "jpg"));
                    }
                }
                finally {
                    this.media.release();
                    this.media = null;
                }
                if (channel != null) {
                    ByteBuf response = Unpooled.buffer();
                    response.writeShort(9);
                    channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
                }
                return position;
            }
            case 13: {
                String file = buf.readCharSequence(buf.readUnsignedShort(), StandardCharsets.US_ASCII).toString();
                if (channel == null) break;
                ByteBuf response = Unpooled.buffer();
                response.writeShort(8);
                response.writeShort(file.length());
                response.writeCharSequence((CharSequence)file, StandardCharsets.US_ASCII);
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
                break;
            }
        }
        return null;
    }
}

