/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.util.Set;

public class ProCommandsRegistry {
    public static final Set<String> PRO_COMMANDS = Set.of("flow", "checks", "rollbackonechangeset", "rollbackoneupdate", "updateonechangeset", "dbclhistory", "databasechangeloghistory", "connect", "driftdetect", "driftreport", "snapshotreference");
    public static final Set<String> PRO_SUBCOMMANDS = Set.of("run", "show", "enable", "disable", "validate");

    public static boolean isProCommand(String command) {
        if (command == null) {
            return false;
        }
        return PRO_COMMANDS.contains(command.toLowerCase());
    }

    public static boolean isProSubcommand(String command, String subcommand) {
        if (command == null || subcommand == null) {
            return false;
        }
        return ProCommandsRegistry.isProCommand(command) && PRO_SUBCOMMANDS.contains(subcommand.toLowerCase());
    }

    public static String getFormattedCommand(String command, String subcommand) {
        if (subcommand != null && !subcommand.isEmpty()) {
            return command + " " + subcommand;
        }
        return command;
    }
}

