/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.collection;

import com.google.api.core.InternalApi;
import com.google.cloud.firestore.collection.LLRBNode;
import com.google.cloud.firestore.collection.LLRBValueNode;

@InternalApi
public class LLRBBlackValueNode<K, V>
extends LLRBValueNode<K, V> {
    private int size = -1;

    LLRBBlackValueNode(K key, V value, LLRBNode<K, V> left, LLRBNode<K, V> right) {
        super(key, value, left, right);
    }

    @Override
    protected LLRBNode.Color getColor() {
        return LLRBNode.Color.BLACK;
    }

    @Override
    public boolean isRed() {
        return false;
    }

    @Override
    public int size() {
        if (this.size == -1) {
            this.size = this.getLeft().size() + 1 + this.getRight().size();
        }
        return this.size;
    }

    @Override
    void setLeft(LLRBNode<K, V> left) {
        if (this.size != -1) {
            throw new IllegalStateException("Can't set left after using size");
        }
        super.setLeft(left);
    }

    @Override
    protected LLRBValueNode<K, V> copy(K key, V value, LLRBNode<K, V> left, LLRBNode<K, V> right) {
        K newKey = key == null ? this.getKey() : key;
        V newValue = value == null ? this.getValue() : value;
        LLRBNode<K, V> newLeft = left == null ? this.getLeft() : left;
        LLRBNode<K, V> newRight = right == null ? this.getRight() : right;
        return new LLRBBlackValueNode<K, V>(newKey, newValue, newLeft, newRight);
    }
}

