/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.OutgoingHttpRequest;
import com.google.firebase.database.annotations.Nullable;
import java.util.Map;

public final class IncomingHttpResponse {
    private final int statusCode;
    private final String content;
    private final Map<String, Object> headers;
    private final OutgoingHttpRequest request;

    public IncomingHttpResponse(HttpResponse response, @Nullable String content) {
        Preconditions.checkNotNull((Object)response, (Object)"response must not be null");
        this.statusCode = response.getStatusCode();
        this.content = content;
        this.headers = ImmutableMap.copyOf((Map)response.getHeaders());
        this.request = new OutgoingHttpRequest(response.getRequest());
    }

    public IncomingHttpResponse(HttpResponseException e, HttpRequest request) {
        this(e, new OutgoingHttpRequest(request));
    }

    public IncomingHttpResponse(HttpResponseException e, OutgoingHttpRequest request) {
        Preconditions.checkNotNull((Object)e, (Object)"exception must not be null");
        this.statusCode = e.getStatusCode();
        this.content = e.getContent();
        this.headers = ImmutableMap.copyOf((Map)e.getHeaders());
        this.request = (OutgoingHttpRequest)Preconditions.checkNotNull((Object)request, (Object)"request must not be null");
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Nullable
    public String getContent() {
        return this.content;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public OutgoingHttpRequest getRequest() {
        return this.request;
    }
}

