/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.util.Arrays;
import java.util.Set;

class LongSet {
    private static final int DEFAULT_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private transient long[] table;
    private int size;
    private volatile transient int modCount;
    private transient int threshold;

    LongSet() {
        this.init(32);
    }

    LongSet(int expectedMaxSize) {
        if (expectedMaxSize < 0) {
            throw new IllegalArgumentException("expectedMaxSize is negative: " + expectedMaxSize);
        }
        this.init(this.capacity(expectedMaxSize));
    }

    private int capacity(int expectedMaxSize) {
        int result;
        int minCapacity = 4 * expectedMaxSize / 3;
        if (minCapacity > 0x40000000 || minCapacity < 0) {
            result = 0x40000000;
        } else {
            for (result = 4; result < minCapacity; result <<= 1) {
            }
        }
        return result;
    }

    private void init(int initCapacity) {
        this.threshold = initCapacity * 3 / 4;
        this.table = new long[initCapacity];
    }

    LongSet(Set<Long> m) {
        this((int)((double)(1 + m.size()) * 1.1));
        this.putAll(m);
    }

    int size() {
        return this.size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    private static int hash(long x, int length) {
        int h = (int)(x ^ x >>> 32);
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h & length - 1;
    }

    private static int nextKeyIndex(int i, int len) {
        return i + 1 < len ? i + 1 : 0;
    }

    boolean contains(long key) {
        assert (key != 0L);
        long[] tab = this.table;
        int len = tab.length;
        int i = LongSet.hash(key, len);
        long item;
        while ((item = tab[i]) != key) {
            if (item == 0L) {
                return false;
            }
            i = LongSet.nextKeyIndex(i, len);
        }
        return true;
    }

    boolean add(long key) {
        long item;
        assert (key != 0L);
        long[] tab = this.table;
        int len = tab.length;
        int i = LongSet.hash(key, len);
        while ((item = tab[i]) != 0L) {
            if (item == key) {
                return true;
            }
            i = LongSet.nextKeyIndex(i, len);
        }
        ++this.modCount;
        tab[i] = key;
        if (++this.size >= this.threshold) {
            this.resize(2 * len);
        }
        return false;
    }

    private void resize(int newCapacity) {
        int newLength = newCapacity;
        long[] oldTable = this.table;
        int oldLength = oldTable.length;
        if (oldLength == 0x40000000) {
            if (this.threshold == 0x3FFFFFFF) {
                throw new IllegalStateException("Capacity exhausted.");
            }
            this.threshold = 0x3FFFFFFF;
            return;
        }
        if (oldLength >= newLength) {
            return;
        }
        long[] newTable = new long[newLength];
        this.threshold = newLength * 3 / 4;
        for (long key : oldTable) {
            if (key == 0L) continue;
            int i = LongSet.hash(key, newLength);
            while (newTable[i] != 0L) {
                i = LongSet.nextKeyIndex(i, newLength);
            }
            newTable[i] = key;
        }
        this.table = newTable;
    }

    void putAll(Set<Long> m) {
        int n = m.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            this.resize(this.capacity(n));
        }
        for (Long e : m) {
            this.add(e);
        }
    }

    boolean remove(long key) {
        long[] tab = this.table;
        int len = tab.length;
        int i = LongSet.hash(++key, len);
        while (true) {
            long item;
            if ((item = tab[i]) == key) {
                ++this.modCount;
                --this.size;
                tab[i] = 0L;
                this.closeDeletion(i);
                return true;
            }
            if (item == 0L) {
                return false;
            }
            i = LongSet.nextKeyIndex(i, len);
        }
    }

    private void closeDeletion(int d) {
        long item;
        long[] tab = this.table;
        int len = tab.length;
        int i = LongSet.nextKeyIndex(d, len);
        while ((item = tab[i]) != 0L) {
            int r = LongSet.hash(item, len);
            if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                tab[d] = item;
                tab[i] = 0L;
                d = i;
            }
            i = LongSet.nextKeyIndex(i, len);
        }
    }

    void clear() {
        ++this.modCount;
        long[] tab = this.table;
        Arrays.fill(tab, 0L);
        this.size = 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LongSet) {
            long[] tab;
            LongSet m = (LongSet)o;
            if (m.size() != this.size) {
                return false;
            }
            for (long k : tab = m.table) {
                if (k == 0L || this.contains(k)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        long[] tab;
        int result = 0;
        for (long key : tab = this.table) {
            if (key == 0L) continue;
            result += LongSet.hash(key, tab.length);
        }
        return result;
    }
}

