/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiling.presets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.profiling.presets.ProfilerPreset;
import org.graalvm.visualvm.profiling.presets.ProfilerPresets;
import org.openide.util.NbBundle;

public final class PresetSelector
extends JPanel {
    private final Runnable presetSynchronizer;
    private JLabel presetsLabel;
    private JComboBox<ProfilerPreset> presetsCombo;
    private JButton presetsButton;
    private final DefaultComboBoxModel<ProfilerPreset> selectorsModel;
    private final List<PresetSelector> allSelectors;
    private boolean savingCustom;
    private boolean customSelected;
    private boolean internalChange = false;

    PresetSelector(DefaultComboBoxModel<ProfilerPreset> selectorsModel, List<PresetSelector> allSelectors, Runnable presetSynchronizer) {
        this.selectorsModel = selectorsModel;
        this.allSelectors = allSelectors;
        this.presetSynchronizer = presetSynchronizer;
        this.initComponents();
        SwingUtilities.invokeLater(this::notifySynchronizer);
    }

    public ProfilerPreset getSelectedPreset() {
        return (ProfilerPreset)this.presetsCombo.getSelectedItem();
    }

    public ProfilerPreset customize(boolean presetValid) {
        ProfilerPreset custom = this.customPreset(true);
        custom.setValid(presetValid);
        this.internalChange = true;
        for (PresetSelector pSelector : this.allSelectors) {
            pSelector.presetsCombo.setSelectedIndex(1);
        }
        this.internalChange = false;
        return custom;
    }

    DefaultComboBoxModel<ProfilerPreset> getModel() {
        return this.selectorsModel;
    }

    boolean checkSavingCustom() {
        boolean ret = this.savingCustom;
        this.savingCustom = false;
        return ret;
    }

    private void selectedPresetChanged() {
        boolean custom;
        Object selected = this.presetsCombo.getSelectedItem();
        if (selected == null) {
            return;
        }
        boolean bl = custom = selected == this.customPreset(false);
        if (this.customSelected != custom) {
            this.customSelected = custom;
            this.presetsButton.setText(custom ? NbBundle.getMessage(PresetSelector.class, (String)"BTN_Save") : NbBundle.getMessage(PresetSelector.class, (String)"BTN_Edit"));
        }
        if (this.internalChange) {
            return;
        }
        this.notifySynchronizer();
    }

    private void actionRequested() {
        if (this.customSelected) {
            this.savingCustom = true;
            ProfilerPresets.getInstance().savePreset(new ProfilerPreset(this.customPreset(true)));
        } else {
            ProfilerPresets.getInstance().editPresets(this.getSelectedPreset());
        }
    }

    private void notifySynchronizer() {
        SwingUtilities.invokeLater(this.presetSynchronizer::run);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.presetsLabel.setEnabled(enabled);
        this.presetsCombo.setEnabled(enabled);
        this.presetsButton.setEnabled(enabled);
    }

    private ProfilerPreset customPreset(boolean create) {
        ProfilerPreset customO;
        ProfilerPreset custom = new ProfilerPreset((ProfilerPreset)this.selectorsModel.getSelectedItem());
        custom.setName(NbBundle.getMessage(PresetSelector.class, (String)"LBL_Custom"));
        if (this.selectorsModel.getSize() > 1 && custom.equals(customO = this.selectorsModel.getElementAt(1))) {
            return customO;
        }
        if (!create) {
            return null;
        }
        custom.setSelector(this.selectorsModel.getElementAt(0).getSelector());
        this.internalChange = true;
        this.selectorsModel.insertElementAt(custom, 1);
        this.internalChange = false;
        return custom;
    }

    public static boolean isCustomPreset(ProfilerPreset preset) {
        return NbBundle.getMessage(PresetSelector.class, (String)"LBL_Custom").equals(preset.getName());
    }

    private void initComponents() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout(5, 0));
        this.presetsLabel = new JLabel(NbBundle.getMessage(PresetSelector.class, (String)"LBL_Preset"));
        this.presetsLabel.setToolTipText(NbBundle.getMessage(PresetSelector.class, (String)"TOOLTIP_Defined_presets"));
        this.add((Component)this.presetsLabel, "West");
        this.presetsCombo = new JComboBox<ProfilerPreset>(this.selectorsModel);
        this.presetsCombo.setToolTipText(NbBundle.getMessage(PresetSelector.class, (String)"TOOLTIP_Defined_presets"));
        this.presetsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PresetSelector.this.selectedPresetChanged();
            }
        });
        this.add(this.presetsCombo, "Center");
        this.presetsButton = new JButton(NbBundle.getMessage(PresetSelector.class, (String)"BTN_Save")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                PresetSelector.this.actionRequested();
            }
        };
        this.presetsButton.setToolTipText(NbBundle.getMessage(PresetSelector.class, (String)"TOOLTIP_Manage_presets"));
        this.add((Component)this.presetsButton, "East");
        Dimension dim1 = this.presetsButton.getPreferredSize();
        this.presetsButton.setText(NbBundle.getMessage(PresetSelector.class, (String)"BTN_Edit"));
        Dimension dim2 = this.presetsButton.getPreferredSize();
        dim1.width = Math.max(dim1.width, dim2.width);
        dim1.height = Math.max(dim1.height, dim2.height);
        this.presetsButton.setPreferredSize(dim1);
    }
}

