/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java;

import java.io.IOException;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.HeapFragment;
import org.graalvm.visualvm.heapviewer.java.Bundle;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;

public class JavaHeapFragment
extends HeapFragment {
    public JavaHeapFragment(Heap heap) throws IOException {
        super("java_heap", Bundle.JavaHeapFragment_Name(), Bundle.JavaHeapFragment_Description(), heap);
    }

    public JavaHeapFragment(Heap heap, int segment) throws IOException {
        super("java_heap", Bundle.JavaHeapFragment_NameSegment(segment), Bundle.JavaHeapFragment_DescriptionSegment(segment), heap);
    }

    public static boolean isJavaHeap(HeapContext context) {
        return "java_heap".equals(context.getFragment().getID());
    }

    public static HeapContext getJavaContext(HeapContext context) {
        if (JavaHeapFragment.isJavaHeap(context)) {
            return context;
        }
        for (HeapContext otherContext : context.getOtherContexts()) {
            if (!JavaHeapFragment.isJavaHeap(otherContext)) continue;
            return otherContext;
        }
        return null;
    }
}

