/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.picl;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.SinglePropertyMap;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.picl.Constraint;
import com.thaiopensource.validate.picl.InvalidPatternException;
import com.thaiopensource.validate.picl.KeyConstraint;
import com.thaiopensource.validate.picl.KeyRefConstraint;
import com.thaiopensource.validate.picl.MultiConstraint;
import com.thaiopensource.validate.picl.NamespaceContext;
import com.thaiopensource.validate.picl.Pattern;
import com.thaiopensource.validate.picl.PatternParser;
import com.thaiopensource.validate.picl.SchemaImpl;
import com.thaiopensource.xml.sax.CountingErrorHandler;
import com.thaiopensource.xml.sax.DelegatingContentHandler;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class SchemaParser
extends DelegatingContentHandler
implements SchemaFuture,
NamespaceContext {
    private final Vector constraints = new Vector();
    private final PropertyMap properties;
    private final CountingErrorHandler ceh;
    private Locator locator;
    private final Stack prefixes = new Stack();
    private final Localizer localizer = new Localizer(SchemaParser.class);
    private final PatternParser patternParser;

    SchemaParser(PropertyMap propertyMap, Schema schema) {
        this.properties = propertyMap;
        this.ceh = new CountingErrorHandler(ValidateProperty.ERROR_HANDLER.get(propertyMap));
        Validator validator = schema.createValidator(new SinglePropertyMap(ValidateProperty.ERROR_HANDLER, this.ceh));
        this.setDelegate(validator.getContentHandler());
        this.patternParser = new PatternParser(this.ceh, this.localizer);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.prefixes.push("xml");
        this.prefixes.push("http://www.w3.org/XML/1998/namespace");
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (string == null) {
            string = "";
        }
        this.prefixes.push(string);
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        this.prefixes.push(string2);
        super.startPrefixMapping(string, string2);
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        this.prefixes.pop();
        this.prefixes.pop();
        super.endPrefixMapping(string);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        if (this.ceh.getHadErrorOrFatalError()) {
            return;
        }
        if (!string2.equals("constraint")) {
            return;
        }
        String string4 = attributes.getValue("", "key");
        try {
            Pattern pattern = this.patternParser.parse(string4, this.locator, this);
            String string5 = attributes.getValue("", "ref");
            if (string5 != null) {
                Pattern pattern2 = this.patternParser.parse(string5, this.locator, this);
                this.constraints.addElement(new KeyRefConstraint(pattern, pattern2));
            } else {
                this.constraints.addElement(new KeyConstraint(pattern));
            }
        }
        catch (InvalidPatternException invalidPatternException) {
            // empty catch block
        }
    }

    @Override
    public Schema getSchema() throws IncorrectSchemaException {
        Constraint constraint;
        if (this.ceh.getHadErrorOrFatalError()) {
            throw new IncorrectSchemaException();
        }
        if (this.constraints.size() == 1) {
            constraint = (Constraint)this.constraints.elementAt(0);
        } else {
            Constraint[] constraintArray = new Constraint[this.constraints.size()];
            for (int i = 0; i < constraintArray.length; ++i) {
                constraintArray[i] = (Constraint)this.constraints.elementAt(i);
            }
            constraint = new MultiConstraint(constraintArray);
        }
        return new SchemaImpl(this.properties, constraint);
    }

    @Override
    public RuntimeException unwrapException(RuntimeException runtimeException) {
        return runtimeException;
    }

    @Override
    public String getNamespaceUri(String string) {
        for (int i = this.prefixes.size(); i > 0; i -= 2) {
            if (!this.prefixes.elementAt(i - 2).equals(string)) continue;
            return (String)this.prefixes.elementAt(i - 1);
        }
        return null;
    }

    @Override
    public String defaultPrefix() {
        return "";
    }
}

