/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swt;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Rectangle;

public class SWTShapeManager {
    static AffineTransform IDENTITY_XFORM = new AffineTransform();
    static Point2D aPoint = new Point2D.Double();
    static ArrayList segList = new ArrayList();
    static double[] pts = new double[8];

    public static void transform(Rectangle2D rectangle2D, AffineTransform affineTransform) {
        SWTShapeManager.pts[0] = rectangle2D.getX();
        SWTShapeManager.pts[1] = rectangle2D.getY();
        SWTShapeManager.pts[2] = rectangle2D.getX() + rectangle2D.getWidth();
        SWTShapeManager.pts[3] = rectangle2D.getY();
        SWTShapeManager.pts[4] = rectangle2D.getX() + rectangle2D.getWidth();
        SWTShapeManager.pts[5] = rectangle2D.getY() + rectangle2D.getHeight();
        SWTShapeManager.pts[6] = rectangle2D.getX();
        SWTShapeManager.pts[7] = rectangle2D.getY() + rectangle2D.getHeight();
        affineTransform.transform(pts, 0, pts, 0, 4);
        double d = pts[0];
        double d2 = pts[1];
        double d3 = pts[0];
        double d4 = pts[1];
        for (int i = 1; i < 4; ++i) {
            if (pts[2 * i] < d) {
                d = pts[2 * i];
            }
            if (pts[2 * i + 1] < d2) {
                d2 = pts[2 * i + 1];
            }
            if (pts[2 * i] > d3) {
                d3 = pts[2 * i];
            }
            if (!(pts[2 * i + 1] > d4)) continue;
            d4 = pts[2 * i + 1];
        }
        rectangle2D.setRect(d, d2, d3 - d, d4 - d2);
    }

    public static void awtToSWT(Rectangle2D rectangle2D, Rectangle rectangle) {
        rectangle.x = (int)(rectangle2D.getX() + 0.5);
        rectangle.y = (int)(rectangle2D.getY() + 0.5);
        rectangle.width = (int)(rectangle2D.getWidth() + 0.5);
        rectangle.height = (int)(rectangle2D.getHeight() + 0.5);
    }

    public static double[] shapeToPolyline(Shape shape) {
        segList.clear();
        aPoint.setLocation(0.0, 0.0);
        PathIterator pathIterator = shape.getPathIterator(IDENTITY_XFORM, 1.0E-9);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(pts);
            switch (n) {
                case 0: {
                    aPoint.setLocation(pts[0], pts[1]);
                    segList.add(new Point2D.Double(pts[0], pts[1]));
                    break;
                }
                case 1: {
                    segList.add(new Point2D.Double(pts[0], pts[1]));
                    break;
                }
                case 4: {
                    segList.add(new Point2D.Double(aPoint.getX(), aPoint.getY()));
                }
            }
            pathIterator.next();
        }
        double[] dArray = new double[2 * segList.size()];
        for (int i = 0; i < segList.size(); ++i) {
            Point2D point2D = (Point2D)segList.get(i);
            dArray[2 * i] = (int)(point2D.getX() + 0.5);
            dArray[2 * i + 1] = (int)(point2D.getY() + 0.5);
        }
        return dArray;
    }

    public static int[] transform(double[] dArray, AffineTransform affineTransform) {
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length / 2; ++i) {
            aPoint.setLocation(dArray[2 * i], dArray[2 * i + 1]);
            affineTransform.transform(aPoint, aPoint);
            nArray[2 * i] = (int)(aPoint.getX() + 0.5);
            nArray[2 * i + 1] = (int)(aPoint.getY() + 0.5);
        }
        return nArray;
    }
}

