/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.report;

import java.awt.Component;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.report.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.option.BooleanOption;

public final class ReportTurnPanel
extends ReportPanel {
    private static final Logger logger = Logger.getLogger(ReportTurnPanel.class.getName());
    private final Hashtable<String, List<JComponent>> labelsByMessage = new Hashtable();
    private final Hashtable<String, List<JComponent>> textPanesByMessage = new Hashtable();
    private final List<ModelMessage> messages = new ArrayList<ModelMessage>();

    public ReportTurnPanel(FreeColClient freeColClient, List<ModelMessage> messages) {
        super(freeColClient, "reportTurnAction");
        this.reportPanel.setLayout(new MigLayout("wrap 4", "[center][550!]:push[][]", ""));
        this.setMessages(messages);
    }

    public void setMessages(List<ModelMessage> messages) {
        this.reportPanel.removeAll();
        this.messages.clear();
        if (messages != null) {
            this.messages.addAll(messages);
        }
        this.displayMessages();
    }

    private void displayMessages() {
        Game game = this.getFreeColClient().getGame();
        ClientOptions co = this.getClientOptions();
        int groupBy = co.getInteger("model.option.guiMessagesGroupBy");
        Comparator<ModelMessage> comparator = co.getModelMessageComparator(game);
        if (comparator != null) {
            this.messages.sort(comparator);
        }
        Object source = this;
        ModelMessage.MessageType type = null;
        for (ModelMessage message : this.messages) {
            switch (groupBy) {
                case 2: {
                    FreeColGameObject messageSource = game.getMessageSource(message);
                    if (messageSource == source) break;
                    source = messageSource;
                    this.reportPanel.add((Component)this.getHeadline(messageSource), "newline 20, skip");
                    break;
                }
                case 1: {
                    if (message.getMessageType() == type) break;
                    type = message.getMessageType();
                    JLabel headline = Utility.localizedHeaderLabel(type, Utility.FONTSPEC_SUBTITLE);
                    this.reportPanel.add((Component)headline, "newline 20, skip, span");
                    break;
                }
            }
            JComponent component = new JLabel();
            FreeColObject messageDisplay = game.getMessageDisplay(message);
            ImageLibrary lib = this.getImageLibrary();
            if (messageDisplay != null) {
                JButton button;
                ImageIcon icon;
                BufferedImage image = lib.getObjectImage(messageDisplay);
                ImageIcon imageIcon = icon = image == null ? null : new ImageIcon(image);
                if (messageDisplay instanceof Colony || messageDisplay instanceof Europe) {
                    button = Utility.getLinkButton(null, icon, messageDisplay.getId());
                    button.addActionListener(this);
                    component = button;
                } else if (messageDisplay instanceof Unit) {
                    button = Utility.getLinkButton(null, icon, ((Unit)messageDisplay).up().getId());
                    button.addActionListener(this);
                    component = button;
                } else {
                    component = new JLabel(icon);
                }
            }
            this.reportPanel.add((Component)component, "newline");
            JTextPane textPane = Utility.getDefaultTextPane();
            try {
                this.insertMessage(textPane.getStyledDocument(), message, this.getMyPlayer());
            }
            catch (BadLocationException ble) {
                logger.log(Level.WARNING, "message insert fail", ble);
            }
            this.reportPanel.add(textPane);
            boolean ignore = false;
            JComponent label = component;
            switch (message.getMessageType()) {
                case WAREHOUSE_CAPACITY: {
                    JButton ignoreButton = new JButton("x");
                    Utility.localizeToolTip((JComponent)ignoreButton, StringTemplate.copy("report.turn.ignore", message));
                    ModelMessage m = message;
                    ignoreButton.addActionListener(ae -> {
                        boolean flag = label.isEnabled();
                        this.igc().ignoreMessage(m, flag);
                        textPane.setEnabled(!flag);
                        label.setEnabled(!flag);
                    });
                    this.reportPanel.add(ignoreButton);
                    ignore = true;
                    break;
                }
            }
            String id = message.getId();
            List<JComponent> components = this.textPanesByMessage.get(id);
            if (components == null) {
                components = new ArrayList<JComponent>();
                this.textPanesByMessage.put(id, components);
            }
            components.add(textPane);
            components = this.labelsByMessage.get(id);
            if (components == null) {
                components = new ArrayList<JComponent>();
                this.labelsByMessage.put(id, components);
            }
            components.add(label);
            String msgKey = message.getOptionName();
            if (!co.hasOption(msgKey, BooleanOption.class)) continue;
            JButton filterButton = new JButton("X");
            Utility.localizeToolTip((JComponent)filterButton, StringTemplate.template("report.turn.filter").addNamed("%type%", message.getMessageType()));
            ModelMessage mess = message;
            filterButton.addActionListener(ae -> {
                boolean flag = co.getBoolean(msgKey);
                co.setBoolean(msgKey, !flag);
                for (ModelMessage m : this.messages) {
                    if (m.getMessageType() != mess.getMessageType()) continue;
                    for (JComponent jc : this.textPanesByMessage.get(m.getId())) {
                        jc.setEnabled(!flag);
                    }
                    for (JComponent jc : this.labelsByMessage.get(m.getId())) {
                        jc.setEnabled(!flag);
                    }
                }
            });
            if (ignore) {
                this.reportPanel.add(filterButton);
                continue;
            }
            this.reportPanel.add((Component)filterButton, "skip");
        }
    }

    private JComponent getHeadline(FreeColGameObject source) {
        JComponent headline;
        Colony colony;
        StringTemplate template;
        String text;
        String commandId = null;
        if (source == null) {
            text = "";
        } else if (source instanceof Player) {
            Player player = (Player)source;
            template = ((StringTemplate)StringTemplate.template("report.turn.playerNation").addName("%player%", player.getName())).addStringTemplate("%nation%", player.getNationLabel());
            text = Messages.message(template);
        } else if (source instanceof Europe) {
            Europe europe = (Europe)source;
            text = Messages.getName(europe);
            commandId = europe.getId();
        } else if (source instanceof Market) {
            Market market = (Market)source;
            template = market.getOwner().getMarketName();
            text = Messages.message(template);
            Europe europe = this.getMyPlayer().getEurope();
            commandId = europe != null ? europe.getId() : null;
        } else if (source instanceof Colony) {
            colony = (Colony)source;
            text = colony.getName();
            commandId = colony.getId();
        } else if (source instanceof Building) {
            colony = ((Building)source).getColony();
            text = colony.getName();
            commandId = colony.getId();
        } else if (source instanceof Unit) {
            Unit unit = (Unit)source;
            text = unit.getDescription(Unit.UnitLabelType.NATIONAL);
            commandId = unit.getLocation().getId();
        } else if (source instanceof Tile) {
            Tile tile = (Tile)source;
            template = tile.getLocationLabelFor(this.getMyPlayer());
            text = Messages.message(template);
            commandId = tile.getId();
        } else {
            text = source instanceof Named ? Messages.message(((Named)((Object)source)).getNameKey()) : (source instanceof Nameable ? ((Nameable)((Object)source)).getName() : source.toString());
        }
        Font font = FontLibrary.getScaledFont(Utility.FONTSPEC_SUBTITLE, text);
        if (commandId != null) {
            JButton button = new JButton(text);
            button.addActionListener(this);
            button.setActionCommand(commandId);
            headline = button;
            headline.setForeground(Utility.getLinkColor());
        } else {
            headline = new JLabel(text);
        }
        headline.setFont(font);
        headline.setOpaque(false);
        headline.setBorder(Utility.blankBorder(5, 0, 0, 0));
        return headline;
    }

    private void insertMessage(StyledDocument document, ModelMessage message, Player player) throws BadLocationException {
        for (Object o : message.splitLinks(player)) {
            if (o instanceof String) {
                document.insertString(document.getLength(), (String)o, document.getStyle("regular"));
                continue;
            }
            if (!(o instanceof JButton)) continue;
            JButton b = (JButton)o;
            b.addActionListener(this);
            StyleConstants.setComponent(document.getStyle("button"), b);
            document.insertString(document.getLength(), " ", document.getStyle("button"));
        }
    }
}

