/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.saml;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.net.URI;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.UserAuthenticationIdentityProvider;
import org.keycloak.broker.saml.SAMLIdentityProvider;
import org.keycloak.broker.saml.SAMLIdentityProviderConfig;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.KeyUse;
import org.keycloak.dom.saml.common.CommonConditionsType;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.assertion.AuthnStatementType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationDataType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.dom.saml.v2.protocol.ArtifactResponseType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.keys.PublicKeyStorageProvider;
import org.keycloak.keys.PublicKeyStorageUtils;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.protocol.saml.JaxrsSAML2BindingBuilder;
import org.keycloak.protocol.saml.SAMLDecryptionKeysLocator;
import org.keycloak.protocol.saml.SamlMetadataKeyLocator;
import org.keycloak.protocol.saml.SamlMetadataPublicKeyLoader;
import org.keycloak.protocol.saml.SamlPrincipalType;
import org.keycloak.protocol.saml.SamlProtocolUtils;
import org.keycloak.protocol.saml.SamlService;
import org.keycloak.protocol.saml.SamlSessionUtils;
import org.keycloak.protocol.saml.preprocessor.SamlAuthenticationPreprocessor;
import org.keycloak.rotation.HardcodedKeyLocator;
import org.keycloak.rotation.KeyLocator;
import org.keycloak.saml.SAML2LogoutResponseBuilder;
import org.keycloak.saml.SAMLRequestParser;
import org.keycloak.saml.SamlProtocolExtensionsAwareBuilder;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.core.saml.v2.constants.X500SAMLProfileConstants;
import org.keycloak.saml.processing.core.saml.v2.util.ArtifactResponseUtil;
import org.keycloak.saml.processing.core.saml.v2.util.AssertionUtil;
import org.keycloak.saml.processing.core.util.KeycloakKeySamlExtensionGenerator;
import org.keycloak.saml.processing.core.util.XMLEncryptionUtil;
import org.keycloak.saml.processing.core.util.XMLSignatureUtil;
import org.keycloak.saml.processing.web.util.PostBindingUtil;
import org.keycloak.saml.validators.ConditionsValidator;
import org.keycloak.saml.validators.DestinationValidator;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.util.Booleans;
import org.keycloak.utils.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SAMLEndpoint {
    protected static final Logger logger = Logger.getLogger(SAMLEndpoint.class);
    public static final String SAML_FEDERATED_SESSION_INDEX = "SAML_FEDERATED_SESSION_INDEX";
    @Deprecated
    public static final String SAML_FEDERATED_SUBJECT = "SAML_FEDERATED_SUBJECT";
    @Deprecated
    public static final String SAML_FEDERATED_SUBJECT_NAMEFORMAT = "SAML_FEDERATED_SUBJECT_NAMEFORMAT";
    public static final String SAML_FEDERATED_SUBJECT_NAMEID = "SAML_FEDERATED_SUBJECT_NAME_ID";
    public static final String SAML_LOGIN_RESPONSE = "SAML_LOGIN_RESPONSE";
    public static final String SAML_ASSERTION = "SAML_ASSERTION";
    public static final String SAML_AUTHN_STATEMENT = "SAML_AUTHN_STATEMENT";
    protected final RealmModel realm;
    protected EventBuilder event;
    protected final SAMLIdentityProviderConfig config;
    protected final UserAuthenticationIdentityProvider.AuthenticationCallback callback;
    protected final SAMLIdentityProvider provider;
    private final DestinationValidator destinationValidator;
    private final KeycloakSession session;
    private final ClientConnection clientConnection;
    private final HttpHeaders headers;

    public SAMLEndpoint(KeycloakSession session, SAMLIdentityProvider provider, SAMLIdentityProviderConfig config, UserAuthenticationIdentityProvider.AuthenticationCallback callback, DestinationValidator destinationValidator) {
        this.realm = session.getContext().getRealm();
        this.config = config;
        this.callback = callback;
        this.provider = provider;
        this.destinationValidator = destinationValidator;
        this.session = session;
        this.clientConnection = session.getContext().getConnection();
        this.headers = session.getContext().getRequestHeaders();
    }

    @GET
    @NoCache
    @Path(value="descriptor")
    public Response getSPDescriptor() {
        return this.provider.export((UriInfo)this.session.getContext().getUri(), this.realm, null);
    }

    @GET
    public Response redirectBinding(@QueryParam(value="SAMLRequest") String samlRequest, @QueryParam(value="SAMLResponse") String samlResponse, @QueryParam(value="SAMLart") String samlArt, @QueryParam(value="RelayState") String relayState) {
        if (Objects.isNull(samlArt)) {
            return new RedirectBinding().execute(samlRequest, samlResponse, null, relayState, null);
        }
        return new ArtifactBinding().execute(samlRequest, samlResponse, samlArt, relayState, null);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postBinding(@FormParam(value="SAMLRequest") String samlRequest, @FormParam(value="SAMLResponse") String samlResponse, @FormParam(value="SAMLart") String samlArt, @FormParam(value="RelayState") String relayState) {
        if (Objects.isNull(samlArt)) {
            return new PostBinding().execute(samlRequest, samlResponse, null, relayState, null);
        }
        return new ArtifactBinding().execute(samlRequest, samlResponse, samlArt, relayState, null);
    }

    @Path(value="clients/{client_id}")
    @GET
    public Response redirectBindingIdpInitiated(@QueryParam(value="SAMLRequest") String samlRequest, @QueryParam(value="SAMLResponse") String samlResponse, @QueryParam(value="RelayState") String relayState, @PathParam(value="client_id") String clientId) {
        return new RedirectBinding().execute(samlRequest, samlResponse, null, relayState, clientId);
    }

    @Path(value="clients/{client_id}")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postBindingIdpInitiated(@FormParam(value="SAMLRequest") String samlRequest, @FormParam(value="SAMLResponse") String samlResponse, @FormParam(value="RelayState") String relayState, @PathParam(value="client_id") String clientId) {
        return new PostBinding().execute(samlRequest, samlResponse, null, relayState, clientId);
    }

    private String getX500Attribute(AssertionType assertion, X500SAMLProfileConstants attribute) {
        return this.getFirstMatchingAttribute(assertion, arg_0 -> ((X500SAMLProfileConstants)attribute).correspondsTo(arg_0));
    }

    private String getAttributeByName(AssertionType assertion, String name) {
        return this.getFirstMatchingAttribute(assertion, attribute -> Objects.equals(attribute.getName(), name));
    }

    private String getAttributeByFriendlyName(AssertionType assertion, String friendlyName) {
        return this.getFirstMatchingAttribute(assertion, attribute -> Objects.equals(attribute.getFriendlyName(), friendlyName));
    }

    private String getPrincipal(AssertionType assertion) {
        SamlPrincipalType principalType = this.config.getPrincipalType();
        if (principalType == null || principalType.equals((Object)SamlPrincipalType.SUBJECT)) {
            NameIDType subjectNameID = this.getSubjectNameID(assertion);
            return subjectNameID != null ? subjectNameID.getValue() : null;
        }
        if (principalType.equals((Object)SamlPrincipalType.ATTRIBUTE)) {
            return this.getAttributeByName(assertion, this.config.getPrincipalAttribute());
        }
        return this.getAttributeByFriendlyName(assertion, this.config.getPrincipalAttribute());
    }

    private String getFirstMatchingAttribute(AssertionType assertion, Predicate<AttributeType> predicate) {
        return assertion.getAttributeStatements().stream().map(AttributeStatementType::getAttributes).flatMap(Collection::stream).map(AttributeStatementType.ASTChoiceType::getAttribute).filter(predicate).map(AttributeType::getAttributeValue).flatMap(Collection::stream).findFirst().map(Object::toString).orElse(null);
    }

    private String expectedPrincipalType() {
        SamlPrincipalType principalType = this.config.getPrincipalType();
        switch (principalType) {
            case SUBJECT: {
                return principalType.name();
            }
            case ATTRIBUTE: 
            case FRIENDLY_ATTRIBUTE: {
                return String.format("%s(%s)", principalType.name(), this.config.getPrincipalAttribute());
            }
        }
        return null;
    }

    private NameIDType getSubjectNameID(AssertionType assertion) {
        SubjectType subject = assertion.getSubject();
        SubjectType.STSubType subType = subject.getSubType();
        return subType != null ? (NameIDType)subType.getBaseID() : null;
    }

    private boolean validateInResponseToAttribute(ResponseType responseType, String expectedRequestId) {
        SubjectConfirmationDataType subjectConfirmationDataElement;
        SubjectConfirmationType subjectConfirmationElement;
        if (expectedRequestId == null || expectedRequestId.isEmpty()) {
            return true;
        }
        if (responseType.getInResponseTo() == null) {
            logger.error((Object)"Response Validation Error: InResponseTo attribute was expected but not present in received response");
            return false;
        }
        String responseInResponseToValue = responseType.getInResponseTo();
        if (responseInResponseToValue.isEmpty()) {
            logger.error((Object)"Response Validation Error: InResponseTo attribute was expected but it is empty in received response");
            return false;
        }
        if (!responseInResponseToValue.equals(expectedRequestId)) {
            logger.error((Object)"Response Validation Error: received InResponseTo attribute does not match the expected request ID");
            return false;
        }
        if (responseType.getAssertions().isEmpty()) {
            return true;
        }
        SubjectType subjectElement = ((ResponseType.RTChoiceType)responseType.getAssertions().get(0)).getAssertion().getSubject();
        if (subjectElement != null && subjectElement.getConfirmation() != null && !subjectElement.getConfirmation().isEmpty() && (subjectConfirmationElement = (SubjectConfirmationType)subjectElement.getConfirmation().get(0)) != null && (subjectConfirmationDataElement = subjectConfirmationElement.getSubjectConfirmationData()) != null && subjectConfirmationDataElement.getInResponseTo() != null) {
            String subjectConfirmationDataInResponseToValue = subjectConfirmationDataElement.getInResponseTo();
            if (subjectConfirmationDataInResponseToValue.isEmpty()) {
                logger.error((Object)"Response Validation Error: SubjectConfirmationData InResponseTo attribute was expected but it is empty in received response");
                return false;
            }
            if (!subjectConfirmationDataInResponseToValue.equals(expectedRequestId)) {
                logger.error((Object)"Response Validation Error: received SubjectConfirmationData InResponseTo attribute does not match the expected request ID");
                return false;
            }
        }
        return true;
    }

    protected class RedirectBinding
    extends Binding {
        protected RedirectBinding() {
        }

        @Override
        protected boolean containsUnencryptedSignature(SAMLDocumentHolder documentHolder) {
            MultivaluedMap encodedParams = SAMLEndpoint.this.session.getContext().getUri().getQueryParameters(false);
            String algorithm = (String)encodedParams.getFirst((Object)"SigAlg");
            String signature = (String)encodedParams.getFirst((Object)"Signature");
            return algorithm != null && signature != null;
        }

        @Override
        protected void verifySignature(String key, SAMLDocumentHolder documentHolder) throws VerificationException {
            KeyLocator locator = this.getIDPKeyLocator();
            SamlProtocolUtils.verifyRedirectSignature(documentHolder, locator, (UriInfo)SAMLEndpoint.this.session.getContext().getUri(), key);
        }

        @Override
        protected SAMLDocumentHolder extractRequestDocument(String samlRequest) {
            return SAMLRequestParser.parseRequestRedirectBinding((String)samlRequest);
        }

        @Override
        protected SAMLDocumentHolder extractResponseDocument(String response) {
            return SAMLRequestParser.parseResponseRedirectBinding((String)response);
        }

        @Override
        protected String getBindingType() {
            return "get";
        }
    }

    protected class ArtifactBinding
    extends Binding {
        private boolean unencryptedSignaturesVerified;

        protected ArtifactBinding() {
            this.unencryptedSignaturesVerified = false;
        }

        @Override
        protected boolean containsUnencryptedSignature(SAMLDocumentHolder documentHolder) {
            if (this.unencryptedSignaturesVerified) {
                return true;
            }
            NodeList nl = documentHolder.getSamlDocument().getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            return nl != null && nl.getLength() > 0;
        }

        @Override
        protected void verifySignature(String key, SAMLDocumentHolder documentHolder) throws VerificationException {
            if (this.unencryptedSignaturesVerified) {
                return;
            }
            if (!this.containsUnencryptedSignature(documentHolder)) {
                List assertions = null;
                Object object = documentHolder.getSamlObject();
                if (object instanceof ResponseType) {
                    ResponseType responseType = (ResponseType)object;
                    assertions = responseType.getAssertions();
                } else {
                    ArtifactResponseType artifactResponseType;
                    object = documentHolder.getSamlObject();
                    if (object instanceof ArtifactResponseType && (object = (artifactResponseType = (ArtifactResponseType)object).getAny()) instanceof ResponseType) {
                        ResponseType responseType = (ResponseType)object;
                        assertions = responseType.getAssertions();
                    }
                }
                if (assertions != null && !assertions.isEmpty()) {
                    return;
                }
            }
            SamlProtocolUtils.verifyDocumentSignature(documentHolder.getSamlDocument(), this.getIDPKeyLocator());
            this.unencryptedSignaturesVerified = true;
        }

        @Override
        protected SAMLDocumentHolder extractRequestDocument(String samlRequest) {
            throw new UnsupportedOperationException("SAML request is not compliant with Artifact binding");
        }

        @Override
        protected SAMLDocumentHolder extractResponseDocument(String response) {
            byte[] samlBytes = PostBindingUtil.base64Decode((String)response);
            return SAMLRequestParser.parseResponseDocument((byte[])samlBytes);
        }

        @Override
        protected String getBindingType() {
            return "artifact";
        }
    }

    protected class PostBinding
    extends Binding {
        protected PostBinding() {
        }

        @Override
        protected boolean containsUnencryptedSignature(SAMLDocumentHolder documentHolder) {
            NodeList nl = documentHolder.getSamlDocument().getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            return nl != null && nl.getLength() > 0;
        }

        @Override
        protected void verifySignature(String key, SAMLDocumentHolder documentHolder) throws VerificationException {
            ResponseType responseType;
            List assertions;
            if (!this.containsUnencryptedSignature(documentHolder) && documentHolder.getSamlObject() instanceof ResponseType && !(assertions = (responseType = (ResponseType)documentHolder.getSamlObject()).getAssertions()).isEmpty()) {
                return;
            }
            SamlProtocolUtils.verifyDocumentSignature(documentHolder.getSamlDocument(), this.getIDPKeyLocator());
        }

        @Override
        protected SAMLDocumentHolder extractRequestDocument(String samlRequest) {
            return SAMLRequestParser.parseRequestPostBinding((String)samlRequest);
        }

        @Override
        protected SAMLDocumentHolder extractResponseDocument(String response) {
            byte[] samlBytes = PostBindingUtil.base64Decode((String)response);
            return SAMLRequestParser.parseResponseDocument((byte[])samlBytes);
        }

        @Override
        protected String getBindingType() {
            return "post";
        }
    }

    protected abstract class Binding {
        protected Binding() {
        }

        private boolean checkSsl() {
            if (SAMLEndpoint.this.session.getContext().getUri().getBaseUri().getScheme().equals("https")) {
                return true;
            }
            return !SAMLEndpoint.this.realm.getSslRequired().isRequired(SAMLEndpoint.this.clientConnection);
        }

        protected Response basicChecks(String samlRequest, String samlResponse, String samlArt) {
            if (!this.checkSsl()) {
                SAMLEndpoint.this.event.event(EventType.LOGIN);
                SAMLEndpoint.this.event.error("ssl_required");
                return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "httpsRequiredMessage", new Object[0]);
            }
            if (!SAMLEndpoint.this.realm.isEnabled()) {
                SAMLEndpoint.this.event.event(EventType.LOGIN_ERROR);
                SAMLEndpoint.this.event.error("realm_disabled");
                return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "realmNotEnabledMessage", new Object[0]);
            }
            if (samlRequest == null && samlResponse == null && samlArt == null) {
                SAMLEndpoint.this.event.event(EventType.LOGIN);
                SAMLEndpoint.this.event.error("invalid_request");
                return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
            }
            return null;
        }

        protected abstract String getBindingType();

        protected abstract boolean containsUnencryptedSignature(SAMLDocumentHolder var1);

        protected abstract void verifySignature(String var1, SAMLDocumentHolder var2) throws VerificationException;

        protected abstract SAMLDocumentHolder extractRequestDocument(String var1);

        protected abstract SAMLDocumentHolder extractResponseDocument(String var1);

        protected boolean isDestinationRequired() {
            return true;
        }

        protected KeyLocator getIDPKeyLocator() {
            if (StringUtil.isNotBlank((String)SAMLEndpoint.this.config.getMetadataDescriptorUrl()) && SAMLEndpoint.this.config.isUseMetadataDescriptorUrl()) {
                String modelKey = PublicKeyStorageUtils.getIdpModelCacheKey((String)SAMLEndpoint.this.realm.getId(), (String)SAMLEndpoint.this.config.getInternalId());
                SamlMetadataPublicKeyLoader keyLoader = new SamlMetadataPublicKeyLoader(SAMLEndpoint.this.session, SAMLEndpoint.this.config.getMetadataDescriptorUrl());
                PublicKeyStorageProvider keyStorage = (PublicKeyStorageProvider)SAMLEndpoint.this.session.getProvider(PublicKeyStorageProvider.class);
                return new SamlMetadataKeyLocator(modelKey, keyLoader, KeyUse.SIG, keyStorage);
            }
            LinkedList<PublicKey> keys = new LinkedList<PublicKey>();
            for (String signingCertificate : SAMLEndpoint.this.config.getSigningCertificates()) {
                X509Certificate cert = null;
                try {
                    cert = XMLSignatureUtil.getX509CertificateFromKeyInfoString((String)signingCertificate.replaceAll("\\s", ""));
                    cert.checkValidity();
                    keys.add(cert.getPublicKey());
                }
                catch (CertificateException e) {
                    logger.warnf("Ignoring invalid certificate: %s", (Object)cert);
                }
                catch (ProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            return new HardcodedKeyLocator(keys);
        }

        public Response execute(String samlRequest, String samlResponse, String samlArt, String relayState, String clientId) {
            SAMLEndpoint.this.event = new EventBuilder(SAMLEndpoint.this.realm, SAMLEndpoint.this.session, SAMLEndpoint.this.clientConnection);
            Response response = this.basicChecks(samlRequest, samlResponse, samlArt);
            if (response != null) {
                return response;
            }
            if (samlRequest != null) {
                return this.handleSamlRequest(samlRequest, relayState);
            }
            if (samlArt != null) {
                return this.handleSamlArt(samlArt, relayState, clientId);
            }
            return this.handleSamlResponse(samlResponse, relayState, clientId);
        }

        protected Response handleSamlRequest(String samlRequest, String relayState) {
            SAMLDocumentHolder holder = this.extractRequestDocument(samlRequest);
            RequestAbstractType requestAbstractType = (RequestAbstractType)holder.getSamlObject();
            if (this.isDestinationRequired() && requestAbstractType.getDestination() == null && this.containsUnencryptedSignature(holder)) {
                SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                SAMLEndpoint.this.event.detail("reason", "missing_required_destination");
                SAMLEndpoint.this.event.error("invalid_request");
                return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
            }
            if (!SAMLEndpoint.this.destinationValidator.validate(this.getExpectedDestination(SAMLEndpoint.this.config.getAlias(), null), requestAbstractType.getDestination())) {
                SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                SAMLEndpoint.this.event.detail("reason", "invalid_destination");
                SAMLEndpoint.this.event.error("invalid_saml_response");
                return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
            }
            if (SAMLEndpoint.this.config.isValidateSignature()) {
                try {
                    this.verifySignature("SAMLRequest", holder);
                }
                catch (VerificationException e) {
                    logger.error((Object)"validation failed", (Throwable)e);
                    SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SAMLEndpoint.this.event.error("invalid_signature");
                    return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "invalidRequesterMessage", new Object[0]);
                }
            }
            if (requestAbstractType instanceof LogoutRequestType) {
                logger.debug((Object)"** logout request");
                SAMLEndpoint.this.event.event(EventType.LOGOUT);
                LogoutRequestType logout = (LogoutRequestType)requestAbstractType;
                return this.logoutRequest(logout, relayState);
            }
            SAMLEndpoint.this.event.event(EventType.LOGIN);
            SAMLEndpoint.this.event.error("invalid_token");
            return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
        }

        protected Response logoutRequest(LogoutRequestType request, String relayState) {
            if (request.getNameID() == null && request.getBaseID() == null && request.getEncryptedID() == null) {
                logger.error((Object)"SAML IdP Logout request must contain at least one of BaseID, NameID and EncryptedID");
                SAMLEndpoint.this.event.error("invalid_logout_request");
                return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "identityProviderLogoutFailure", new Object[0]);
            }
            if (request.getSessionIndex() == null || request.getSessionIndex().isEmpty()) {
                if (request.getNameID() == null) {
                    logger.error((Object)"SAML IdP Logout request contains BaseID or EncryptedID without Session Index");
                    SAMLEndpoint.this.event.error("invalid_logout_request");
                    return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.NOT_IMPLEMENTED, "identityProviderLogoutFailure", new Object[0]);
                }
                String brokerUserId = SAMLEndpoint.this.config.getAlias() + "." + request.getNameID().getValue();
                AtomicReference<LogoutRequestType> ref = new AtomicReference<LogoutRequestType>(request);
                SAMLEndpoint.this.session.sessions().getUserSessionByBrokerUserIdStream(SAMLEndpoint.this.realm, brokerUserId).filter(userSession -> userSession.getState() != UserSessionModel.State.LOGGING_OUT && userSession.getState() != UserSessionModel.State.LOGGED_OUT).collect(Collectors.toList()).forEach(this.processLogout(ref));
                request = ref.get();
            } else {
                for (String sessionIndex : request.getSessionIndex()) {
                    String brokerSessionId = SAMLEndpoint.this.config.getAlias() + "." + sessionIndex;
                    UserSessionModel userSession2 = SAMLEndpoint.this.session.sessions().getUserSessionByBrokerSessionId(SAMLEndpoint.this.realm, brokerSessionId);
                    if (userSession2 == null || userSession2.getState() == UserSessionModel.State.LOGGING_OUT || userSession2.getState() == UserSessionModel.State.LOGGED_OUT) continue;
                    Iterator<SamlAuthenticationPreprocessor> it = SamlSessionUtils.getSamlAuthenticationPreprocessorIterator(SAMLEndpoint.this.session);
                    while (it.hasNext()) {
                        request = it.next().beforeProcessingLogoutRequest(request, userSession2, null);
                    }
                    try {
                        AuthenticationManager.backchannelLogout(SAMLEndpoint.this.session, SAMLEndpoint.this.realm, userSession2, (UriInfo)SAMLEndpoint.this.session.getContext().getUri(), SAMLEndpoint.this.clientConnection, SAMLEndpoint.this.headers, false);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"failed to do backchannel logout for userSession", (Throwable)e);
                    }
                }
            }
            String issuerURL = this.getEntityId((UriInfo)SAMLEndpoint.this.session.getContext().getUri(), SAMLEndpoint.this.realm);
            SAML2LogoutResponseBuilder builder = new SAML2LogoutResponseBuilder();
            builder.logoutRequestID(request.getID());
            builder.destination(SAMLEndpoint.this.config.getSingleLogoutServiceUrl());
            builder.issuer(issuerURL);
            JaxrsSAML2BindingBuilder binding = (JaxrsSAML2BindingBuilder)new JaxrsSAML2BindingBuilder(SAMLEndpoint.this.session).relayState(relayState);
            boolean postBinding = SAMLEndpoint.this.config.isPostBindingLogout();
            if (SAMLEndpoint.this.config.isWantAuthnRequestsSigned()) {
                KeyManager.ActiveRsaKey keys = SAMLEndpoint.this.session.keys().getActiveRsaKey(SAMLEndpoint.this.realm);
                String keyName = SAMLEndpoint.this.config.getXmlSigKeyInfoKeyNameTransformer().getKeyName(keys.getKid(), keys.getCertificate());
                ((JaxrsSAML2BindingBuilder)((JaxrsSAML2BindingBuilder)binding.signWith(keyName, keys.getPrivateKey(), keys.getPublicKey(), keys.getCertificate())).signatureAlgorithm(SAMLEndpoint.this.provider.getSignatureAlgorithm())).signDocument();
                if (!postBinding && SAMLEndpoint.this.config.isAddExtensionsElementWithKeyInfo()) {
                    builder.addExtension((SamlProtocolExtensionsAwareBuilder.NodeGenerator)new KeycloakKeySamlExtensionGenerator(keyName));
                }
            }
            try {
                if (postBinding) {
                    return binding.postBinding(builder.buildDocument()).response(SAMLEndpoint.this.config.getSingleLogoutServiceUrl());
                }
                return binding.redirectBinding(builder.buildDocument()).response(SAMLEndpoint.this.config.getSingleLogoutServiceUrl());
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
            catch (ProcessingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected Response handleSamlArt(String samlArt, String relayState, String clientId) {
            try {
                Object object;
                SAMLDocumentHolder samlDocumentHolder = SAMLEndpoint.this.provider.resolveArtifact(SAMLEndpoint.this.session, (UriInfo)SAMLEndpoint.this.session.getContext().getUri(), SAMLEndpoint.this.realm, relayState, samlArt);
                SAML2Object sAML2Object = samlDocumentHolder.getSamlObject();
                if (!(sAML2Object instanceof ArtifactResponseType)) {
                    logger.error((Object)"artifact binding failed: the SAML object is not an ArtifactResponse");
                    SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SAMLEndpoint.this.event.detail("reason", "invalid_artifact_response");
                    SAMLEndpoint.this.event.error("invalid_request");
                    return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
                }
                ArtifactResponseType artifactResponse = (ArtifactResponseType)sAML2Object;
                if (SAMLEndpoint.this.config.isValidateSignature()) {
                    try {
                        this.verifySignature("SAMLResponse", samlDocumentHolder);
                    }
                    catch (VerificationException e) {
                        logger.error((Object)"artifact binding failed: the ArtifactResponse signature is invalid", (Throwable)e);
                        SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                        SAMLEndpoint.this.event.error("invalid_signature");
                        return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "identityProviderInvalidSignatureMessage", new Object[0]);
                    }
                }
                if (!((object = artifactResponse.getAny()) instanceof ResponseType)) {
                    logger.error((Object)"artifact binding failed: the embedded SAML object is not a Response");
                    SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SAMLEndpoint.this.event.detail("reason", "invalid_artifact_response");
                    SAMLEndpoint.this.event.error("invalid_request");
                    return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
                }
                ResponseType embeddedResponse = (ResponseType)object;
                if (this.isDestinationRequired() && embeddedResponse.getDestination() == null && this.containsUnencryptedSignature(samlDocumentHolder)) {
                    logger.error((Object)"artifact binding failed: the embedded Response does not contain a destination");
                    SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SAMLEndpoint.this.event.detail("reason", "missing_required_destination");
                    SAMLEndpoint.this.event.error("invalid_saml_response");
                    return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
                }
                if (!SAMLEndpoint.this.destinationValidator.validate(this.getExpectedDestination(SAMLEndpoint.this.config.getAlias(), clientId), embeddedResponse.getDestination())) {
                    logger.error((Object)"artifact binding failed: the embedded Response has an invalid destination");
                    SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SAMLEndpoint.this.event.detail("reason", "invalid_destination");
                    SAMLEndpoint.this.event.error("invalid_saml_response");
                    return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
                }
                Optional optionalEmbeddedResponseAsString = ArtifactResponseUtil.convertResponseToString((Document)samlDocumentHolder.getSamlDocument());
                if (optionalEmbeddedResponseAsString.isEmpty()) {
                    logger.error((Object)"artifact binding failed: the embedded Response cannot be converted to string");
                    SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SAMLEndpoint.this.event.detail("reason", "invalid_artifact_response");
                    SAMLEndpoint.this.event.error("invalid_request");
                    return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
                }
                String embeddedResponseAsString = (String)optionalEmbeddedResponseAsString.get();
                logger.debugf("embeddedResponseAsString %s", (Object)embeddedResponseAsString);
                String embeddedResponseAsBase64 = PostBindingUtil.base64Encode((String)embeddedResponseAsString);
                return this.execute(null, embeddedResponseAsBase64, null, relayState, clientId);
            }
            catch (IOException e) {
                logger.error((Object)"artifact binding failed", (Throwable)e);
                SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                SAMLEndpoint.this.event.detail("reason", "invalid_artifact_response");
                SAMLEndpoint.this.event.error("invalid_request");
                return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
            }
        }

        private Consumer<UserSessionModel> processLogout(AtomicReference<LogoutRequestType> ref) {
            return userSession -> {
                Iterator<SamlAuthenticationPreprocessor> it = SamlSessionUtils.getSamlAuthenticationPreprocessorIterator(SAMLEndpoint.this.session);
                while (it.hasNext()) {
                    ref.set(it.next().beforeProcessingLogoutRequest((LogoutRequestType)ref.get(), (UserSessionModel)userSession, null));
                }
                try {
                    AuthenticationManager.backchannelLogout(SAMLEndpoint.this.session, SAMLEndpoint.this.realm, userSession, (UriInfo)SAMLEndpoint.this.session.getContext().getUri(), SAMLEndpoint.this.clientConnection, SAMLEndpoint.this.headers, false);
                }
                catch (Exception e) {
                    logger.warn((Object)"failed to do backchannel logout for userSession", (Throwable)e);
                }
            };
        }

        private String getEntityId(UriInfo uriInfo, RealmModel realm) {
            String configEntityId = SAMLEndpoint.this.config.getEntityId();
            if (configEntityId == null || configEntityId.isEmpty()) {
                return UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("realms").path(realm.getName()).build(new Object[0]).toString();
            }
            return configEntityId;
        }

        protected Response handleLoginResponse(String samlResponse, SAMLDocumentHolder holder, ResponseType responseType, String relayState, String clientId) {
            try {
                String email;
                boolean assertionIssuerValidationSuccess;
                AssertionType assertion;
                boolean hasNoSignatureWhenRequired;
                boolean responseIssuerValidationSuccess;
                AuthenticationSessionModel authSession;
                if (StringUtil.isNotBlank((String)clientId)) {
                    authSession = this.samlIdpInitiatedSSO(clientId);
                } else if (StringUtil.isNotBlank((String)relayState)) {
                    authSession = SAMLEndpoint.this.callback.getAndVerifyAuthenticationSession(relayState);
                } else {
                    logger.error((Object)"SAML RelayState parameter was null when it should be returned by the IDP");
                    SAMLEndpoint.this.event.event(EventType.LOGIN);
                    SAMLEndpoint.this.event.error("invalid_saml_response");
                    return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "identityProviderUnexpectedErrorMessage", new Object[0]);
                }
                SAMLEndpoint.this.session.getContext().setAuthenticationSession(authSession);
                if (!this.isSuccessfulSamlResponse(responseType)) {
                    String statusMessage;
                    String string = statusMessage = responseType.getStatus() == null || responseType.getStatus().getStatusMessage() == null ? "identityProviderUnexpectedErrorMessage" : responseType.getStatus().getStatusMessage();
                    if ("authentication_expired".equals(statusMessage)) {
                        return SAMLEndpoint.this.callback.retryLogin((UserAuthenticationIdentityProvider)SAMLEndpoint.this.provider, authSession);
                    }
                    return SAMLEndpoint.this.callback.error((IdentityProviderModel)SAMLEndpoint.this.config, statusMessage);
                }
                if (responseType.getAssertions() == null || responseType.getAssertions().isEmpty()) {
                    return SAMLEndpoint.this.callback.error((IdentityProviderModel)SAMLEndpoint.this.config, "identityProviderUnexpectedErrorMessage");
                }
                boolean assertionIsEncrypted = AssertionUtil.isAssertionEncrypted((ResponseType)responseType);
                if (SAMLEndpoint.this.config.isWantAssertionsEncrypted() && !assertionIsEncrypted) {
                    logger.error((Object)"The assertion is not encrypted, which is required.");
                    SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SAMLEndpoint.this.event.error("invalid_saml_response");
                    return ErrorPage.error(SAMLEndpoint.this.session, authSession, Response.Status.BAD_REQUEST, "invalidRequesterMessage", new Object[0]);
                }
                Element assertionElement = null;
                if (assertionIsEncrypted) {
                    try {
                        SAMLDecryptionKeysLocator decryptionKeyLocator = new SAMLDecryptionKeysLocator(SAMLEndpoint.this.session, SAMLEndpoint.this.realm, SAMLEndpoint.this.config.getEncryptionAlgorithm());
                        assertionElement = AssertionUtil.decryptAssertion((ResponseType)responseType, (XMLEncryptionUtil.DecryptionKeyLocator)decryptionKeyLocator);
                    }
                    catch (ProcessingException ex) {
                        logger.warnf((Throwable)ex, "Not possible to decrypt SAML assertion. Please check realm keys of usage ENC in the realm '%s' and make sure there is a key able to decrypt the assertion encrypted by identity provider '%s'", (Object)SAMLEndpoint.this.realm.getName(), (Object)SAMLEndpoint.this.config.getAlias());
                        throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
                    }
                } else {
                    assertionElement = DocumentUtil.getElement((Document)holder.getSamlDocument(), (QName)new QName(JBossSAMLConstants.ASSERTION.get()));
                }
                String responseIssuer = responseType.getIssuer() != null ? responseType.getIssuer().getValue() : null;
                boolean bl = responseIssuerValidationSuccess = SAMLEndpoint.this.config.getIdpEntityId() == null || responseIssuer != null && responseIssuer.equals(SAMLEndpoint.this.config.getIdpEntityId());
                if (!responseIssuerValidationSuccess) {
                    logger.errorf("Response Issuer validation failed: expected %s, actual %s", (Object)SAMLEndpoint.this.config.getIdpEntityId(), (Object)responseIssuer);
                    SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SAMLEndpoint.this.event.error("invalid_saml_response");
                    return ErrorPage.error(SAMLEndpoint.this.session, authSession, Response.Status.BAD_REQUEST, "invalidRequesterMessage", new Object[0]);
                }
                boolean isArtifactBinding = "artifact".equals(this.getBindingType());
                String expectedRequestId = authSession.getClientNote("SAML_REQUEST_ID_BROKER");
                boolean inResponseToValidationSuccess = SAMLEndpoint.this.validateInResponseToAttribute(responseType, expectedRequestId);
                if (!isArtifactBinding && !inResponseToValidationSuccess) {
                    SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SAMLEndpoint.this.event.error("invalid_saml_response");
                    return ErrorPage.error(SAMLEndpoint.this.session, authSession, Response.Status.BAD_REQUEST, "invalidRequesterMessage", new Object[0]);
                }
                boolean signed = AssertionUtil.isSignedElement((Element)assertionElement);
                boolean assertionSignatureNotExistsWhenRequired = SAMLEndpoint.this.config.isWantAssertionsSigned() && !signed;
                boolean signatureNotValid = signed && SAMLEndpoint.this.config.isValidateSignature() && !AssertionUtil.isSignatureValid((Element)assertionElement, (KeyLocator)this.getIDPKeyLocator());
                boolean bl2 = hasNoSignatureWhenRequired = !signed && SAMLEndpoint.this.config.isValidateSignature() && !this.containsUnencryptedSignature(holder);
                if (assertionSignatureNotExistsWhenRequired || signatureNotValid || hasNoSignatureWhenRequired) {
                    logger.error((Object)"validation failed");
                    SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SAMLEndpoint.this.event.error("invalid_signature");
                    return ErrorPage.error(SAMLEndpoint.this.session, authSession, Response.Status.BAD_REQUEST, "identityProviderInvalidSignatureMessage", new Object[0]);
                }
                if (AssertionUtil.isIdEncrypted((ResponseType)responseType)) {
                    try {
                        SAMLDecryptionKeysLocator decryptionKeyLocator = new SAMLDecryptionKeysLocator(SAMLEndpoint.this.session, SAMLEndpoint.this.realm, SAMLEndpoint.this.config.getEncryptionAlgorithm());
                        AssertionUtil.decryptId((ResponseType)responseType, (XMLEncryptionUtil.DecryptionKeyLocator)decryptionKeyLocator);
                    }
                    catch (ProcessingException ex) {
                        logger.warnf((Throwable)ex, "Not possible to decrypt SAML encryptedId. Please check realm keys of usage ENC in the realm '%s' and make sure there is a key able to decrypt the encryptedId encrypted by identity provider '%s'", (Object)SAMLEndpoint.this.realm.getName(), (Object)SAMLEndpoint.this.config.getAlias());
                        throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
                    }
                }
                String assertionIssuer = (assertion = ((ResponseType.RTChoiceType)responseType.getAssertions().get(0)).getAssertion()).getIssuer() != null ? assertion.getIssuer().getValue() : null;
                boolean bl3 = assertionIssuerValidationSuccess = SAMLEndpoint.this.config.getIdpEntityId() == null || assertionIssuer != null && assertionIssuer.equals(SAMLEndpoint.this.config.getIdpEntityId());
                if (!assertionIssuerValidationSuccess) {
                    logger.errorf("Assertion Issuer validation failed: expected %s, actual %s", (Object)SAMLEndpoint.this.config.getIdpEntityId(), (Object)assertionIssuer);
                    SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SAMLEndpoint.this.event.error("invalid_saml_response");
                    return ErrorPage.error(SAMLEndpoint.this.session, authSession, Response.Status.BAD_REQUEST, "invalidRequesterMessage", new Object[0]);
                }
                NameIDType subjectNameID = SAMLEndpoint.this.getSubjectNameID(assertion);
                String principal = SAMLEndpoint.this.getPrincipal(assertion);
                if (principal == null) {
                    logger.errorf("no principal in assertion; expected: %s", (Object)SAMLEndpoint.this.expectedPrincipalType());
                    SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SAMLEndpoint.this.event.error("invalid_saml_response");
                    return ErrorPage.error(SAMLEndpoint.this.session, authSession, Response.Status.BAD_REQUEST, "invalidRequesterMessage", new Object[0]);
                }
                BrokeredIdentityContext identity = new BrokeredIdentityContext(principal, (IdentityProviderModel)SAMLEndpoint.this.config);
                identity.getContextData().put(SAMLEndpoint.SAML_LOGIN_RESPONSE, responseType);
                identity.getContextData().put(SAMLEndpoint.SAML_ASSERTION, assertion);
                identity.setAuthenticationSession(authSession);
                identity.setUsername(principal);
                if (subjectNameID != null && subjectNameID.getFormat() != null && subjectNameID.getFormat().toString().equals(JBossSAMLURIConstants.NAMEID_FORMAT_EMAIL.get())) {
                    identity.setEmail(subjectNameID.getValue());
                }
                if (Booleans.isTrue((Boolean)SAMLEndpoint.this.config.isStoreToken()).booleanValue()) {
                    identity.setToken(samlResponse);
                }
                ConditionsValidator.Builder cvb = new ConditionsValidator.Builder(assertion.getID(), (CommonConditionsType)assertion.getConditions(), SAMLEndpoint.this.destinationValidator).clockSkewInMillis(1000 * SAMLEndpoint.this.config.getAllowedClockSkew());
                try {
                    String issuerURL = this.getEntityId((UriInfo)SAMLEndpoint.this.session.getContext().getUri(), SAMLEndpoint.this.realm);
                    cvb.addAllowedAudience(new URI[]{URI.create(issuerURL)});
                    if (responseType.getDestination() != null) {
                        cvb.addAllowedAudience(new URI[]{URI.create(responseType.getDestination())});
                    }
                }
                catch (IllegalArgumentException issuerURL) {
                    // empty catch block
                }
                if (!cvb.build().isValid()) {
                    logger.error((Object)"Assertion expired.");
                    SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SAMLEndpoint.this.event.error("invalid_saml_response");
                    return ErrorPage.error(SAMLEndpoint.this.session, authSession, Response.Status.BAD_REQUEST, "expiredCodeMessage", new Object[0]);
                }
                AuthnStatementType authn = null;
                for (Object statement : assertion.getStatements()) {
                    if (!(statement instanceof AuthnStatementType)) continue;
                    authn = (AuthnStatementType)statement;
                    identity.getContextData().put(SAMLEndpoint.SAML_AUTHN_STATEMENT, authn);
                    break;
                }
                if (assertion.getAttributeStatements() != null && (email = SAMLEndpoint.this.getX500Attribute(assertion, X500SAMLProfileConstants.EMAIL)) != null) {
                    identity.setEmail(email);
                }
                String brokerUserId = SAMLEndpoint.this.config.getAlias() + "." + principal;
                identity.setBrokerUserId(brokerUserId);
                identity.setIdp((UserAuthenticationIdentityProvider)SAMLEndpoint.this.provider);
                if (authn != null && authn.getSessionIndex() != null) {
                    identity.setBrokerSessionId(SAMLEndpoint.this.config.getAlias() + "." + authn.getSessionIndex());
                }
                return SAMLEndpoint.this.callback.authenticated(identity);
            }
            catch (WebApplicationException e) {
                return e.getResponse();
            }
            catch (Exception e) {
                throw new IdentityBrokerException("Could not process response from SAML identity provider.", (Throwable)e);
            }
        }

        private AuthenticationSessionModel samlIdpInitiatedSSO(String clientUrlName) {
            SAMLEndpoint.this.event.event(EventType.LOGIN);
            CacheControlUtil.noBackButtonCacheControlHeader(SAMLEndpoint.this.session);
            Optional oClient = SAMLEndpoint.this.session.clients().searchClientsByAttributes(SAMLEndpoint.this.realm, Collections.singletonMap("saml_idp_initiated_sso_url_name", clientUrlName), Integer.valueOf(0), Integer.valueOf(1)).findFirst();
            if (!oClient.isPresent()) {
                SAMLEndpoint.this.event.error("client_not_found");
                Response response = ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "clientNotFoundMessage", new Object[0]);
                throw new WebApplicationException(response);
            }
            LoginProtocolFactory factory = (LoginProtocolFactory)SAMLEndpoint.this.session.getKeycloakSessionFactory().getProviderFactory(LoginProtocol.class, "saml");
            SamlService samlService = (SamlService)factory.createProtocolEndpoint(SAMLEndpoint.this.session, SAMLEndpoint.this.event);
            AuthenticationSessionModel authSession = samlService.getOrCreateLoginSessionForIdpInitiatedSso(SAMLEndpoint.this.session, SAMLEndpoint.this.realm, (ClientModel)oClient.get(), null);
            if (authSession == null) {
                SAMLEndpoint.this.event.error("invalid_redirect_uri");
                Response response = ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "invalidRedirectUriMessage", new Object[0]);
                throw new WebApplicationException(response);
            }
            return authSession;
        }

        private boolean isSuccessfulSamlResponse(ResponseType responseType) {
            return responseType != null && responseType.getStatus() != null && responseType.getStatus().getStatusCode() != null && responseType.getStatus().getStatusCode().getValue() != null && Objects.equals(responseType.getStatus().getStatusCode().getValue().toString(), JBossSAMLURIConstants.STATUS_SUCCESS.get());
        }

        public Response handleSamlResponse(String samlResponse, String relayState, String clientId) {
            SAMLDocumentHolder holder = this.extractResponseDocument(samlResponse);
            if (holder == null) {
                SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                SAMLEndpoint.this.event.detail("reason", "invalid_saml_document");
                SAMLEndpoint.this.event.error("invalid_saml_response");
                return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "identityProviderInvalidResponseMessage", new Object[0]);
            }
            StatusResponseType statusResponse = (StatusResponseType)holder.getSamlObject();
            if (this.isDestinationRequired() && statusResponse.getDestination() == null && this.containsUnencryptedSignature(holder)) {
                SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                SAMLEndpoint.this.event.detail("reason", "missing_required_destination");
                SAMLEndpoint.this.event.error("invalid_saml_response");
                return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
            }
            if (!SAMLEndpoint.this.destinationValidator.validate(this.getExpectedDestination(SAMLEndpoint.this.config.getAlias(), clientId), statusResponse.getDestination())) {
                SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                SAMLEndpoint.this.event.detail("reason", "invalid_destination");
                SAMLEndpoint.this.event.error("invalid_saml_response");
                return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "invalidRequestMessage", new Object[0]);
            }
            if (SAMLEndpoint.this.config.isValidateSignature()) {
                try {
                    this.verifySignature("SAMLResponse", holder);
                }
                catch (VerificationException e) {
                    logger.error((Object)"validation failed", (Throwable)e);
                    SAMLEndpoint.this.event.event(EventType.IDENTITY_PROVIDER_RESPONSE);
                    SAMLEndpoint.this.event.error("invalid_signature");
                    return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "identityProviderInvalidSignatureMessage", new Object[0]);
                }
            }
            if (statusResponse instanceof ResponseType) {
                return this.handleLoginResponse(samlResponse, holder, (ResponseType)statusResponse, relayState, clientId);
            }
            return this.handleLogoutResponse(holder, statusResponse, relayState);
        }

        protected Response handleLogoutResponse(SAMLDocumentHolder holder, StatusResponseType responseType, String relayState) {
            if (relayState == null) {
                logger.error((Object)"no valid user session");
                SAMLEndpoint.this.event.event(EventType.LOGOUT);
                SAMLEndpoint.this.event.error("user_session_not_found");
                return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "identityProviderUnexpectedErrorMessage", new Object[0]);
            }
            UserSessionModel userSession = SAMLEndpoint.this.session.sessions().getUserSession(SAMLEndpoint.this.realm, relayState);
            if (userSession == null) {
                logger.error((Object)"no valid user session");
                SAMLEndpoint.this.event.event(EventType.LOGOUT);
                SAMLEndpoint.this.event.error("user_session_not_found");
                return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "identityProviderUnexpectedErrorMessage", new Object[0]);
            }
            if (userSession.getState() != UserSessionModel.State.LOGGING_OUT) {
                logger.error((Object)"usersession in different state");
                SAMLEndpoint.this.event.event(EventType.LOGOUT);
                SAMLEndpoint.this.event.error("user_session_not_found");
                return ErrorPage.error(SAMLEndpoint.this.session, null, Response.Status.BAD_REQUEST, "sessionNotActiveMessage", new Object[0]);
            }
            return AuthenticationManager.finishBrowserLogout(SAMLEndpoint.this.session, SAMLEndpoint.this.realm, userSession, (UriInfo)SAMLEndpoint.this.session.getContext().getUri(), SAMLEndpoint.this.clientConnection, SAMLEndpoint.this.headers);
        }

        private String getExpectedDestination(String providerAlias, String clientId) {
            if (clientId != null) {
                return Urls.identityProviderAuthnResponse(SAMLEndpoint.this.session.getContext().getUri().getBaseUri(), providerAlias, SAMLEndpoint.this.realm.getName(), clientId).toString();
            }
            return Urls.identityProviderAuthnResponse(SAMLEndpoint.this.session.getContext().getUri().getBaseUri(), providerAlias, SAMLEndpoint.this.realm.getName()).toString();
        }
    }
}

