/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.json;

import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import javax.json.JsonValue;
import org.apache.felix.cm.json.ConfigurationReader;
import org.apache.felix.cm.json.ConfigurationWriter;
import org.apache.felix.cm.json.impl.ConfigurationReaderImpl;
import org.apache.felix.cm.json.impl.ConfigurationWriterImpl;
import org.apache.felix.cm.json.impl.JsonSupport;
import org.apache.felix.cm.json.impl.OrderedDictionary;

public class Configurations {
    private Configurations() {
    }

    public static ConfigurationReader.Builder buildReader() {
        return new ConfigurationReaderImpl();
    }

    public static ConfigurationWriter.Builder buildWriter() {
        return new ConfigurationWriterImpl();
    }

    public static Reader jsonCommentAwareReader(Reader reader) throws IOException {
        return JsonSupport.createCommentRemovingReader(reader);
    }

    public static Hashtable<String, Object> newConfiguration() {
        return new OrderedDictionary();
    }

    public static Object convertToObject(JsonValue value) {
        return JsonSupport.convertToObject(value);
    }

    public static JsonValue convertToJsonValue(Object value) {
        return JsonSupport.convertToJson(value);
    }
}

