/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec4(165ul, 133ul, 193ul, 76ul) >> 0ul) => u64vec4(165ul, 133ul, 193ul, 76ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) >> 1ul) => u64vec4(82ul, 66ul, 96ul, 38ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) >> 2ul) => u64vec4(41ul, 33ul, 48ul, 19ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) >> 5ul) => u64vec4(5ul, 4ul, 6ul, 2ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) >> 25ul) => u64vec4(0ul, 0ul, 0ul, 0ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) >> 31ul) => u64vec4(0ul, 0ul, 0ul, 0ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) >> 32ul) => u64vec4(0ul, 0ul, 0ul, 0ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) >> 47ul) => u64vec4(0ul, 0ul, 0ul, 0ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) >> 63ul) => u64vec4(0ul, 0ul, 0ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) >> 0ul) => u64vec4(80ul, 15ul, 51ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) >> 1ul) => u64vec4(40ul, 7ul, 25ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) >> 2ul) => u64vec4(20ul, 3ul, 12ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) >> 5ul) => u64vec4(2ul, 0ul, 1ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) >> 25ul) => u64vec4(0ul, 0ul, 0ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) >> 31ul) => u64vec4(0ul, 0ul, 0ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) >> 32ul) => u64vec4(0ul, 0ul, 0ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) >> 47ul) => u64vec4(0ul, 0ul, 0ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) >> 63ul) => u64vec4(0ul, 0ul, 0ul, 0ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) >> 0ul), u64vec4(165ul, 133ul, 193ul, 76ul))) ? 1 : -1] array0;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) >> 1ul), u64vec4(82ul, 66ul, 96ul, 38ul))) ? 1 : -1] array1;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) >> 2ul), u64vec4(41ul, 33ul, 48ul, 19ul))) ? 1 : -1] array2;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) >> 5ul), u64vec4(5ul, 4ul, 6ul, 2ul))) ? 1 : -1] array3;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) >> 25ul), u64vec4(0ul, 0ul, 0ul, 0ul))) ? 1 : -1] array4;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) >> 31ul), u64vec4(0ul, 0ul, 0ul, 0ul))) ? 1 : -1] array5;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) >> 32ul), u64vec4(0ul, 0ul, 0ul, 0ul))) ? 1 : -1] array6;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) >> 47ul), u64vec4(0ul, 0ul, 0ul, 0ul))) ? 1 : -1] array7;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) >> 63ul), u64vec4(0ul, 0ul, 0ul, 0ul))) ? 1 : -1] array8;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) >> 0ul), u64vec4(80ul, 15ul, 51ul, 0ul))) ? 1 : -1] array9;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) >> 1ul), u64vec4(40ul, 7ul, 25ul, 0ul))) ? 1 : -1] array10;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) >> 2ul), u64vec4(20ul, 3ul, 12ul, 0ul))) ? 1 : -1] array11;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) >> 5ul), u64vec4(2ul, 0ul, 1ul, 0ul))) ? 1 : -1] array12;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) >> 25ul), u64vec4(0ul, 0ul, 0ul, 0ul))) ? 1 : -1] array13;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) >> 31ul), u64vec4(0ul, 0ul, 0ul, 0ul))) ? 1 : -1] array14;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) >> 32ul), u64vec4(0ul, 0ul, 0ul, 0ul))) ? 1 : -1] array15;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) >> 47ul), u64vec4(0ul, 0ul, 0ul, 0ul))) ? 1 : -1] array16;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) >> 63ul), u64vec4(0ul, 0ul, 0ul, 0ul))) ? 1 : -1] array17;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
