/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.resolver.NameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.concurrent.ConcurrentMap;

final class InflightNameResolver<T>
implements NameResolver<T> {
    private final EventExecutor executor;
    private final NameResolver<T> delegate;
    private final ConcurrentMap<String, Promise<T>> resolvesInProgress;
    private final ConcurrentMap<String, Promise<List<T>>> resolveAllsInProgress;

    InflightNameResolver(EventExecutor executor, NameResolver<T> delegate, ConcurrentMap<String, Promise<T>> resolvesInProgress, ConcurrentMap<String, Promise<List<T>>> resolveAllsInProgress) {
        this.executor = (EventExecutor)ObjectUtil.checkNotNull((Object)executor, (String)"executor");
        this.delegate = (NameResolver)ObjectUtil.checkNotNull(delegate, (String)"delegate");
        this.resolvesInProgress = (ConcurrentMap)ObjectUtil.checkNotNull(resolvesInProgress, (String)"resolvesInProgress");
        this.resolveAllsInProgress = (ConcurrentMap)ObjectUtil.checkNotNull(resolveAllsInProgress, (String)"resolveAllsInProgress");
    }

    public Future<T> resolve(String inetHost) {
        return this.resolve(inetHost, (Promise<T>)this.executor.newPromise());
    }

    public Future<List<T>> resolveAll(String inetHost) {
        return this.resolveAll(inetHost, (Promise<List<T>>)this.executor.newPromise());
    }

    public void close() {
        this.delegate.close();
    }

    public Promise<T> resolve(String inetHost, Promise<T> promise) {
        return this.resolve(this.resolvesInProgress, inetHost, promise, false);
    }

    public Promise<List<T>> resolveAll(String inetHost, Promise<List<T>> promise) {
        return this.resolve(this.resolveAllsInProgress, inetHost, promise, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <U> Promise<U> resolve(ConcurrentMap<String, Promise<U>> resolveMap, String inetHost, Promise<U> promise, boolean resolveAll) {
        Promise<U> earlyPromise = resolveMap.putIfAbsent(inetHost, promise);
        if (earlyPromise != null) {
            if (earlyPromise.isDone()) {
                InflightNameResolver.transferResult(earlyPromise, promise);
            } else {
                earlyPromise.addListener((GenericFutureListener)((FutureListener)f -> InflightNameResolver.transferResult(f, promise)));
            }
        } else {
            try {
                if (resolveAll) {
                    Promise castPromise = promise;
                    this.delegate.resolveAll(inetHost, castPromise);
                } else {
                    Promise castPromise = promise;
                    this.delegate.resolve(inetHost, castPromise);
                }
            }
            finally {
                if (promise.isDone()) {
                    resolveMap.remove(inetHost);
                } else {
                    promise.addListener((GenericFutureListener)((FutureListener)f -> resolveMap.remove(inetHost)));
                }
            }
        }
        return promise;
    }

    private static <T> void transferResult(Future<T> src, Promise<T> dst) {
        if (src.isSuccess()) {
            dst.trySuccess(src.getNow());
        } else {
            dst.tryFailure(src.cause());
        }
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this) + '(' + this.delegate + ')';
    }
}

