/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import jakarta.inject.Inject;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.helper.model.PositionUtil;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.reports.common.TripsConfig;
import org.traccar.session.cache.CacheManager;
import org.traccar.session.state.MotionProcessor;
import org.traccar.session.state.MotionState;
import org.traccar.session.state.NewMotionProcessor;
import org.traccar.session.state.NewMotionState;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

public class MotionEventHandler
extends BaseEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MotionEventHandler.class);
    private static final String KEY_MOTION_TIME = "motionTime";
    private static final String KEY_MOTION_LAT = "motionLat";
    private static final String KEY_MOTION_LON = "motionLon";
    private final Config config;
    private final CacheManager cacheManager;
    private final Storage storage;

    @Inject
    public MotionEventHandler(Config config, CacheManager cacheManager, Storage storage) {
        this.config = config;
        this.cacheManager = cacheManager;
        this.storage = storage;
    }

    @Override
    public void onPosition(Position position, BaseEventHandler.Callback callback) {
        long deviceId = position.getDeviceId();
        Device device = this.cacheManager.getObject(Device.class, deviceId);
        if (device == null || !PositionUtil.isLatest(this.cacheManager, position)) {
            return;
        }
        AttributeUtil.CacheProvider attributeProvider = new AttributeUtil.CacheProvider(this.cacheManager, deviceId);
        if (this.config.getBoolean(Keys.REPORT_TRIP_NEW_LOGIC)) {
            double minDistance = AttributeUtil.lookup(attributeProvider, Keys.REPORT_TRIP_MIN_DISTANCE).longValue();
            long minDuration = AttributeUtil.lookup(attributeProvider, Keys.REPORT_TRIP_MIN_DURATION) * 1000L;
            long stopGap = AttributeUtil.lookup(attributeProvider, Keys.REPORT_TRIP_STOP_GAP) * 1000L;
            this.handleNewLogic(device, position, minDistance, minDuration, stopGap, callback);
        } else {
            TripsConfig tripsConfig = new TripsConfig(attributeProvider);
            this.handleOldLogic(device, position, tripsConfig, callback);
        }
    }

    private void handleNewLogic(Device device, Position position, double minDistance, long minDuration, long stopGap, BaseEventHandler.Callback callback) {
        NewMotionState state = new NewMotionState();
        state.setMotionStreak(device.getMotionStreak());
        state.setPositions(this.cacheManager.getPositions(device.getId()));
        if (device.hasAttribute(KEY_MOTION_TIME)) {
            state.setEventPosition(new Date(device.getLong(KEY_MOTION_TIME)), device.getDouble(KEY_MOTION_LAT), device.getDouble(KEY_MOTION_LON));
        } else {
            state.setEventPosition(position);
        }
        NewMotionProcessor.updateState(state, position, minDistance, minDuration, stopGap);
        if (state.isChanged()) {
            device.setMotionStreak(state.getMotionStreak());
            device.set(KEY_MOTION_TIME, state.getEventTime().getTime());
            device.set(KEY_MOTION_LAT, state.getEventLatitude());
            device.set(KEY_MOTION_LON, state.getEventLongitude());
            try {
                this.storage.updateObject(device, new Request((Columns)new Columns.Include("motionStreak", "attributes"), new Condition.Equals("id", device.getId())));
            }
            catch (StorageException e) {
                LOGGER.warn("Update device motion error", (Throwable)e);
            }
        }
        for (Event event : state.getEvents()) {
            callback.eventDetected(event);
        }
    }

    private void handleOldLogic(Device device, Position position, TripsConfig tripsConfig, BaseEventHandler.Callback callback) {
        MotionState state = MotionState.fromDevice(device);
        Position last = this.cacheManager.getPosition(device.getId());
        MotionProcessor.updateState(state, last, position, position.getBoolean("motion"), tripsConfig);
        if (state.isChanged()) {
            state.toDevice(device);
            try {
                this.storage.updateObject(device, new Request((Columns)new Columns.Include("motionStreak", "motionState", "motionPositionId", KEY_MOTION_TIME, "motionDistance"), new Condition.Equals("id", device.getId())));
            }
            catch (StorageException e) {
                LOGGER.warn("Update device motion error", (Throwable)e);
            }
        }
        if (state.getEvent() != null) {
            callback.eventDetected(state.getEvent());
        }
    }
}

