/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.pipeline.expressions;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.Blob;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FieldValue;
import com.google.cloud.firestore.GeoPoint;
import com.google.cloud.firestore.VectorValue;
import com.google.cloud.firestore.pipeline.expressions.AggregateFunction;
import com.google.cloud.firestore.pipeline.expressions.AliasedExpression;
import com.google.cloud.firestore.pipeline.expressions.BooleanExpression;
import com.google.cloud.firestore.pipeline.expressions.BooleanFunctionExpression;
import com.google.cloud.firestore.pipeline.expressions.Constant;
import com.google.cloud.firestore.pipeline.expressions.Field;
import com.google.cloud.firestore.pipeline.expressions.FunctionExpression;
import com.google.cloud.firestore.pipeline.expressions.Ordering;
import com.google.cloud.firestore.pipeline.expressions.Selectable;
import com.google.common.collect.ImmutableList;
import com.google.firestore.v1.Value;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

@BetaApi
public abstract class Expression {
    Expression() {
    }

    private static Expression toExprOrConstant(Object o) {
        return o instanceof Expression ? (Expression)o : new Constant(o);
    }

    private static ImmutableList<Expression> toArrayOfExprOrConstant(Object ... others) {
        return (ImmutableList)Arrays.stream(others).map(Expression::toExprOrConstant).collect(ImmutableList.toImmutableList());
    }

    @InternalApi
    abstract Value toProto();

    @BetaApi
    public static Expression constant(String value) {
        return new Constant(value);
    }

    @BetaApi
    public static Expression constant(Number value) {
        return new Constant(value);
    }

    @BetaApi
    public static Expression constant(Date value) {
        return new Constant(value);
    }

    @BetaApi
    public static Expression constant(Timestamp value) {
        return new Constant(value);
    }

    @BetaApi
    public static BooleanExpression constant(Boolean value) {
        return Expression.equal((Expression)new Constant(value), (Object)true);
    }

    @BetaApi
    public static Expression constant(GeoPoint value) {
        return new Constant(value);
    }

    @BetaApi
    public static Expression constant(Blob value) {
        return new Constant(value);
    }

    @BetaApi
    public static Expression constant(DocumentReference value) {
        return new Constant(value);
    }

    @BetaApi
    public static Expression constant(byte[] value) {
        return new Constant(value);
    }

    @BetaApi
    public static Expression constant(VectorValue value) {
        return new Constant(value);
    }

    @BetaApi
    public static Expression nullValue() {
        return Constant.NULL;
    }

    @BetaApi
    public static Field field(String path) {
        return Field.ofUserPath(path);
    }

    @BetaApi
    public static Field field(FieldPath fieldPath) {
        return Field.ofUserPath(fieldPath.toString());
    }

    @BetaApi
    public static Expression currentTimestamp() {
        return new FunctionExpression("current_timestamp", (List<? extends Expression>)ImmutableList.of());
    }

    @BetaApi
    public static Expression ifAbsent(Expression ifExpr, Expression elseExpr) {
        return new FunctionExpression("if_absent", (List<? extends Expression>)ImmutableList.of((Object)ifExpr, (Object)elseExpr));
    }

    @BetaApi
    public static Expression ifAbsent(Expression ifExpr, Object elseValue) {
        return Expression.ifAbsent(ifExpr, Expression.toExprOrConstant(elseValue));
    }

    @BetaApi
    public static Expression ifAbsent(String ifFieldName, Expression elseExpr) {
        return Expression.ifAbsent((Expression)Expression.field(ifFieldName), elseExpr);
    }

    @BetaApi
    public static Expression ifAbsent(String ifFieldName, Object elseValue) {
        return Expression.ifAbsent((Expression)Expression.field(ifFieldName), Expression.toExprOrConstant(elseValue));
    }

    @BetaApi
    public static Expression join(Expression arrayExpression, String delimiter) {
        return new FunctionExpression("join", (List<? extends Expression>)ImmutableList.of((Object)arrayExpression, (Object)Expression.constant(delimiter)));
    }

    @BetaApi
    public static Expression join(Expression arrayExpression, Expression delimiterExpression) {
        return new FunctionExpression("join", (List<? extends Expression>)ImmutableList.of((Object)arrayExpression, (Object)delimiterExpression));
    }

    @BetaApi
    public static Expression join(String arrayFieldName, String delimiter) {
        return Expression.join((Expression)Expression.field(arrayFieldName), Expression.constant(delimiter));
    }

    @BetaApi
    public static Expression join(String arrayFieldName, Expression delimiterExpression) {
        return Expression.join((Expression)Expression.field(arrayFieldName), delimiterExpression);
    }

    @BetaApi
    public static Expression rawExpression(String name, Expression ... expr) {
        return new FunctionExpression(name, (List<? extends Expression>)ImmutableList.copyOf((Object[])expr));
    }

    @BetaApi
    public static BooleanExpression and(BooleanExpression condition, BooleanExpression ... conditions) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)condition);
        builder.add((Object[])conditions);
        return new BooleanFunctionExpression("and", (List<? extends Expression>)builder.build());
    }

    @BetaApi
    public static BooleanExpression or(BooleanExpression condition, BooleanExpression ... conditions) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)condition);
        builder.add((Object[])conditions);
        return new BooleanFunctionExpression("or", (List<? extends Expression>)builder.build());
    }

    @BetaApi
    public static BooleanExpression xor(BooleanExpression condition, BooleanExpression ... conditions) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)condition);
        builder.add((Object[])conditions);
        return new BooleanFunctionExpression("xor", (List<? extends Expression>)builder.build());
    }

    @BetaApi
    public static BooleanExpression not(BooleanExpression condition) {
        return new BooleanFunctionExpression("not", condition);
    }

    @BetaApi
    public static Expression add(Expression first, Expression second) {
        return new FunctionExpression("add", (List<? extends Expression>)ImmutableList.of((Object)first, (Object)second));
    }

    @BetaApi
    public static Expression add(Expression first, Number second) {
        return Expression.add(first, Expression.constant(second));
    }

    @BetaApi
    public static Expression add(String fieldName, Expression second) {
        return Expression.add((Expression)Expression.field(fieldName), second);
    }

    @BetaApi
    public static Expression add(String fieldName, Number second) {
        return Expression.add((Expression)Expression.field(fieldName), Expression.constant(second));
    }

    @BetaApi
    public static Expression subtract(Expression minuend, Expression subtrahend) {
        return new FunctionExpression("subtract", (List<? extends Expression>)ImmutableList.of((Object)minuend, (Object)subtrahend));
    }

    @BetaApi
    public static Expression subtract(Expression minuend, Number subtrahend) {
        return Expression.subtract(minuend, Expression.constant(subtrahend));
    }

    @BetaApi
    public static Expression subtract(String fieldName, Expression subtrahend) {
        return Expression.subtract((Expression)Expression.field(fieldName), subtrahend);
    }

    @BetaApi
    public static Expression subtract(String fieldName, Number subtrahend) {
        return Expression.subtract((Expression)Expression.field(fieldName), Expression.constant(subtrahend));
    }

    @BetaApi
    public static Expression multiply(Expression first, Expression second) {
        return new FunctionExpression("multiply", (List<? extends Expression>)ImmutableList.of((Object)first, (Object)second));
    }

    @BetaApi
    public static Expression multiply(Expression first, Number second) {
        return Expression.multiply(first, Expression.constant(second));
    }

    @BetaApi
    public static Expression multiply(String fieldName, Expression second) {
        return Expression.multiply((Expression)Expression.field(fieldName), second);
    }

    @BetaApi
    public static Expression multiply(String fieldName, Number second) {
        return Expression.multiply((Expression)Expression.field(fieldName), Expression.constant(second));
    }

    @BetaApi
    public static Expression divide(Expression dividend, Expression divisor) {
        return new FunctionExpression("divide", (List<? extends Expression>)ImmutableList.of((Object)dividend, (Object)divisor));
    }

    @BetaApi
    public static Expression divide(Expression dividend, Number divisor) {
        return Expression.divide(dividend, Expression.constant(divisor));
    }

    @BetaApi
    public static Expression divide(String fieldName, Expression divisor) {
        return Expression.divide((Expression)Expression.field(fieldName), divisor);
    }

    @BetaApi
    public static Expression divide(String fieldName, Number divisor) {
        return Expression.divide((Expression)Expression.field(fieldName), Expression.constant(divisor));
    }

    @BetaApi
    public static Expression mod(Expression dividend, Expression divisor) {
        return new FunctionExpression("mod", (List<? extends Expression>)ImmutableList.of((Object)dividend, (Object)divisor));
    }

    @BetaApi
    public static Expression mod(Expression dividend, Number divisor) {
        return Expression.mod(dividend, Expression.constant(divisor));
    }

    @BetaApi
    public static Expression mod(String fieldName, Expression divisor) {
        return Expression.mod((Expression)Expression.field(fieldName), divisor);
    }

    @BetaApi
    public static Expression mod(String fieldName, Number divisor) {
        return Expression.mod((Expression)Expression.field(fieldName), Expression.constant(divisor));
    }

    @BetaApi
    public static BooleanExpression equal(Expression left, Expression right) {
        return new BooleanFunctionExpression("equal", left, right);
    }

    @BetaApi
    public static BooleanExpression equal(Expression left, Object right) {
        return new BooleanFunctionExpression("equal", left, Expression.toExprOrConstant(right));
    }

    @BetaApi
    public static BooleanExpression equal(String fieldName, Expression right) {
        return Expression.equal((Expression)Expression.field(fieldName), right);
    }

    @BetaApi
    public static BooleanExpression equal(String fieldName, Object right) {
        return Expression.equal((Expression)Expression.field(fieldName), Expression.toExprOrConstant(right));
    }

    @BetaApi
    public static BooleanExpression notEqual(Expression left, Expression right) {
        return new BooleanFunctionExpression("not_equal", left, right);
    }

    @BetaApi
    public static BooleanExpression notEqual(Expression left, Object right) {
        return new BooleanFunctionExpression("not_equal", left, Expression.toExprOrConstant(right));
    }

    @BetaApi
    public static BooleanExpression notEqual(String fieldName, Expression right) {
        return Expression.notEqual((Expression)Expression.field(fieldName), right);
    }

    @BetaApi
    public static BooleanExpression notEqual(String fieldName, Object right) {
        return Expression.notEqual((Expression)Expression.field(fieldName), Expression.toExprOrConstant(right));
    }

    @BetaApi
    public static BooleanExpression greaterThan(Expression left, Expression right) {
        return new BooleanFunctionExpression("greater_than", left, right);
    }

    @BetaApi
    public static BooleanExpression greaterThan(Expression left, Object right) {
        return new BooleanFunctionExpression("greater_than", left, Expression.toExprOrConstant(right));
    }

    @BetaApi
    public static BooleanExpression greaterThan(String fieldName, Expression right) {
        return Expression.greaterThan((Expression)Expression.field(fieldName), right);
    }

    @BetaApi
    public static BooleanExpression greaterThan(String fieldName, Object right) {
        return Expression.greaterThan((Expression)Expression.field(fieldName), Expression.toExprOrConstant(right));
    }

    @BetaApi
    public static BooleanExpression greaterThanOrEqual(Expression left, Expression right) {
        return new BooleanFunctionExpression("greater_than_or_equal", left, right);
    }

    @BetaApi
    public static BooleanExpression greaterThanOrEqual(Expression left, Object right) {
        return new BooleanFunctionExpression("greater_than_or_equal", left, Expression.toExprOrConstant(right));
    }

    @BetaApi
    public static BooleanExpression greaterThanOrEqual(String fieldName, Expression right) {
        return Expression.greaterThanOrEqual((Expression)Expression.field(fieldName), right);
    }

    @BetaApi
    public static BooleanExpression greaterThanOrEqual(String fieldName, Object right) {
        return Expression.greaterThanOrEqual((Expression)Expression.field(fieldName), Expression.toExprOrConstant(right));
    }

    @BetaApi
    public static BooleanExpression lessThan(Expression left, Expression right) {
        return new BooleanFunctionExpression("less_than", left, right);
    }

    @BetaApi
    public static BooleanExpression lessThan(Expression left, Object right) {
        return new BooleanFunctionExpression("less_than", left, Expression.toExprOrConstant(right));
    }

    @BetaApi
    public static BooleanExpression lessThan(String fieldName, Expression right) {
        return Expression.lessThan((Expression)Expression.field(fieldName), right);
    }

    @BetaApi
    public static BooleanExpression lessThan(String fieldName, Object right) {
        return Expression.lessThan((Expression)Expression.field(fieldName), Expression.toExprOrConstant(right));
    }

    @BetaApi
    public static BooleanExpression lessThanOrEqual(Expression left, Expression right) {
        return new BooleanFunctionExpression("less_than_or_equal", left, right);
    }

    @BetaApi
    public static BooleanExpression lessThanOrEqual(Expression left, Object right) {
        return new BooleanFunctionExpression("less_than_or_equal", left, Expression.toExprOrConstant(right));
    }

    @BetaApi
    public static BooleanExpression lessThanOrEqual(String fieldName, Expression right) {
        return Expression.lessThanOrEqual((Expression)Expression.field(fieldName), right);
    }

    @BetaApi
    public static BooleanExpression lessThanOrEqual(String fieldName, Object right) {
        return Expression.lessThanOrEqual((Expression)Expression.field(fieldName), Expression.toExprOrConstant(right));
    }

    @BetaApi
    public static BooleanExpression equalAny(Expression expression, List<Object> values) {
        return new BooleanFunctionExpression("equal_any", expression, new FunctionExpression("array", (List<? extends Expression>)Expression.toArrayOfExprOrConstant(values.toArray())));
    }

    @BetaApi
    public static BooleanExpression equalAny(Expression expression, Expression arrayExpression) {
        return new BooleanFunctionExpression("equal_any", expression, arrayExpression);
    }

    @BetaApi
    public static BooleanExpression equalAny(String fieldName, List<Object> values) {
        return Expression.equalAny((Expression)Expression.field(fieldName), (Expression)new FunctionExpression("array", (List<? extends Expression>)Expression.toArrayOfExprOrConstant(values.toArray())));
    }

    @BetaApi
    public static BooleanExpression equalAny(String fieldName, Expression arrayExpression) {
        return Expression.equalAny((Expression)Expression.field(fieldName), arrayExpression);
    }

    @BetaApi
    public static BooleanExpression notEqualAny(Expression expression, List<Object> values) {
        return new BooleanFunctionExpression("not_equal_any", expression, new FunctionExpression("array", (List<? extends Expression>)Expression.toArrayOfExprOrConstant(values.toArray())));
    }

    @BetaApi
    public static BooleanExpression notEqualAny(Expression expression, Expression arrayExpression) {
        return new BooleanFunctionExpression("not_equal_any", expression, arrayExpression);
    }

    @BetaApi
    public static BooleanExpression notEqualAny(String fieldName, List<Object> values) {
        return Expression.notEqualAny((Expression)Expression.field(fieldName), (Expression)new FunctionExpression("array", (List<? extends Expression>)Expression.toArrayOfExprOrConstant(values.toArray())));
    }

    @BetaApi
    public static BooleanExpression notEqualAny(String fieldName, Expression arrayExpression) {
        return Expression.notEqualAny((Expression)Expression.field(fieldName), arrayExpression);
    }

    @BetaApi
    public static Expression charLength(Expression string) {
        return new FunctionExpression("char_length", (List<? extends Expression>)ImmutableList.of((Object)string));
    }

    @BetaApi
    public static Expression charLength(String fieldName) {
        return Expression.charLength(Expression.field(fieldName));
    }

    @BetaApi
    public static Expression byteLength(Expression string) {
        return new FunctionExpression("byte_length", (List<? extends Expression>)ImmutableList.of((Object)string));
    }

    @BetaApi
    public static Expression byteLength(String fieldName) {
        return Expression.byteLength(Expression.field(fieldName));
    }

    @BetaApi
    public static Expression length(Expression string) {
        return new FunctionExpression("length", (List<? extends Expression>)ImmutableList.of((Object)string));
    }

    @BetaApi
    public static Expression length(String fieldName) {
        return Expression.byteLength(Expression.field(fieldName));
    }

    @BetaApi
    public static BooleanExpression like(Expression string, Expression pattern) {
        return new BooleanFunctionExpression("like", string, pattern);
    }

    @BetaApi
    public static BooleanExpression like(Expression string, String pattern) {
        return Expression.like(string, Expression.constant(pattern));
    }

    @BetaApi
    public static BooleanExpression like(String fieldName, Expression pattern) {
        return Expression.like((Expression)Expression.field(fieldName), pattern);
    }

    @BetaApi
    public static BooleanExpression like(String fieldName, String pattern) {
        return Expression.like((Expression)Expression.field(fieldName), Expression.constant(pattern));
    }

    @BetaApi
    public static BooleanExpression regexContains(Expression string, Expression pattern) {
        return new BooleanFunctionExpression("regex_contains", string, pattern);
    }

    @BetaApi
    public static BooleanExpression regexContains(Expression string, String pattern) {
        return Expression.regexContains(string, Expression.constant(pattern));
    }

    @BetaApi
    public static BooleanExpression regexContains(String fieldName, Expression pattern) {
        return Expression.regexContains((Expression)Expression.field(fieldName), pattern);
    }

    @BetaApi
    public static BooleanExpression regexContains(String fieldName, String pattern) {
        return Expression.regexContains((Expression)Expression.field(fieldName), Expression.constant(pattern));
    }

    @BetaApi
    public static BooleanExpression regexMatch(Expression string, Expression pattern) {
        return new BooleanFunctionExpression("regex_match", string, pattern);
    }

    @BetaApi
    public static BooleanExpression regexMatch(Expression string, String pattern) {
        return Expression.regexMatch(string, Expression.constant(pattern));
    }

    @BetaApi
    public static BooleanExpression regexMatch(String fieldName, Expression pattern) {
        return Expression.regexMatch((Expression)Expression.field(fieldName), pattern);
    }

    @BetaApi
    public static BooleanExpression regexMatch(String fieldName, String pattern) {
        return Expression.regexMatch((Expression)Expression.field(fieldName), Expression.constant(pattern));
    }

    @BetaApi
    public static BooleanExpression stringContains(Expression string, Expression substring) {
        return new BooleanFunctionExpression("string_contains", string, substring);
    }

    @BetaApi
    public static BooleanExpression stringContains(Expression string, String substring) {
        return Expression.stringContains(string, Expression.constant(substring));
    }

    @BetaApi
    public static BooleanExpression stringContains(String fieldName, Expression substring) {
        return Expression.stringContains((Expression)Expression.field(fieldName), substring);
    }

    @BetaApi
    public static BooleanExpression stringContains(String fieldName, String substring) {
        return Expression.stringContains((Expression)Expression.field(fieldName), Expression.constant(substring));
    }

    @BetaApi
    public static BooleanExpression startsWith(Expression string, Expression prefix) {
        return new BooleanFunctionExpression("starts_with", string, prefix);
    }

    @BetaApi
    public static BooleanExpression startsWith(Expression string, String prefix) {
        return Expression.startsWith(string, Expression.constant(prefix));
    }

    @BetaApi
    public static BooleanExpression startsWith(String fieldName, Expression prefix) {
        return Expression.startsWith((Expression)Expression.field(fieldName), prefix);
    }

    @BetaApi
    public static BooleanExpression startsWith(String fieldName, String prefix) {
        return Expression.startsWith((Expression)Expression.field(fieldName), Expression.constant(prefix));
    }

    @BetaApi
    public static BooleanExpression endsWith(Expression string, Expression suffix) {
        return new BooleanFunctionExpression("ends_with", string, suffix);
    }

    @BetaApi
    public static BooleanExpression endsWith(Expression string, String suffix) {
        return Expression.endsWith(string, Expression.constant(suffix));
    }

    @BetaApi
    public static BooleanExpression endsWith(String fieldName, Expression suffix) {
        return Expression.endsWith((Expression)Expression.field(fieldName), suffix);
    }

    @BetaApi
    public static BooleanExpression endsWith(String fieldName, String suffix) {
        return Expression.endsWith((Expression)Expression.field(fieldName), Expression.constant(suffix));
    }

    @BetaApi
    public static Expression substring(Expression string, Expression index, Expression length) {
        return new FunctionExpression("substring", (List<? extends Expression>)ImmutableList.of((Object)string, (Object)index, (Object)length));
    }

    @BetaApi
    public static Expression substring(String fieldName, int index, int length) {
        return Expression.substring(Expression.field(fieldName), Expression.constant(index), Expression.constant(length));
    }

    @BetaApi
    public static Expression toLower(Expression string) {
        return new FunctionExpression("to_lower", (List<? extends Expression>)ImmutableList.of((Object)string));
    }

    @BetaApi
    public static Expression toLower(String fieldName) {
        return Expression.toLower(Expression.field(fieldName));
    }

    @BetaApi
    public static Expression toUpper(Expression string) {
        return new FunctionExpression("to_upper", (List<? extends Expression>)ImmutableList.of((Object)string));
    }

    @BetaApi
    public static Expression toUpper(String fieldName) {
        return Expression.toUpper(Expression.field(fieldName));
    }

    @BetaApi
    public static Expression trim(Expression string) {
        return new FunctionExpression("trim", (List<? extends Expression>)ImmutableList.of((Object)string));
    }

    @BetaApi
    public static Expression trim(String fieldName) {
        return Expression.trim(Expression.field(fieldName));
    }

    @BetaApi
    public static Expression trimValue(Expression value, String characters) {
        return new FunctionExpression("trim", (List<? extends Expression>)ImmutableList.of((Object)value, (Object)Expression.constant(characters)));
    }

    @BetaApi
    public static Expression trimValue(String fieldName, String characters) {
        return Expression.trimValue((Expression)Expression.field(fieldName), characters);
    }

    @BetaApi
    public static Expression trimValue(Expression value, Expression characters) {
        return new FunctionExpression("trim", (List<? extends Expression>)ImmutableList.of((Object)value, (Object)characters));
    }

    @BetaApi
    public static Expression trimValue(String fieldName, Expression characters) {
        return Expression.trimValue((Expression)Expression.field(fieldName), characters);
    }

    @BetaApi
    public static Expression split(Expression value, Expression delimiter) {
        return new FunctionExpression("split", (List<? extends Expression>)ImmutableList.of((Object)value, (Object)delimiter));
    }

    @BetaApi
    public static Expression split(Expression value, String delimiter) {
        return Expression.split(value, Expression.constant(delimiter));
    }

    @BetaApi
    public static Expression split(String fieldName, Expression delimiter) {
        return Expression.split((Expression)Expression.field(fieldName), delimiter);
    }

    @BetaApi
    public static Expression split(String fieldName, String delimiter) {
        return Expression.split((Expression)Expression.field(fieldName), Expression.constant(delimiter));
    }

    @BetaApi
    public static Expression stringConcat(Expression firstString, Object ... otherStrings) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)firstString);
        builder.addAll(Expression.toArrayOfExprOrConstant(otherStrings));
        return new FunctionExpression("string_concat", (List<? extends Expression>)builder.build());
    }

    @BetaApi
    public static Expression stringConcat(String fieldName, Object ... otherStrings) {
        return Expression.stringConcat(Expression.field(fieldName), otherStrings);
    }

    @BetaApi
    public static Expression concat(Expression first, Object ... others) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)first);
        builder.addAll(Expression.toArrayOfExprOrConstant(others));
        return new FunctionExpression("concat", (List<? extends Expression>)builder.build());
    }

    @BetaApi
    public static Expression concat(String fieldName, Object ... others) {
        return Expression.concat(Expression.field(fieldName), others);
    }

    @BetaApi
    public static Expression map(Map<String, Object> elements) {
        ImmutableList params = (ImmutableList)elements.entrySet().stream().flatMap(e -> Arrays.asList(Expression.constant((String)e.getKey()), Expression.toExprOrConstant(e.getValue())).stream()).collect(ImmutableList.toImmutableList());
        return new FunctionExpression("map", (List<? extends Expression>)params);
    }

    @BetaApi
    public static Expression mapGet(Expression map, Expression key) {
        return new FunctionExpression("map_get", (List<? extends Expression>)ImmutableList.of((Object)map, (Object)key));
    }

    @BetaApi
    public static Expression mapGet(Expression map, String key) {
        return Expression.mapGet(map, Expression.constant(key));
    }

    @BetaApi
    public static Expression mapGet(String fieldName, String key) {
        return Expression.mapGet((Expression)Expression.field(fieldName), Expression.constant(key));
    }

    @BetaApi
    public static Expression mapGet(String fieldName, Expression key) {
        return Expression.mapGet((Expression)Expression.field(fieldName), key);
    }

    @BetaApi
    public static Expression mapMerge(Expression firstMap, Expression secondMap) {
        return Expression.mapMerge(firstMap, secondMap, new Expression[0]);
    }

    @BetaApi
    public static Expression mapMerge(String firstMapFieldName, Expression secondMap) {
        return Expression.mapMerge(Expression.field(firstMapFieldName), secondMap, new Expression[0]);
    }

    @BetaApi
    public static Expression mapMerge(Expression firstMap, Expression secondMap, Expression ... otherMaps) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)firstMap);
        builder.add((Object)secondMap);
        builder.add((Object[])otherMaps);
        return new FunctionExpression("map_merge", (List<? extends Expression>)builder.build());
    }

    @BetaApi
    public static Expression mapMerge(String firstMapFieldName, Expression secondMap, Expression ... otherMaps) {
        return Expression.mapMerge(Expression.field(firstMapFieldName), secondMap, otherMaps);
    }

    @BetaApi
    public static Expression mapRemove(Expression mapExpr, Expression key) {
        return new FunctionExpression("map_remove", (List<? extends Expression>)ImmutableList.of((Object)mapExpr, (Object)key));
    }

    @BetaApi
    public static Expression mapRemove(String mapField, Expression key) {
        return Expression.mapRemove((Expression)Expression.field(mapField), key);
    }

    @BetaApi
    public static Expression mapRemove(Expression mapExpr, String key) {
        return Expression.mapRemove(mapExpr, Expression.constant(key));
    }

    @BetaApi
    public static Expression mapRemove(String mapField, String key) {
        return Expression.mapRemove((Expression)Expression.field(mapField), key);
    }

    @BetaApi
    public static Expression reverse(Expression expr) {
        return new FunctionExpression("reverse", (List<? extends Expression>)ImmutableList.of((Object)expr));
    }

    @BetaApi
    public static Expression reverse(String fieldName) {
        return Expression.reverse(Expression.field(fieldName));
    }

    @BetaApi
    public static Expression array(Object ... elements) {
        return new FunctionExpression("array", (List<? extends Expression>)Expression.toArrayOfExprOrConstant(elements));
    }

    @BetaApi
    public static Expression array(List<Object> elements) {
        return new FunctionExpression("array", (List<? extends Expression>)Expression.toArrayOfExprOrConstant(elements.toArray()));
    }

    @BetaApi
    public static Expression arrayConcat(Expression firstArray, Object ... otherArrays) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)firstArray);
        builder.addAll(Expression.toArrayOfExprOrConstant(otherArrays));
        return new FunctionExpression("array_concat", (List<? extends Expression>)builder.build());
    }

    @BetaApi
    public static Expression arrayConcat(String firstArrayField, Object ... otherArrays) {
        return Expression.arrayConcat(Expression.field(firstArrayField), otherArrays);
    }

    @BetaApi
    public static Expression arrayReverse(Expression array) {
        return new FunctionExpression("array_reverse", (List<? extends Expression>)ImmutableList.of((Object)array));
    }

    @BetaApi
    public static Expression arrayReverse(String arrayFieldName) {
        return Expression.arrayReverse(Expression.field(arrayFieldName));
    }

    @BetaApi
    public static BooleanExpression arrayContains(Expression array, Expression element) {
        return new BooleanFunctionExpression("array_contains", array, element);
    }

    @BetaApi
    public static BooleanExpression arrayContains(String arrayFieldName, Expression element) {
        return Expression.arrayContains((Expression)Expression.field(arrayFieldName), element);
    }

    @BetaApi
    public static BooleanExpression arrayContains(Expression array, Object element) {
        return Expression.arrayContains(array, Expression.toExprOrConstant(element));
    }

    @BetaApi
    public static BooleanExpression arrayContains(String arrayFieldName, Object element) {
        return Expression.arrayContains((Expression)Expression.field(arrayFieldName), Expression.toExprOrConstant(element));
    }

    @BetaApi
    public static BooleanExpression arrayContainsAll(Expression array, List<Object> values) {
        return Expression.arrayContainsAll(array, Expression.array(values));
    }

    @BetaApi
    public static BooleanExpression arrayContainsAll(Expression array, Expression arrayExpression) {
        return new BooleanFunctionExpression("array_contains_all", array, arrayExpression);
    }

    @BetaApi
    public static BooleanExpression arrayContainsAll(String arrayFieldName, List<Object> values) {
        return Expression.arrayContainsAll((Expression)Expression.field(arrayFieldName), Expression.array(values));
    }

    @BetaApi
    public static BooleanExpression arrayContainsAll(String arrayFieldName, Expression arrayExpression) {
        return Expression.arrayContainsAll((Expression)Expression.field(arrayFieldName), arrayExpression);
    }

    @BetaApi
    public static BooleanExpression arrayContainsAny(Expression array, List<Object> values) {
        return new BooleanFunctionExpression("array_contains_any", array, Expression.array(values));
    }

    @BetaApi
    public static BooleanExpression arrayContainsAny(Expression array, Expression arrayExpression) {
        return new BooleanFunctionExpression("array_contains_any", array, arrayExpression);
    }

    @BetaApi
    public static BooleanExpression arrayContainsAny(String arrayFieldName, List<Object> values) {
        return Expression.arrayContainsAny((Expression)Expression.field(arrayFieldName), Expression.array(values));
    }

    @BetaApi
    public static BooleanExpression arrayContainsAny(String arrayFieldName, Expression arrayExpression) {
        return Expression.arrayContainsAny((Expression)Expression.field(arrayFieldName), arrayExpression);
    }

    @BetaApi
    public static Expression arrayLength(Expression array) {
        return new FunctionExpression("array_length", (List<? extends Expression>)ImmutableList.of((Object)array));
    }

    @BetaApi
    public static Expression arrayLength(String arrayFieldName) {
        return Expression.arrayLength(Expression.field(arrayFieldName));
    }

    @BetaApi
    public static Expression arrayGet(Expression array, Expression offset) {
        return new FunctionExpression("array_get", (List<? extends Expression>)ImmutableList.of((Object)array, (Object)offset));
    }

    @BetaApi
    public static Expression arrayGet(Expression array, int offset) {
        return Expression.arrayGet(array, Expression.constant(offset));
    }

    @BetaApi
    public static Expression arrayGet(String arrayFieldName, Expression offset) {
        return Expression.arrayGet((Expression)Expression.field(arrayFieldName), offset);
    }

    @BetaApi
    public static Expression arrayGet(String arrayFieldName, int offset) {
        return Expression.arrayGet((Expression)Expression.field(arrayFieldName), Expression.constant(offset));
    }

    @BetaApi
    public static Expression arraySum(Expression array) {
        return new FunctionExpression("sum", (List<? extends Expression>)ImmutableList.of((Object)array));
    }

    @BetaApi
    public static Expression arraySum(String arrayFieldName) {
        return Expression.arraySum(Expression.field(arrayFieldName));
    }

    @BetaApi
    public static Expression cosineDistance(Expression vector1, Expression vector2) {
        return new FunctionExpression("cosine_distance", (List<? extends Expression>)ImmutableList.of((Object)vector1, (Object)vector2));
    }

    @BetaApi
    public static Expression cosineDistance(Expression vector1, double[] vector2) {
        return Expression.cosineDistance(vector1, Expression.constant(FieldValue.vector(vector2)));
    }

    @BetaApi
    public static Expression cosineDistance(String vectorFieldName, Expression vector) {
        return Expression.cosineDistance((Expression)Expression.field(vectorFieldName), vector);
    }

    @BetaApi
    public static Expression cosineDistance(String vectorFieldName, double[] vector) {
        return Expression.cosineDistance((Expression)Expression.field(vectorFieldName), Expression.constant(FieldValue.vector(vector)));
    }

    @BetaApi
    public static Expression dotProduct(Expression vector1, Expression vector2) {
        return new FunctionExpression("dot_product", (List<? extends Expression>)ImmutableList.of((Object)vector1, (Object)vector2));
    }

    @BetaApi
    public static Expression dotProduct(Expression vector1, double[] vector2) {
        return Expression.dotProduct(vector1, Expression.constant(FieldValue.vector(vector2)));
    }

    @BetaApi
    public static Expression dotProduct(String vectorFieldName, Expression vector) {
        return Expression.dotProduct((Expression)Expression.field(vectorFieldName), vector);
    }

    @BetaApi
    public static Expression dotProduct(String vectorFieldName, double[] vector) {
        return Expression.dotProduct((Expression)Expression.field(vectorFieldName), Expression.constant(FieldValue.vector(vector)));
    }

    @BetaApi
    public static Expression euclideanDistance(Expression vector1, Expression vector2) {
        return new FunctionExpression("euclidean_distance", (List<? extends Expression>)ImmutableList.of((Object)vector1, (Object)vector2));
    }

    @BetaApi
    public static Expression euclideanDistance(Expression vector1, double[] vector2) {
        return Expression.euclideanDistance(vector1, Expression.constant(FieldValue.vector(vector2)));
    }

    @BetaApi
    public static Expression euclideanDistance(String vectorFieldName, Expression vector) {
        return Expression.euclideanDistance((Expression)Expression.field(vectorFieldName), vector);
    }

    @BetaApi
    public static Expression euclideanDistance(String vectorFieldName, double[] vector) {
        return Expression.euclideanDistance((Expression)Expression.field(vectorFieldName), Expression.constant(FieldValue.vector(vector)));
    }

    @BetaApi
    public static Expression vectorLength(Expression vectorExpression) {
        return new FunctionExpression("vector_length", (List<? extends Expression>)ImmutableList.of((Object)vectorExpression));
    }

    @BetaApi
    public static Expression vectorLength(String fieldName) {
        return Expression.vectorLength(Expression.field(fieldName));
    }

    @BetaApi
    public static Expression unixMicrosToTimestamp(Expression expr) {
        return new FunctionExpression("unix_micros_to_timestamp", (List<? extends Expression>)ImmutableList.of((Object)expr));
    }

    @BetaApi
    public static Expression unixMicrosToTimestamp(String fieldName) {
        return Expression.unixMicrosToTimestamp(Expression.field(fieldName));
    }

    @BetaApi
    public static Expression timestampToUnixMicros(Expression expr) {
        return new FunctionExpression("timestamp_to_unix_micros", (List<? extends Expression>)ImmutableList.of((Object)expr));
    }

    @BetaApi
    public static Expression timestampToUnixMicros(String fieldName) {
        return Expression.timestampToUnixMicros(Expression.field(fieldName));
    }

    @BetaApi
    public static Expression unixMillisToTimestamp(Expression expr) {
        return new FunctionExpression("unix_millis_to_timestamp", (List<? extends Expression>)ImmutableList.of((Object)expr));
    }

    @BetaApi
    public static Expression unixMillisToTimestamp(String fieldName) {
        return Expression.unixMillisToTimestamp(Expression.field(fieldName));
    }

    @BetaApi
    public static Expression timestampToUnixMillis(Expression expr) {
        return new FunctionExpression("timestamp_to_unix_millis", (List<? extends Expression>)ImmutableList.of((Object)expr));
    }

    @BetaApi
    public static Expression timestampToUnixMillis(String fieldName) {
        return Expression.timestampToUnixMillis(Expression.field(fieldName));
    }

    @BetaApi
    public static Expression unixSecondsToTimestamp(Expression expr) {
        return new FunctionExpression("unix_seconds_to_timestamp", (List<? extends Expression>)ImmutableList.of((Object)expr));
    }

    @BetaApi
    public static Expression unixSecondsToTimestamp(String fieldName) {
        return Expression.unixSecondsToTimestamp(Expression.field(fieldName));
    }

    @BetaApi
    public static Expression timestampToUnixSeconds(Expression expr) {
        return new FunctionExpression("timestamp_to_unix_seconds", (List<? extends Expression>)ImmutableList.of((Object)expr));
    }

    @BetaApi
    public static Expression timestampToUnixSeconds(String fieldName) {
        return Expression.timestampToUnixSeconds(Expression.field(fieldName));
    }

    @BetaApi
    public static Expression timestampAdd(Expression timestamp, Expression unit, Expression amount) {
        return new FunctionExpression("timestamp_add", (List<? extends Expression>)ImmutableList.of((Object)timestamp, (Object)unit, (Object)amount));
    }

    @BetaApi
    public static Expression timestampAdd(Expression timestamp, String unit, long amount) {
        return Expression.timestampAdd(timestamp, Expression.constant(unit), Expression.constant(amount));
    }

    @BetaApi
    public static Expression timestampAdd(String fieldName, Expression unit, Expression amount) {
        return Expression.timestampAdd((Expression)Expression.field(fieldName), unit, amount);
    }

    @BetaApi
    public static Expression timestampAdd(String fieldName, String unit, long amount) {
        return Expression.timestampAdd((Expression)Expression.field(fieldName), Expression.constant(unit), Expression.constant(amount));
    }

    @BetaApi
    public static Expression timestampSubtract(Expression timestamp, Expression unit, Expression amount) {
        return new FunctionExpression("timestamp_subtract", (List<? extends Expression>)ImmutableList.of((Object)timestamp, (Object)unit, (Object)amount));
    }

    @BetaApi
    public static Expression timestampSubtract(Expression timestamp, String unit, long amount) {
        return Expression.timestampSubtract(timestamp, Expression.constant(unit), Expression.constant(amount));
    }

    @BetaApi
    public static Expression timestampSubtract(String fieldName, Expression unit, Expression amount) {
        return Expression.timestampSubtract((Expression)Expression.field(fieldName), unit, amount);
    }

    @BetaApi
    public static Expression timestampSubtract(String fieldName, String unit, long amount) {
        return Expression.timestampSubtract((Expression)Expression.field(fieldName), Expression.constant(unit), Expression.constant(amount));
    }

    @BetaApi
    public static Expression timestampTruncate(Expression timestamp, String granularity) {
        return new FunctionExpression("timestamp_trunc", (List<? extends Expression>)ImmutableList.of((Object)timestamp, (Object)Expression.constant(granularity)));
    }

    @BetaApi
    public static Expression timestampTruncate(Expression timestamp, Expression granularity) {
        return new FunctionExpression("timestamp_trunc", (List<? extends Expression>)ImmutableList.of((Object)timestamp, (Object)granularity));
    }

    @BetaApi
    public static Expression timestampTruncate(String fieldName, String granularity) {
        return Expression.timestampTruncate((Expression)Expression.field(fieldName), Expression.constant(granularity));
    }

    @BetaApi
    public static Expression timestampTruncate(String fieldName, Expression granularity) {
        return Expression.timestampTruncate((Expression)Expression.field(fieldName), granularity);
    }

    @BetaApi
    public static Expression timestampTruncate(Expression timestamp, String granularity, String timezone) {
        return new FunctionExpression("timestamp_trunc", (List<? extends Expression>)ImmutableList.of((Object)timestamp, (Object)Expression.constant(granularity), (Object)Expression.constant(timezone)));
    }

    @BetaApi
    public static Expression timestampTruncate(Expression timestamp, Expression granularity, String timezone) {
        return new FunctionExpression("timestamp_trunc", (List<? extends Expression>)ImmutableList.of((Object)timestamp, (Object)granularity, (Object)Expression.constant(timezone)));
    }

    @BetaApi
    public static Expression timestampTruncate(String fieldName, String granularity, String timezone) {
        return Expression.timestampTruncate((Expression)Expression.field(fieldName), Expression.constant(granularity), timezone);
    }

    @BetaApi
    public static Expression timestampTruncate(String fieldName, Expression granularity, String timezone) {
        return Expression.timestampTruncate((Expression)Expression.field(fieldName), granularity, timezone);
    }

    @BetaApi
    public static Expression conditional(BooleanExpression condition, Expression thenExpr, Expression elseExpr) {
        return new FunctionExpression("conditional", (List<? extends Expression>)ImmutableList.of((Object)condition, (Object)thenExpr, (Object)elseExpr));
    }

    @BetaApi
    public static Expression conditional(BooleanExpression condition, Object thenValue, Object elseValue) {
        return Expression.conditional(condition, Expression.toExprOrConstant(thenValue), Expression.toExprOrConstant(elseValue));
    }

    @BetaApi
    public static Expression ifError(Expression tryExpr, Expression catchExpr) {
        return new FunctionExpression("if_error", (List<? extends Expression>)ImmutableList.of((Object)tryExpr, (Object)catchExpr));
    }

    @BetaApi
    public static BooleanExpression ifError(BooleanExpression tryExpr, BooleanExpression catchExpr) {
        return new BooleanFunctionExpression("if_error", tryExpr, catchExpr);
    }

    @BetaApi
    public static Expression ifError(Expression tryExpr, Object catchValue) {
        return Expression.ifError(tryExpr, Expression.toExprOrConstant(catchValue));
    }

    @BetaApi
    public static BooleanExpression isError(Expression expr) {
        return new BooleanFunctionExpression("is_error", expr);
    }

    @BetaApi
    public static Expression documentId(Expression documentPath) {
        return new FunctionExpression("document_id", (List<? extends Expression>)ImmutableList.of((Object)documentPath));
    }

    @BetaApi
    public static Expression documentId(String documentPath) {
        return Expression.documentId(Expression.constant(documentPath));
    }

    @BetaApi
    public static Expression documentId(DocumentReference docRef) {
        return Expression.documentId(Expression.constant(docRef));
    }

    @BetaApi
    public static Expression collectionId(Expression path) {
        return new FunctionExpression("collection_id", (List<? extends Expression>)ImmutableList.of((Object)path));
    }

    @BetaApi
    public static Expression collectionId(String pathFieldName) {
        return Expression.collectionId(Expression.field(pathFieldName));
    }

    @BetaApi
    public static BooleanExpression exists(Expression value) {
        return new BooleanFunctionExpression("exists", value);
    }

    @BetaApi
    public static BooleanExpression exists(String fieldName) {
        return Expression.exists(Expression.field(fieldName));
    }

    @BetaApi
    public static BooleanExpression isAbsent(Expression value) {
        return new BooleanFunctionExpression("is_absent", value);
    }

    @BetaApi
    public static BooleanExpression isAbsent(String fieldName) {
        return Expression.isAbsent(Expression.field(fieldName));
    }

    @BetaApi
    static BooleanExpression isNaN(Expression value) {
        return new BooleanFunctionExpression("is_nan", value);
    }

    @BetaApi
    static BooleanExpression isNaN(String fieldName) {
        return Expression.isNaN(Expression.field(fieldName));
    }

    @BetaApi
    static BooleanExpression isNull(Expression value) {
        return new BooleanFunctionExpression("is_null", value);
    }

    @BetaApi
    static BooleanExpression isNull(String fieldName) {
        return Expression.isNull(Expression.field(fieldName));
    }

    @BetaApi
    static BooleanExpression isNotNull(Expression value) {
        return new BooleanFunctionExpression("is_not_null", value);
    }

    @BetaApi
    static BooleanExpression isNotNull(String fieldName) {
        return Expression.isNotNull(Expression.field(fieldName));
    }

    @BetaApi
    public static Expression type(Expression expr) {
        return new FunctionExpression("type", (List<? extends Expression>)ImmutableList.of((Object)expr));
    }

    @BetaApi
    public static Expression type(String fieldName) {
        return Expression.type(Expression.field(fieldName));
    }

    @BetaApi
    public static Expression round(Expression numericExpr) {
        return new FunctionExpression("round", (List<? extends Expression>)ImmutableList.of((Object)numericExpr));
    }

    @BetaApi
    public static Expression round(String numericField) {
        return Expression.round(Expression.field(numericField));
    }

    @BetaApi
    public static Expression roundToPrecision(Expression numericExpr, int decimalPlace) {
        return new FunctionExpression("round", (List<? extends Expression>)ImmutableList.of((Object)numericExpr, (Object)Expression.constant(decimalPlace)));
    }

    @BetaApi
    public static Expression roundToPrecision(String numericField, int decimalPlace) {
        return Expression.roundToPrecision((Expression)Expression.field(numericField), decimalPlace);
    }

    @BetaApi
    public static Expression roundToPrecision(Expression numericExpr, Expression decimalPlace) {
        return new FunctionExpression("round", (List<? extends Expression>)ImmutableList.of((Object)numericExpr, (Object)decimalPlace));
    }

    @BetaApi
    public static Expression roundToPrecision(String numericField, Expression decimalPlace) {
        return Expression.roundToPrecision((Expression)Expression.field(numericField), decimalPlace);
    }

    @BetaApi
    public static Expression ceil(Expression numericExpr) {
        return new FunctionExpression("ceil", (List<? extends Expression>)ImmutableList.of((Object)numericExpr));
    }

    @BetaApi
    public static Expression ceil(String numericField) {
        return Expression.ceil(Expression.field(numericField));
    }

    @BetaApi
    public static Expression floor(Expression numericExpr) {
        return new FunctionExpression("floor", (List<? extends Expression>)ImmutableList.of((Object)numericExpr));
    }

    @BetaApi
    public static Expression floor(String numericField) {
        return Expression.floor(Expression.field(numericField));
    }

    @BetaApi
    public static Expression pow(Expression numericExpr, Number exponent) {
        return new FunctionExpression("pow", (List<? extends Expression>)ImmutableList.of((Object)numericExpr, (Object)Expression.constant(exponent)));
    }

    @BetaApi
    public static Expression pow(String numericField, Number exponent) {
        return Expression.pow((Expression)Expression.field(numericField), exponent);
    }

    @BetaApi
    public static Expression pow(Expression numericExpr, Expression exponent) {
        return new FunctionExpression("pow", (List<? extends Expression>)ImmutableList.of((Object)numericExpr, (Object)exponent));
    }

    @BetaApi
    public static Expression pow(String numericField, Expression exponent) {
        return Expression.pow((Expression)Expression.field(numericField), exponent);
    }

    @BetaApi
    public static Expression abs(Expression numericExpr) {
        return new FunctionExpression("abs", (List<? extends Expression>)ImmutableList.of((Object)numericExpr));
    }

    @BetaApi
    public static Expression abs(String numericField) {
        return Expression.abs(Expression.field(numericField));
    }

    @BetaApi
    public static Expression exp(Expression numericExpr) {
        return new FunctionExpression("exp", (List<? extends Expression>)ImmutableList.of((Object)numericExpr));
    }

    @BetaApi
    public static Expression exp(String numericField) {
        return Expression.exp(Expression.field(numericField));
    }

    @BetaApi
    public static Expression ln(Expression numericExpr) {
        return new FunctionExpression("ln", (List<? extends Expression>)ImmutableList.of((Object)numericExpr));
    }

    @BetaApi
    public static Expression ln(String numericField) {
        return Expression.ln(Expression.field(numericField));
    }

    @BetaApi
    public static Expression log(Expression numericExpr, Number base) {
        return new FunctionExpression("log", (List<? extends Expression>)ImmutableList.of((Object)numericExpr, (Object)Expression.constant(base)));
    }

    @BetaApi
    public static Expression log(String numericField, Number base) {
        return Expression.log((Expression)Expression.field(numericField), base);
    }

    @BetaApi
    public static Expression log(Expression numericExpr, Expression base) {
        return new FunctionExpression("log", (List<? extends Expression>)ImmutableList.of((Object)numericExpr, (Object)base));
    }

    @BetaApi
    public static Expression log(String numericField, Expression base) {
        return Expression.log((Expression)Expression.field(numericField), base);
    }

    @BetaApi
    public static Expression log10(Expression numericExpr) {
        return new FunctionExpression("log10", (List<? extends Expression>)ImmutableList.of((Object)numericExpr));
    }

    @BetaApi
    public static Expression log10(String numericField) {
        return Expression.log10(Expression.field(numericField));
    }

    @BetaApi
    public static Expression sqrt(Expression numericExpr) {
        return new FunctionExpression("sqrt", (List<? extends Expression>)ImmutableList.of((Object)numericExpr));
    }

    @BetaApi
    public static Expression sqrt(String numericField) {
        return Expression.sqrt(Expression.field(numericField));
    }

    @BetaApi
    public static BooleanExpression isNotNaN(Expression expr) {
        return new BooleanFunctionExpression("is_not_nan", expr);
    }

    @BetaApi
    public static BooleanExpression isNotNaN(String fieldName) {
        return Expression.isNotNaN(Expression.field(fieldName));
    }

    @BetaApi
    public static Expression logicalMaximum(Expression expr, Object ... others) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)expr);
        builder.addAll(Expression.toArrayOfExprOrConstant(others));
        return new FunctionExpression("maximum", (List<? extends Expression>)builder.build());
    }

    @BetaApi
    public static Expression logicalMaximum(String fieldName, Object ... others) {
        return Expression.logicalMaximum(Expression.field(fieldName), others);
    }

    @BetaApi
    public static Expression logicalMinimum(Expression expr, Object ... others) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)expr);
        builder.addAll(Expression.toArrayOfExprOrConstant(others));
        return new FunctionExpression("minimum", (List<? extends Expression>)builder.build());
    }

    @BetaApi
    public static Expression logicalMinimum(String fieldName, Object ... others) {
        return Expression.logicalMinimum(Expression.field(fieldName), others);
    }

    @BetaApi
    public Expression concat(Object ... others) {
        return Expression.concat(this, others);
    }

    @BetaApi
    public Expression ifAbsent(Object elseValue) {
        return Expression.ifAbsent(this, elseValue);
    }

    @BetaApi
    public Expression join(String delimiter) {
        return Expression.join(this, delimiter);
    }

    @BetaApi
    public Expression join(Expression delimiter) {
        return Expression.join(this, delimiter);
    }

    @BetaApi
    public final BooleanExpression isNotNaN() {
        return Expression.isNotNaN(this);
    }

    @BetaApi
    public final Expression logicalMaximum(Object ... others) {
        return Expression.logicalMaximum(this, others);
    }

    @BetaApi
    public final Expression logicalMinimum(Object ... others) {
        return Expression.logicalMinimum(this, others);
    }

    @BetaApi
    public final Expression round() {
        return Expression.round(this);
    }

    @BetaApi
    public final Expression roundToPrecision(int decimalPlace) {
        return Expression.roundToPrecision(this, decimalPlace);
    }

    @BetaApi
    public final Expression roundToPrecision(Expression decimalPlace) {
        return Expression.roundToPrecision(this, decimalPlace);
    }

    @BetaApi
    public final Expression ceil() {
        return Expression.ceil(this);
    }

    @BetaApi
    public final Expression floor() {
        return Expression.floor(this);
    }

    @BetaApi
    public final Expression pow(Number exponent) {
        return Expression.pow(this, exponent);
    }

    @BetaApi
    public final Expression pow(Expression exponent) {
        return Expression.pow(this, exponent);
    }

    @BetaApi
    public final Expression abs() {
        return Expression.abs(this);
    }

    @BetaApi
    public final Expression exp() {
        return Expression.exp(this);
    }

    @BetaApi
    public final Expression ln() {
        return Expression.ln(this);
    }

    @BetaApi
    public Expression log10() {
        return Expression.log10(this);
    }

    @BetaApi
    public Expression arraySum() {
        return Expression.arraySum(this);
    }

    @BetaApi
    public final Expression sqrt() {
        return Expression.sqrt(this);
    }

    @BetaApi
    public final Expression add(Object other) {
        return Expression.add(this, Expression.toExprOrConstant(other));
    }

    @BetaApi
    public final Expression subtract(Object other) {
        return Expression.subtract(this, Expression.toExprOrConstant(other));
    }

    @BetaApi
    public final Expression multiply(Object other) {
        return Expression.multiply(this, Expression.toExprOrConstant(other));
    }

    @BetaApi
    public final Expression divide(Object other) {
        return Expression.divide(this, Expression.toExprOrConstant(other));
    }

    @BetaApi
    public final Expression mod(Object other) {
        return Expression.mod(this, Expression.toExprOrConstant(other));
    }

    @BetaApi
    public final BooleanExpression equal(Object other) {
        return Expression.equal(this, Expression.toExprOrConstant(other));
    }

    @BetaApi
    public final BooleanExpression notEqual(Object other) {
        return Expression.notEqual(this, Expression.toExprOrConstant(other));
    }

    @BetaApi
    public final BooleanExpression greaterThan(Object other) {
        return Expression.greaterThan(this, Expression.toExprOrConstant(other));
    }

    @BetaApi
    public final BooleanExpression greaterThanOrEqual(Object other) {
        return Expression.greaterThanOrEqual(this, Expression.toExprOrConstant(other));
    }

    @BetaApi
    public final BooleanExpression lessThan(Object other) {
        return Expression.lessThan(this, Expression.toExprOrConstant(other));
    }

    @BetaApi
    public final BooleanExpression lessThanOrEqual(Object other) {
        return Expression.lessThanOrEqual(this, Expression.toExprOrConstant(other));
    }

    @BetaApi
    public final BooleanExpression equalAny(List<Object> other) {
        return Expression.equalAny(this, other);
    }

    @BetaApi
    public final BooleanExpression notEqualAny(List<Object> other) {
        return Expression.notEqualAny(this, other);
    }

    @BetaApi
    public final Expression charLength() {
        return Expression.charLength(this);
    }

    @BetaApi
    public final Expression byteLength() {
        return Expression.byteLength(this);
    }

    @BetaApi
    public final Expression length() {
        return Expression.length(this);
    }

    @BetaApi
    public final BooleanExpression like(Object pattern) {
        return Expression.like(this, Expression.toExprOrConstant(pattern));
    }

    @BetaApi
    public final BooleanExpression regexContains(Object pattern) {
        return Expression.regexContains(this, Expression.toExprOrConstant(pattern));
    }

    @BetaApi
    public final BooleanExpression regexMatch(Object pattern) {
        return Expression.regexMatch(this, Expression.toExprOrConstant(pattern));
    }

    @BetaApi
    public final BooleanExpression stringContains(Object substring) {
        return Expression.stringContains(this, Expression.toExprOrConstant(substring));
    }

    @BetaApi
    public final BooleanExpression startsWith(Object prefix) {
        return Expression.startsWith(this, Expression.toExprOrConstant(prefix));
    }

    @BetaApi
    public final BooleanExpression endsWith(Object suffix) {
        return Expression.endsWith(this, Expression.toExprOrConstant(suffix));
    }

    @BetaApi
    public final Expression substring(Object index, Object length) {
        return Expression.substring(this, Expression.toExprOrConstant(index), Expression.toExprOrConstant(length));
    }

    @BetaApi
    public final Expression toLower() {
        return Expression.toLower(this);
    }

    @BetaApi
    public final Expression toUpper() {
        return Expression.toUpper(this);
    }

    @BetaApi
    public final Expression trim() {
        return Expression.trim(this);
    }

    @BetaApi
    public Expression trimValue(String characters) {
        return Expression.trimValue(this, characters);
    }

    @BetaApi
    public Expression trimValue(Expression characters) {
        return Expression.trimValue(this, characters);
    }

    @BetaApi
    public Expression split(Expression delimiter) {
        return Expression.split(this, delimiter);
    }

    @BetaApi
    public Expression split(String delimiter) {
        return Expression.split(this, delimiter);
    }

    @BetaApi
    public final Expression stringConcat(String ... others) {
        return Expression.stringConcat(this, (Object[])others);
    }

    @BetaApi
    public final Expression stringConcat(Expression ... others) {
        return Expression.stringConcat(this, (Object[])others);
    }

    @BetaApi
    public final Expression mapGet(Object key) {
        return Expression.mapGet(this, Expression.toExprOrConstant(key));
    }

    @BetaApi
    public final BooleanExpression isAbsent() {
        return Expression.isAbsent(this);
    }

    @BetaApi
    public final BooleanExpression isNaN() {
        return Expression.isNaN(this);
    }

    @BetaApi
    public final BooleanExpression isNull() {
        return Expression.isNull(this);
    }

    @BetaApi
    public final BooleanExpression isNotNull() {
        return Expression.isNotNull(this);
    }

    @BetaApi
    public final AggregateFunction sum() {
        return AggregateFunction.sum(this);
    }

    @BetaApi
    public final AggregateFunction average() {
        return AggregateFunction.average(this);
    }

    @BetaApi
    public final AggregateFunction minimum() {
        return AggregateFunction.minimum(this);
    }

    @BetaApi
    public final AggregateFunction maximum() {
        return AggregateFunction.maximum(this);
    }

    @BetaApi
    public final AggregateFunction count() {
        return AggregateFunction.count(this);
    }

    @BetaApi
    public final AggregateFunction countDistinct() {
        return AggregateFunction.countDistinct(this);
    }

    @BetaApi
    public final Ordering ascending() {
        return Ordering.ascending(this);
    }

    @BetaApi
    public final Ordering descending() {
        return Ordering.descending(this);
    }

    @BetaApi
    public Selectable as(String alias) {
        return new AliasedExpression(this, alias);
    }

    @BetaApi
    public final Expression mapMerge(Expression secondMap, Expression ... otherMaps) {
        return Expression.mapMerge(this, secondMap, otherMaps);
    }

    @BetaApi
    public final Expression mapRemove(Expression key) {
        return Expression.mapRemove(this, key);
    }

    @BetaApi
    public final Expression mapRemove(String key) {
        return Expression.mapRemove(this, key);
    }

    @BetaApi
    public final Expression reverse() {
        return Expression.reverse(this);
    }

    @BetaApi
    public final Expression arrayConcat(Expression ... otherArrays) {
        return Expression.arrayConcat(this, (Object[])otherArrays);
    }

    @BetaApi
    public final Expression arrayReverse() {
        return Expression.arrayReverse(this);
    }

    @BetaApi
    public final BooleanExpression arrayContains(Object element) {
        return Expression.arrayContains(this, element);
    }

    @BetaApi
    public final BooleanExpression arrayContainsAll(List<Object> values) {
        return Expression.arrayContainsAll(this, values);
    }

    @BetaApi
    public final BooleanExpression arrayContainsAll(Expression arrayExpression) {
        return Expression.arrayContainsAll(this, arrayExpression);
    }

    @BetaApi
    public final BooleanExpression arrayContainsAny(List<Object> values) {
        return Expression.arrayContainsAny(this, values);
    }

    @BetaApi
    public final BooleanExpression arrayContainsAny(Expression arrayExpression) {
        return Expression.arrayContainsAny(this, arrayExpression);
    }

    @BetaApi
    public final Expression arrayLength() {
        return Expression.arrayLength(this);
    }

    @BetaApi
    public final Expression arrayGet(Expression offset) {
        return Expression.arrayGet(this, offset);
    }

    @BetaApi
    public final Expression arrayGet(int offset) {
        return Expression.arrayGet(this, offset);
    }

    @BetaApi
    public final Expression cosineDistance(Expression vector) {
        return Expression.cosineDistance(this, vector);
    }

    @BetaApi
    public final Expression cosineDistance(double[] vector) {
        return Expression.cosineDistance(this, vector);
    }

    @BetaApi
    public final Expression dotProduct(Expression vector) {
        return Expression.dotProduct(this, vector);
    }

    @BetaApi
    public final Expression dotProduct(double[] vector) {
        return Expression.dotProduct(this, vector);
    }

    @BetaApi
    public final Expression euclideanDistance(Expression vector) {
        return Expression.euclideanDistance(this, vector);
    }

    @BetaApi
    public final Expression euclideanDistance(double[] vector) {
        return Expression.euclideanDistance(this, vector);
    }

    @BetaApi
    public final Expression vectorLength() {
        return Expression.vectorLength(this);
    }

    @BetaApi
    public final Expression unixMicrosToTimestamp() {
        return Expression.unixMicrosToTimestamp(this);
    }

    @BetaApi
    public final Expression timestampToUnixMicros() {
        return Expression.timestampToUnixMicros(this);
    }

    @BetaApi
    public final Expression unixMillisToTimestamp() {
        return Expression.unixMillisToTimestamp(this);
    }

    @BetaApi
    public final Expression timestampToUnixMillis() {
        return Expression.timestampToUnixMillis(this);
    }

    @BetaApi
    public final Expression unixSecondsToTimestamp() {
        return Expression.unixSecondsToTimestamp(this);
    }

    @BetaApi
    public final Expression timestampToUnixSeconds() {
        return Expression.timestampToUnixSeconds(this);
    }

    @BetaApi
    public final Expression timestampAdd(Expression unit, Expression amount) {
        return Expression.timestampAdd(this, unit, amount);
    }

    @BetaApi
    public final Expression timestampAdd(String unit, long amount) {
        return Expression.timestampAdd(this, unit, amount);
    }

    @BetaApi
    public final Expression timestampSubtract(Expression unit, Expression amount) {
        return Expression.timestampSubtract(this, unit, amount);
    }

    @BetaApi
    public final Expression timestampSubtract(String unit, long amount) {
        return Expression.timestampSubtract(this, unit, amount);
    }

    @BetaApi
    public final Expression timestampTruncate(String granularity) {
        return Expression.timestampTruncate(this, granularity);
    }

    @BetaApi
    public final Expression timestampTruncate(Expression granularity) {
        return Expression.timestampTruncate(this, granularity);
    }

    @BetaApi
    public final BooleanExpression exists() {
        return Expression.exists(this);
    }

    @BetaApi
    public final Expression ifError(Expression catchExpr) {
        return Expression.ifError(this, catchExpr);
    }

    @BetaApi
    public final Expression ifError(Object catchValue) {
        return Expression.ifError(this, catchValue);
    }

    @BetaApi
    public final BooleanExpression isError() {
        return Expression.isError(this);
    }

    @BetaApi
    public final Expression documentId() {
        return Expression.documentId(this);
    }

    @BetaApi
    public final Expression collectionId() {
        return Expression.collectionId(this);
    }

    @BetaApi
    public final Expression type() {
        return Expression.type(this);
    }
}

