/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.recording;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventType;
import org.graalvm.visualvm.jfr.model.JFREventTypeVisitor;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;

abstract class RecordingNode
extends CCTNode {
    private static final RecordingNode[] NO_NODES = new RecordingNode[0];
    private final RecordingNode parent;
    private final List<RecordingNode> children;
    final String name;
    final Icon icon;
    long time = Long.MIN_VALUE;
    String setting;
    String value;
    String thread;

    RecordingNode(String name, Icon icon, RecordingNode parent, List<RecordingNode> children) {
        this.parent = parent;
        this.children = children;
        this.name = name;
        this.icon = icon;
    }

    RecordingNode getChild(String name) {
        if (this.children != null) {
            for (RecordingNode child : this.children) {
                if (!Objects.equals(name, child.name)) continue;
                return child;
            }
        }
        return null;
    }

    public RecordingNode getChild(int index) {
        return this.children == null ? null : this.children.get(index);
    }

    public RecordingNode[] getChildren() {
        return this.children == null ? NO_NODES : this.children.toArray(NO_NODES);
    }

    public int getIndexOfChild(Object child) {
        return this.children == null ? -1 : this.children.indexOf(child);
    }

    public int getNChildren() {
        return this.children == null ? 0 : this.children.size();
    }

    public boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }

    public RecordingNode getParent() {
        return this.parent;
    }

    protected void addChild(RecordingNode child) {
        if (this.children != null) {
            this.children.add(child);
        }
    }

    protected void removeAllChildren() {
        if (this.children != null) {
            this.children.clear();
        }
    }

    public String toString() {
        return this.name;
    }

    static class Root
    extends RecordingNode
    implements JFREventVisitor,
    JFREventTypeVisitor {
        private Map<Long, String> types;
        private long settingID = 0L;
        private Boolean typeMode;
        private Boolean threadMode;

        Root(String name) {
            this();
            Event e = new Event(name, this);
            this.addChild(e);
        }

        Root() {
            super(null, null, null, new ArrayList<RecordingNode>());
        }

        void visitEventTypes() {
        }

        long toRelativeNanos(Instant time) {
            return Long.MIN_VALUE;
        }

        @Override
        public void initTypes() {
            this.types = new HashMap<Long, String>();
        }

        @Override
        public boolean visitType(String typeName, JFREventType type) {
            this.types.put(type.getId(), type.getDisplayName());
            return false;
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.ActiveSetting".equals(typeName)) {
                try {
                    String eventName = this.getTypeName(event);
                    RecordingNode eventNode = this.getChild(eventName);
                    if (eventNode == null) {
                        eventNode = new Event(eventName, this);
                        this.addChild(eventNode);
                    }
                    String settingName = event.getString("name");
                    String settingValue = event.getString("value");
                    String threadName = this.getThreadName(event);
                    Setting settingNode = new Setting(this.settingID++, settingName, settingValue, threadName, this.toRelativeNanos(event.getInstant("eventTime")), eventNode);
                    eventNode.addChild(settingNode);
                }
                catch (JFRPropertyNotAvailableException e) {
                    System.err.println(">>> XX " + e + " -- " + event);
                }
            }
            return false;
        }

        @Override
        public void done() {
            if (this.types != null) {
                this.types.clear();
                this.types = null;
            }
        }

        private String getTypeName(JFREvent event) throws JFRPropertyNotAvailableException {
            if (Boolean.TRUE.equals(this.typeMode)) {
                return this.getTypeName(event.getLong("id"));
            }
            if (Boolean.FALSE.equals(this.typeMode)) {
                return event.getValue("settingFor").toString();
            }
            try {
                String eventName = this.getTypeName(event.getLong("id"));
                this.typeMode = Boolean.TRUE;
                return eventName;
            }
            catch (JFRPropertyNotAvailableException e) {
                String eventName = event.getValue("settingFor").toString();
                this.typeMode = Boolean.FALSE;
                return eventName;
            }
        }

        private String getTypeName(long typeID) {
            if (this.types == null) {
                this.visitEventTypes();
            }
            return this.types.get(typeID);
        }

        private String getThreadName(JFREvent event) throws JFRPropertyNotAvailableException {
            if (Boolean.TRUE.equals(this.threadMode)) {
                return event.getThread("eventThread").getName();
            }
            if (Boolean.FALSE.equals(this.threadMode)) {
                return "-";
            }
            try {
                String eventName = event.getThread("eventThread").getName();
                this.threadMode = Boolean.TRUE;
                return eventName;
            }
            catch (JFRPropertyNotAvailableException e) {
                this.threadMode = Boolean.FALSE;
                return "-";
            }
        }

        public int hashCode() {
            return 37;
        }

        public boolean equals(Object o) {
            return o instanceof Root;
        }
    }

    static final class Setting
    extends RecordingNode {
        private final long id;

        Setting(long id, String name, String value, String thread, long time, RecordingNode parent) {
            super(name, null, parent, null);
            this.id = id;
            this.value = value;
            this.thread = thread;
            this.time = time;
        }

        public int hashCode() {
            return Long.hashCode(this.id);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Setting)) {
                return false;
            }
            return this.id == ((Setting)((Object)o)).id;
        }
    }

    static final class Event
    extends RecordingNode {
        Event(String name, RecordingNode parent) {
            super(name, null, parent, new ArrayList<RecordingNode>());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Event)) {
                return false;
            }
            return Objects.equals(this.name, ((Event)((Object)o)).name);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

