/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.datasource;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.core.datasupport.Utils;

public final class Storage {
    private static final String VISUALVM_TMP_DIR = System.getProperty("visualvm.tmpdir");
    private static final String TEMPORARY_STORAGE_DIRNAME = "visualvm.dat";
    private static final String TEMPORARY_STORAGE_DIRNAME_EX = "visualvm_{0}.dat";
    private static final String PERSISTENT_STORAGE_DIRNAME = "repository";
    private static final Logger LOGGER = Logger.getLogger(Storage.class.getName());
    public static final String DEFAULT_PROPERTIES_EXT = ".properties";
    private static final Object temporaryStorageDirectoryLock = new Object();
    private static File temporaryStorageDirectory;
    private static final Object temporaryStorageDirectoryStringLock;
    private static String temporaryStorageDirectoryString;
    private static final Object persistentStorageDirectoryLock;
    private static File persistentStorageDirectory;
    private static final Object persistentStorageDirectoryStringLock;
    private static String persistentStorageDirectoryString;
    private final File directory;
    private final File propertiesFile;
    private Properties properties;

    public Storage() {
        this(new File(Storage.getTemporaryStorageDirectoryString()));
    }

    public Storage(File directory) {
        this(directory, null);
    }

    public Storage(File directory, String propertiesFile) {
        if (directory == null) {
            throw new NullPointerException("Directory cannot be null");
        }
        if (directory.isFile()) {
            throw new IllegalArgumentException("Not a valid directory: " + directory);
        }
        this.directory = directory;
        this.propertiesFile = propertiesFile != null ? new File(directory, propertiesFile) : null;
    }

    public synchronized boolean directoryExists() {
        return this.directory.exists();
    }

    public synchronized File getDirectory() {
        if (!Utils.prepareDirectory(this.directory)) {
            throw new IllegalStateException("Cannot create storage directory " + this.directory);
        }
        return this.directory;
    }

    public String getCustomProperty(String key) {
        return this.getCustomProperties(new String[]{key})[0];
    }

    public synchronized String[] getCustomProperties(String[] keys) {
        String[] values = new String[keys.length];
        Properties prop = this.getCustomProperties(false);
        if (prop != null) {
            for (int i = 0; i < keys.length; ++i) {
                values[i] = prop.getProperty(keys[i]);
            }
        }
        return values;
    }

    public void setCustomProperty(String key, String value) {
        this.setCustomProperties(new String[]{key}, new String[]{value});
    }

    public synchronized void setCustomProperties(String[] keys, String[] values) {
        Properties prop = this.getCustomProperties(true);
        for (int i = 0; i < keys.length; ++i) {
            if (values[i] != null) {
                prop.put(keys[i], values[i]);
                continue;
            }
            prop.remove(keys[i]);
        }
        this.storeCustomProperties();
    }

    public void clearCustomProperty(String key) {
        this.clearCustomProperties(new String[]{key});
    }

    public synchronized void clearCustomProperties(String[] keys) {
        Properties prop = this.getCustomProperties(false);
        if (prop != null) {
            for (String key : keys) {
                prop.remove(key);
            }
        }
        this.storeCustomProperties();
    }

    public synchronized boolean hasCustomProperties() {
        Properties prop = this.getCustomProperties(false);
        return prop != null && !prop.isEmpty();
    }

    public synchronized void saveCustomPropertiesTo(File file) {
        if (file == null) {
            throw new NullPointerException("File cannot be null");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Not a valid file: " + file);
        }
        Properties prop = this.getCustomProperties(false);
        if (prop != null && !prop.isEmpty()) {
            Storage.storeProperties(prop, file);
        }
    }

    public synchronized void deleteCustomPropertiesStorage() {
        if (this.propertiesFile != null && this.propertiesFile.exists() && !this.propertiesFile.delete()) {
            this.propertiesFile.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTemporaryStorageDirectoryString() {
        Object object = temporaryStorageDirectoryStringLock;
        synchronized (object) {
            if (temporaryStorageDirectoryString == null) {
                if (VISUALVM_TMP_DIR != null) {
                    temporaryStorageDirectoryString = new File(VISUALVM_TMP_DIR).getAbsolutePath() + File.separator + TEMPORARY_STORAGE_DIRNAME;
                } else {
                    String storageDir;
                    String tmpDir = System.getProperty("java.io.tmpdir");
                    String userDir = System.getProperty("user.home");
                    if (userDir != null && !userDir.isEmpty()) {
                        String userName = new File(userDir).getName();
                        storageDir = MessageFormat.format(TEMPORARY_STORAGE_DIRNAME_EX, userName);
                    } else {
                        storageDir = TEMPORARY_STORAGE_DIRNAME;
                    }
                    temporaryStorageDirectoryString = new File(tmpDir).getAbsolutePath() + File.separator + storageDir;
                }
            }
            return temporaryStorageDirectoryString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTemporaryStorageDirectory() {
        Object object = temporaryStorageDirectoryLock;
        synchronized (object) {
            if (temporaryStorageDirectory == null) {
                String temporaryStorageString = Storage.getTemporaryStorageDirectoryString();
                temporaryStorageDirectory = new File(temporaryStorageString);
                if (temporaryStorageDirectory.exists() && temporaryStorageDirectory.isFile()) {
                    throw new IllegalStateException("Cannot create temporary storage directory " + temporaryStorageString + ", file in the way");
                }
                if (!(!temporaryStorageDirectory.exists() || temporaryStorageDirectory.canRead() && temporaryStorageDirectory.canWrite())) {
                    throw new IllegalStateException("Cannot access temporary storage directory " + temporaryStorageString + ", read&write permission required");
                }
                if (!Utils.prepareDirectory(temporaryStorageDirectory)) {
                    throw new IllegalStateException("Cannot create temporary storage directory " + temporaryStorageString);
                }
            }
            return temporaryStorageDirectory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPersistentStorageDirectoryString() {
        Object object = persistentStorageDirectoryStringLock;
        synchronized (object) {
            if (persistentStorageDirectoryString == null) {
                persistentStorageDirectoryString = new File(System.getProperty("netbeans.user")).getAbsolutePath() + File.separator + PERSISTENT_STORAGE_DIRNAME;
            }
            return persistentStorageDirectoryString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getPersistentStorageDirectory() {
        Object object = persistentStorageDirectoryLock;
        synchronized (object) {
            if (persistentStorageDirectory == null) {
                String persistentStorageString = Storage.getPersistentStorageDirectoryString();
                persistentStorageDirectory = new File(persistentStorageString);
                if (persistentStorageDirectory.exists() && persistentStorageDirectory.isFile()) {
                    throw new IllegalStateException("Cannot create persistent storage directory " + persistentStorageString + ", file in the way");
                }
                if (!(!persistentStorageDirectory.exists() || persistentStorageDirectory.canRead() && persistentStorageDirectory.canWrite())) {
                    throw new IllegalStateException("Cannot access persistent storage directory " + persistentStorageString + ", read&write permission required");
                }
                if (!Utils.prepareDirectory(persistentStorageDirectory)) {
                    throw new IllegalStateException("Cannot create persistent storage directory " + persistentStorageString);
                }
            }
            return persistentStorageDirectory;
        }
    }

    public static boolean persistentStorageDirectoryExists() {
        return new File(Storage.getPersistentStorageDirectoryString()).isDirectory();
    }

    private void storeCustomProperties() {
        if (this.properties != null && this.propertiesFile != null) {
            Storage.storeProperties(this.properties, this.propertiesFile);
        }
    }

    private Properties getCustomProperties(boolean createEmpty) {
        if (this.properties == null && this.propertiesFile != null) {
            this.properties = Storage.loadProperties(this.propertiesFile);
        }
        if (this.properties == null && createEmpty) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    /*
     * Exception decompiling
     */
    private static Properties loadProperties(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void storeProperties(Properties properties, File file) {
        Utils.prepareDirectory(file.getParentFile());
        try (FileOutputStream os = new FileOutputStream(file);
             BufferedOutputStream bos = new BufferedOutputStream(os);){
            properties.storeToXML(bos, null);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error storing properties", e);
        }
    }

    static {
        temporaryStorageDirectoryStringLock = new Object();
        persistentStorageDirectoryLock = new Object();
        persistentStorageDirectoryStringLock = new Object();
    }
}

