/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import jdk.jfr.EventType;
import jdk.jfr.FlightRecorder;
import jdk.jfr.FlightRecorderListener;
import jdk.jfr.Recording;
import jdk.jfr.RecordingState;
import jdk.jfr.events.ActiveRecordingEvent;
import jdk.jfr.events.ActiveSettingEvent;
import jdk.jfr.internal.EventControl;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataRepository;
import jdk.jfr.internal.OldObjectSample;
import jdk.jfr.internal.Options;
import jdk.jfr.internal.PlatformRecording;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.Repository;
import jdk.jfr.internal.RepositoryChunk;
import jdk.jfr.internal.RequestEngine;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.ShutdownHook;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.WriteableUserPath;
import jdk.jfr.internal.instrument.JDKEvents;

public final class PlatformRecorder {
    private final List<PlatformRecording> recordings = new ArrayList<PlatformRecording>();
    private static final List<SecuritySupport.SecureRecorderListener> changeListeners = new ArrayList<SecuritySupport.SecureRecorderListener>();
    private final Repository repository = Repository.getRepository();
    private final Timer timer;
    private static final JVM jvm = JVM.getJVM();
    private final EventType activeRecordingEvent;
    private final EventType activeSettingEvent;
    private final Thread shutdownHook;
    private long recordingCounter = 0L;
    private RepositoryChunk currentChunk;

    public PlatformRecorder() throws Exception {
        Logger.log(LogTag.JFR_SYSTEM, LogLevel.INFO, "Initialized disk repository");
        this.repository.ensureRepository();
        jvm.createNativeJFR();
        Logger.log(LogTag.JFR_SYSTEM, LogLevel.INFO, "Created native");
        JDKEvents.initialize();
        Logger.log(LogTag.JFR_SYSTEM, LogLevel.INFO, "Registered JDK events");
        JDKEvents.addInstrumentation();
        this.startDiskMonitor();
        SecuritySupport.registerEvent(ActiveRecordingEvent.class);
        this.activeRecordingEvent = EventType.getEventType(ActiveRecordingEvent.class);
        SecuritySupport.registerEvent(ActiveSettingEvent.class);
        this.activeSettingEvent = EventType.getEventType(ActiveSettingEvent.class);
        this.shutdownHook = SecuritySupport.createThreadWitNoPermissions("JFR: Shutdown Hook", new ShutdownHook(this));
        SecuritySupport.setUncaughtExceptionHandler(this.shutdownHook, new ShutdownHook.ExceptionHandler());
        SecuritySupport.registerShutdownHook(this.shutdownHook);
        this.timer = PlatformRecorder.createTimer();
    }

    private static Timer createTimer() {
        try {
            CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList();
            Thread thread = SecuritySupport.createThreadWitNoPermissions("Permissionless thread", () -> copyOnWriteArrayList.add(new Timer("JFR Recording Scheduler", true)));
            thread.start();
            thread.join();
            return (Timer)copyOnWriteArrayList.get(0);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("Not able to create timer task. " + interruptedException.getMessage(), interruptedException);
        }
    }

    public synchronized PlatformRecording newRecording(Map<String, String> map) {
        return this.newRecording(map, ++this.recordingCounter);
    }

    public PlatformRecording newTemporaryRecording() {
        if (!Thread.holdsLock(this)) {
            throw new InternalError("Caller must have recorder lock");
        }
        return this.newRecording(new HashMap<String, String>(), 0L);
    }

    private synchronized PlatformRecording newRecording(Map<String, String> map, long l) {
        PlatformRecording platformRecording = new PlatformRecording(this, l);
        if (!map.isEmpty()) {
            platformRecording.setSettings(map);
        }
        this.recordings.add(platformRecording);
        return platformRecording;
    }

    synchronized void finish(PlatformRecording platformRecording) {
        if (platformRecording.getState() == RecordingState.RUNNING) {
            platformRecording.stop("Recording closed");
        }
        this.recordings.remove(platformRecording);
    }

    public synchronized List<PlatformRecording> getRecordings() {
        return Collections.unmodifiableList(new ArrayList<PlatformRecording>(this.recordings));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void addListener(FlightRecorderListener flightRecorderListener) {
        AccessControlContext accessControlContext = AccessController.getContext();
        SecuritySupport.SecureRecorderListener secureRecorderListener = new SecuritySupport.SecureRecorderListener(accessControlContext, flightRecorderListener);
        Class<PlatformRecorder> clazz = PlatformRecorder.class;
        synchronized (PlatformRecorder.class) {
            boolean bl = FlightRecorder.isInitialized();
            changeListeners.add(secureRecorderListener);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (bl) {
                secureRecorderListener.recorderInitialized(FlightRecorder.getFlightRecorder());
            }
            return;
        }
    }

    public static synchronized boolean removeListener(FlightRecorderListener flightRecorderListener) {
        for (SecuritySupport.SecureRecorderListener secureRecorderListener : new ArrayList<SecuritySupport.SecureRecorderListener>(changeListeners)) {
            if (secureRecorderListener.getChangeListener() != flightRecorderListener) continue;
            changeListeners.remove(secureRecorderListener);
            return true;
        }
        return false;
    }

    static synchronized List<FlightRecorderListener> getListeners() {
        return new ArrayList<FlightRecorderListener>(changeListeners);
    }

    Timer getTimer() {
        return this.timer;
    }

    public static void notifyRecorderInitialized(FlightRecorder flightRecorder) {
        Logger.log(LogTag.JFR_SYSTEM, LogLevel.TRACE, "Notifying listeners that Flight Recorder is initialized");
        for (FlightRecorderListener flightRecorderListener : PlatformRecorder.getListeners()) {
            flightRecorderListener.recorderInitialized(flightRecorder);
        }
    }

    synchronized void destroy() {
        try {
            this.timer.cancel();
        }
        catch (Exception exception) {
            Logger.log(LogTag.JFR_SYSTEM, LogLevel.WARN, "Shutdown hook could not cancel timer");
        }
        for (PlatformRecording platformRecording : this.getRecordings()) {
            if (platformRecording.getState() != RecordingState.RUNNING) continue;
            try {
                platformRecording.stop("Shutdown");
            }
            catch (Exception exception) {
                Logger.log(LogTag.JFR, LogLevel.WARN, "Recording " + platformRecording.getName() + ":" + platformRecording.getId() + " could not be stopped");
            }
        }
        JDKEvents.remove();
        if (jvm.hasNativeJFR()) {
            if (jvm.isRecording()) {
                jvm.endRecording_();
            }
            jvm.destroyNativeJFR();
        }
        this.repository.clear();
    }

    synchronized void start(PlatformRecording platformRecording) {
        Object object;
        Instant instant = Instant.now();
        platformRecording.setStartTime(instant);
        platformRecording.updateTimer();
        Duration duration = platformRecording.getDuration();
        if (duration != null) {
            platformRecording.setStopTime(instant.plus(duration));
        }
        boolean bl = platformRecording.isToDisk();
        boolean bl2 = true;
        for (PlatformRecording platformRecording2 : this.getRecordings()) {
            if (platformRecording2.getState() != RecordingState.RUNNING) continue;
            bl2 = false;
            if (!platformRecording2.isToDisk()) continue;
            bl = true;
        }
        if (bl2) {
            object = null;
            if (bl) {
                object = this.repository.newChunk(instant);
                MetadataRepository.getInstance().setOutput(((RepositoryChunk)object).getUnfishedFile().toString());
            } else {
                MetadataRepository.getInstance().setOutput(null);
            }
            this.currentChunk = object;
            jvm.beginRecording_();
            platformRecording.setState(RecordingState.RUNNING);
            this.updateSettings();
            this.writeMetaEvents();
        } else {
            object = null;
            if (bl) {
                object = this.repository.newChunk(instant);
                RequestEngine.doChunkEnd();
                MetadataRepository.getInstance().setOutput(((RepositoryChunk)object).getUnfishedFile().toString());
            }
            platformRecording.setState(RecordingState.RUNNING);
            this.updateSettings();
            this.writeMetaEvents();
            if (this.currentChunk != null) {
                this.finishChunk(this.currentChunk, instant, platformRecording);
            }
            this.currentChunk = object;
        }
        RequestEngine.doChunkBegin();
    }

    synchronized void stop(PlatformRecording platformRecording) {
        RecordingState recordingState = platformRecording.getState();
        if (Utils.isAfter(recordingState, RecordingState.RUNNING)) {
            throw new IllegalStateException("Can't stop an already stopped recording.");
        }
        if (Utils.isBefore(recordingState, RecordingState.RUNNING)) {
            throw new IllegalStateException("Recording must be started before it can be stopped.");
        }
        Instant instant = Instant.now();
        boolean bl = false;
        boolean bl2 = true;
        for (PlatformRecording platformRecording2 : this.getRecordings()) {
            RecordingState recordingState2 = platformRecording2.getState();
            if (platformRecording2 == platformRecording || RecordingState.RUNNING != recordingState2) continue;
            bl2 = false;
            if (!platformRecording2.isToDisk()) continue;
            bl = true;
        }
        OldObjectSample.emit(platformRecording);
        if (bl2) {
            RequestEngine.doChunkEnd();
            if (platformRecording.isToDisk()) {
                if (this.currentChunk != null) {
                    MetadataRepository.getInstance().setOutput(null);
                    this.finishChunk(this.currentChunk, instant, null);
                    this.currentChunk = null;
                }
            } else {
                this.dumpMemoryToDestination(platformRecording);
            }
            jvm.endRecording_();
            this.disableEvents();
        } else {
            Object object = null;
            RequestEngine.doChunkEnd();
            this.updateSettingsButIgnoreRecording(platformRecording);
            if (bl) {
                object = this.repository.newChunk(instant);
                MetadataRepository.getInstance().setOutput(((RepositoryChunk)object).getUnfishedFile().toString());
            } else {
                MetadataRepository.getInstance().setOutput(null);
            }
            this.writeMetaEvents();
            if (this.currentChunk != null) {
                this.finishChunk(this.currentChunk, instant, null);
            }
            this.currentChunk = object;
            RequestEngine.doChunkBegin();
        }
        platformRecording.setState(RecordingState.STOPPED);
    }

    private void dumpMemoryToDestination(PlatformRecording platformRecording) {
        WriteableUserPath writeableUserPath = platformRecording.getDestination();
        if (writeableUserPath != null) {
            MetadataRepository.getInstance().setOutput(writeableUserPath.getRealPathText());
            platformRecording.clearDestination();
        }
    }

    private void disableEvents() {
        MetadataRepository.getInstance().disableEvents();
    }

    void updateSettings() {
        this.updateSettingsButIgnoreRecording(null);
    }

    void updateSettingsButIgnoreRecording(PlatformRecording platformRecording) {
        List<PlatformRecording> list = this.getRunningRecordings();
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>(list.size());
        for (PlatformRecording platformRecording2 : list) {
            if (platformRecording2 == platformRecording) continue;
            arrayList.add(platformRecording2.getSettings());
        }
        MetadataRepository.getInstance().setSettings(arrayList);
    }

    synchronized void rotateDisk() {
        Instant instant = Instant.now();
        RepositoryChunk repositoryChunk = this.repository.newChunk(instant);
        RequestEngine.doChunkEnd();
        MetadataRepository.getInstance().setOutput(repositoryChunk.getUnfishedFile().toString());
        this.writeMetaEvents();
        if (this.currentChunk != null) {
            this.finishChunk(this.currentChunk, instant, null);
        }
        this.currentChunk = repositoryChunk;
        RequestEngine.doChunkBegin();
    }

    private List<PlatformRecording> getRunningRecordings() {
        ArrayList<PlatformRecording> arrayList = new ArrayList<PlatformRecording>();
        for (PlatformRecording platformRecording : this.getRecordings()) {
            if (platformRecording.getState() != RecordingState.RUNNING) continue;
            arrayList.add(platformRecording);
        }
        return arrayList;
    }

    private List<RepositoryChunk> makeChunkList(Instant instant, Instant instant2) {
        HashSet<RepositoryChunk> hashSet = new HashSet<RepositoryChunk>();
        for (PlatformRecording object : this.getRecordings()) {
            hashSet.addAll(object.getChunks());
        }
        if (hashSet.size() > 0) {
            ArrayList arrayList = new ArrayList(hashSet.size());
            for (RepositoryChunk repositoryChunk : hashSet) {
                if (!repositoryChunk.inInterval(instant, instant2)) continue;
                arrayList.add(repositoryChunk);
            }
            Collections.sort(arrayList, RepositoryChunk.END_TIME_COMPARATOR);
            return arrayList;
        }
        return Collections.emptyList();
    }

    private void startDiskMonitor() {
        Thread thread = SecuritySupport.createThreadWitNoPermissions("JFR Periodic Tasks", () -> this.periodicTask());
        SecuritySupport.setDaemonThread(thread, true);
        thread.start();
    }

    private void finishChunk(RepositoryChunk repositoryChunk, Instant instant, PlatformRecording platformRecording) {
        repositoryChunk.finish(instant);
        for (PlatformRecording platformRecording2 : this.getRecordings()) {
            if (platformRecording2 == platformRecording || platformRecording2.getState() != RecordingState.RUNNING) continue;
            platformRecording2.appendChunk(repositoryChunk);
        }
    }

    private void writeMetaEvents() {
        if (this.activeRecordingEvent.isEnabled()) {
            for (PlatformRecording object : this.getRecordings()) {
                if (object.getState() != RecordingState.RUNNING || !object.shouldWriteMetadataEvent()) continue;
                ActiveRecordingEvent activeRecordingEvent = new ActiveRecordingEvent();
                activeRecordingEvent.id = object.getId();
                activeRecordingEvent.name = object.getName();
                WriteableUserPath writeableUserPath = object.getDestination();
                activeRecordingEvent.destination = writeableUserPath == null ? null : writeableUserPath.getRealPathText();
                Duration duration = object.getDuration();
                activeRecordingEvent.recordingDuration = duration == null ? Long.MAX_VALUE : duration.toMillis();
                Duration duration2 = object.getMaxAge();
                activeRecordingEvent.maxAge = duration2 == null ? Long.MAX_VALUE : duration2.toMillis();
                Long l = object.getMaxSize();
                activeRecordingEvent.maxSize = l == null ? Long.MAX_VALUE : l;
                Instant instant = object.getStartTime();
                activeRecordingEvent.recordingStart = instant == null ? Long.MAX_VALUE : instant.toEpochMilli();
                activeRecordingEvent.commit();
            }
        }
        if (this.activeSettingEvent.isEnabled()) {
            for (EventControl eventControl : MetadataRepository.getInstance().getEventControls()) {
                eventControl.writeActiveSettingEvent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void periodicTask() {
        if (!jvm.hasNativeJFR()) {
            return;
        }
        while (true) {
            PlatformRecorder platformRecorder = this;
            synchronized (platformRecorder) {
                if (jvm.shouldRotateDisk()) {
                    this.rotateDisk();
                }
            }
            long l = RequestEngine.doPeriodic();
            long l2 = Math.min(l, Options.getWaitInterval());
            this.takeNap(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeNap(long l) {
        try {
            Object object = JVM.FILE_DELTA_CHANGE;
            synchronized (object) {
                JVM.FILE_DELTA_CHANGE.wait(l < 10L ? 10L : l);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    synchronized Recording newCopy(PlatformRecording platformRecording, boolean bl) {
        Recording recording = new Recording();
        PlatformRecording platformRecording2 = PrivateAccess.getInstance().getPlatformRecording(recording);
        platformRecording2.setSettings(platformRecording.getSettings());
        platformRecording2.setMaxAge(platformRecording.getMaxAge());
        platformRecording2.setMaxSize(platformRecording.getMaxSize());
        platformRecording2.setDumpOnExit(platformRecording.getDumpOnExit());
        platformRecording2.setName("Clone of " + platformRecording.getName());
        platformRecording2.setToDisk(platformRecording.isToDisk());
        platformRecording2.setInternalDuration(platformRecording.getDuration());
        platformRecording2.setStartTime(platformRecording.getStartTime());
        platformRecording2.setStopTime(platformRecording.getStopTime());
        if (platformRecording.getState() == RecordingState.NEW) {
            return recording;
        }
        if (platformRecording.getState() == RecordingState.DELAYED) {
            platformRecording2.scheduleStart(platformRecording.getStartTime());
            return recording;
        }
        platformRecording2.setState(platformRecording.getState());
        for (RepositoryChunk repositoryChunk : platformRecording.getChunks()) {
            platformRecording2.add(repositoryChunk);
        }
        if (platformRecording.getState() == RecordingState.RUNNING) {
            if (bl) {
                platformRecording2.stop("Stopped when cloning recording '" + platformRecording.getName() + "'");
            } else if (platformRecording.getStopTime() != null) {
                TimerTask timerTask = platformRecording2.createStopTask();
                platformRecording2.setStopTask(platformRecording2.createStopTask());
                this.getTimer().schedule(timerTask, platformRecording.getStopTime().toEpochMilli());
            }
        }
        return recording;
    }

    public synchronized void fillWithRecordedData(PlatformRecording platformRecording, Boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (PlatformRecording object : this.recordings) {
            if (object.getState() != RecordingState.RUNNING) continue;
            bl2 = true;
            if (!object.isToDisk()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3) {
                OldObjectSample.emit(this.recordings, bl);
                this.rotateDisk();
            } else {
                Throwable throwable = null;
                try (PlatformRecording platformRecording2 = this.newTemporaryRecording();){
                    platformRecording2.setToDisk(true);
                    platformRecording2.setShouldWriteActiveRecordingEvent(false);
                    platformRecording2.start();
                    OldObjectSample.emit(this.recordings, bl);
                    platformRecording2.stop("Snapshot dump");
                    this.fillWithDiskChunks(platformRecording);
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
                return;
            }
        }
        this.fillWithDiskChunks(platformRecording);
    }

    /*
     * WARNING - void declaration
     */
    private void fillWithDiskChunks(PlatformRecording platformRecording) {
        void var3_8;
        void var3_5;
        for (RepositoryChunk object2 : this.makeChunkList(null, null)) {
            platformRecording.add(object2);
        }
        platformRecording.setState(RecordingState.STOPPED);
        Object object3 = null;
        Object var3_4 = null;
        for (RepositoryChunk repositoryChunk : platformRecording.getChunks()) {
            if (object3 == null || repositoryChunk.getStartTime().isBefore((Instant)object3)) {
                object3 = repositoryChunk.getStartTime();
            }
            if (var3_5 != null && !repositoryChunk.getEndTime().isAfter((Instant)var3_5)) continue;
            Instant instant = repositoryChunk.getEndTime();
        }
        Instant instant = Instant.now();
        if (object3 == null) {
            object3 = instant;
        }
        if (var3_5 == null) {
            Instant instant2 = instant;
        }
        platformRecording.setStartTime((Instant)object3);
        platformRecording.setStopTime((Instant)var3_8);
        platformRecording.setInternalDuration(Duration.between((Temporal)object3, (Temporal)var3_8));
    }
}

