/**********************************************************
 * This file has been automatically created by "typemaker2"
 * from the file "refaccount.xml".
 * Please do not edit this file, all changes will be lost.
 * Better edit the mentioned source file instead.
 **********************************************************/

#ifndef AB_REFERENCE_ACCOUNT_REFACCOUNT_H
#define AB_REFERENCE_ACCOUNT_REFACCOUNT_H


#ifdef __cplusplus
extern "C" {
#endif

/** @page P_AB_REFERENCE_ACCOUNT Structure AB_REFERENCE_ACCOUNT
<p>This page describes the properties of AB_REFERENCE_ACCOUNT.</p>



<h1>AB_REFERENCE_ACCOUNT</h1>

This type contains all information on reference accounts


@anchor AB_REFERENCE_ACCOUNT_iban
<h2>iban</h2>

International bank account number as specified by the SEPA specs.
<p>Set this property with @ref AB_ReferenceAccount_SetIban(), get it with @ref AB_ReferenceAccount_GetIban().</p>


@anchor AB_REFERENCE_ACCOUNT_bic
<h2>bic</h2>

SWIFT code of the bank at which this account is registered.
<p>Set this property with @ref AB_ReferenceAccount_SetBic(), get it with @ref AB_ReferenceAccount_GetBic().</p>


@anchor AB_REFERENCE_ACCOUNT_accountNumber
<h2>accountNumber</h2>

Account number in national account specification.
<p>Set this property with @ref AB_ReferenceAccount_SetAccountNumber(), get it with @ref AB_ReferenceAccount_GetAccountNumber().</p>


@anchor AB_REFERENCE_ACCOUNT_subAccountNumber
<h2>subAccountNumber</h2>

If your account has subaccounts which are distinguished by different suffixes, then this is that suffix. Otherwise it is empty. (HBCI only)
<p>Set this property with @ref AB_ReferenceAccount_SetSubAccountNumber(), get it with @ref AB_ReferenceAccount_GetSubAccountNumber().</p>


@anchor AB_REFERENCE_ACCOUNT_country
<h2>country</h2>

<p>Set this property with @ref AB_ReferenceAccount_SetCountry(), get it with @ref AB_ReferenceAccount_GetCountry().</p>


@anchor AB_REFERENCE_ACCOUNT_bankCode
<h2>bankCode</h2>

National bank code (e.g. BLZ in Germany, routing number in other countries).
<p>Set this property with @ref AB_ReferenceAccount_SetBankCode(), get it with @ref AB_ReferenceAccount_GetBankCode().</p>


@anchor AB_REFERENCE_ACCOUNT_ownerName
<h2>ownerName</h2>

Name of the account owner as it is stored with the bank.
<p>Set this property with @ref AB_ReferenceAccount_SetOwnerName(), get it with @ref AB_ReferenceAccount_GetOwnerName().</p>


@anchor AB_REFERENCE_ACCOUNT_ownerName2
<h2>ownerName2</h2>

Name of the account owner as it is stored with the bank.
<p>Set this property with @ref AB_ReferenceAccount_SetOwnerName2(), get it with @ref AB_ReferenceAccount_GetOwnerName2().</p>


@anchor AB_REFERENCE_ACCOUNT_accountName
<h2>accountName</h2>

Name of the account.
<p>Set this property with @ref AB_ReferenceAccount_SetAccountName(), get it with @ref AB_ReferenceAccount_GetAccountName().</p>


@anchor AB_REFERENCE_ACCOUNT_accountType
<h2>accountType</h2>

Name of the account.
<p>Set this property with @ref AB_ReferenceAccount_SetAccountType(), get it with @ref AB_ReferenceAccount_GetAccountType().</p>

*/

/* needed system headers */
#include <gwenhywfar/types.h>
#include <gwenhywfar/list1.h>
#include <gwenhywfar/list2.h>
#include <gwenhywfar/db.h>
#include <gwenhywfar/xml.h>

/* pre-headers */
#include <aqbanking/error.h>
#include <gwenhywfar/text.h>

typedef struct AB_REFERENCE_ACCOUNT AB_REFERENCE_ACCOUNT;
GWEN_LIST_FUNCTION_LIB_DEFS(AB_REFERENCE_ACCOUNT, AB_ReferenceAccount, AQBANKING_API)
GWEN_LIST2_FUNCTION_LIB_DEFS(AB_REFERENCE_ACCOUNT, AB_ReferenceAccount, AQBANKING_API)



/* post-headers */


/** Constructor. */
AQBANKING_API AB_REFERENCE_ACCOUNT *AB_ReferenceAccount_new(void);

/** Destructor. */
AQBANKING_API void AB_ReferenceAccount_free(AB_REFERENCE_ACCOUNT *p_struct);

AQBANKING_API void AB_ReferenceAccount_Attach(AB_REFERENCE_ACCOUNT *p_struct);

AQBANKING_API AB_REFERENCE_ACCOUNT *AB_ReferenceAccount_dup(const AB_REFERENCE_ACCOUNT *p_src);

AQBANKING_API AB_REFERENCE_ACCOUNT *AB_ReferenceAccount_copy(AB_REFERENCE_ACCOUNT *p_struct, const AB_REFERENCE_ACCOUNT *p_src);

/** Getter.
 * Use this function to get the member "iban" (see @ref AB_REFERENCE_ACCOUNT_iban)
*/
AQBANKING_API const char *AB_ReferenceAccount_GetIban(const AB_REFERENCE_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "bic" (see @ref AB_REFERENCE_ACCOUNT_bic)
*/
AQBANKING_API const char *AB_ReferenceAccount_GetBic(const AB_REFERENCE_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "accountNumber" (see @ref AB_REFERENCE_ACCOUNT_accountNumber)
*/
AQBANKING_API const char *AB_ReferenceAccount_GetAccountNumber(const AB_REFERENCE_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "subAccountNumber" (see @ref AB_REFERENCE_ACCOUNT_subAccountNumber)
*/
AQBANKING_API const char *AB_ReferenceAccount_GetSubAccountNumber(const AB_REFERENCE_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "country" (see @ref AB_REFERENCE_ACCOUNT_country)
*/
AQBANKING_API const char *AB_ReferenceAccount_GetCountry(const AB_REFERENCE_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "bankCode" (see @ref AB_REFERENCE_ACCOUNT_bankCode)
*/
AQBANKING_API const char *AB_ReferenceAccount_GetBankCode(const AB_REFERENCE_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "ownerName" (see @ref AB_REFERENCE_ACCOUNT_ownerName)
*/
AQBANKING_API const char *AB_ReferenceAccount_GetOwnerName(const AB_REFERENCE_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "ownerName2" (see @ref AB_REFERENCE_ACCOUNT_ownerName2)
*/
AQBANKING_API const char *AB_ReferenceAccount_GetOwnerName2(const AB_REFERENCE_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "accountName" (see @ref AB_REFERENCE_ACCOUNT_accountName)
*/
AQBANKING_API const char *AB_ReferenceAccount_GetAccountName(const AB_REFERENCE_ACCOUNT *p_struct);

/** Getter.
 * Use this function to get the member "accountType" (see @ref AB_REFERENCE_ACCOUNT_accountType)
*/
AQBANKING_API uint8_t AB_ReferenceAccount_GetAccountType(const AB_REFERENCE_ACCOUNT *p_struct);

/** Setter.
 * Use this function to set the member "iban" (see @ref AB_REFERENCE_ACCOUNT_iban)
*/
AQBANKING_API void AB_ReferenceAccount_SetIban(AB_REFERENCE_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "bic" (see @ref AB_REFERENCE_ACCOUNT_bic)
*/
AQBANKING_API void AB_ReferenceAccount_SetBic(AB_REFERENCE_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "accountNumber" (see @ref AB_REFERENCE_ACCOUNT_accountNumber)
*/
AQBANKING_API void AB_ReferenceAccount_SetAccountNumber(AB_REFERENCE_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "subAccountNumber" (see @ref AB_REFERENCE_ACCOUNT_subAccountNumber)
*/
AQBANKING_API void AB_ReferenceAccount_SetSubAccountNumber(AB_REFERENCE_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "country" (see @ref AB_REFERENCE_ACCOUNT_country)
*/
AQBANKING_API void AB_ReferenceAccount_SetCountry(AB_REFERENCE_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "bankCode" (see @ref AB_REFERENCE_ACCOUNT_bankCode)
*/
AQBANKING_API void AB_ReferenceAccount_SetBankCode(AB_REFERENCE_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "ownerName" (see @ref AB_REFERENCE_ACCOUNT_ownerName)
*/
AQBANKING_API void AB_ReferenceAccount_SetOwnerName(AB_REFERENCE_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "ownerName2" (see @ref AB_REFERENCE_ACCOUNT_ownerName2)
*/
AQBANKING_API void AB_ReferenceAccount_SetOwnerName2(AB_REFERENCE_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "accountName" (see @ref AB_REFERENCE_ACCOUNT_accountName)
*/
AQBANKING_API void AB_ReferenceAccount_SetAccountName(AB_REFERENCE_ACCOUNT *p_struct, const char *p_src);

/** Setter.
 * Use this function to set the member "accountType" (see @ref AB_REFERENCE_ACCOUNT_accountType)
*/
AQBANKING_API void AB_ReferenceAccount_SetAccountType(AB_REFERENCE_ACCOUNT *p_struct, uint8_t p_src);

AQBANKING_API AB_REFERENCE_ACCOUNT_LIST *AB_ReferenceAccount_List_dup(const AB_REFERENCE_ACCOUNT_LIST *p_src);

AQBANKING_API void AB_ReferenceAccount_ReadDb(AB_REFERENCE_ACCOUNT *p_struct, GWEN_DB_NODE *p_db);

AQBANKING_API int AB_ReferenceAccount_WriteDb(const AB_REFERENCE_ACCOUNT *p_struct, GWEN_DB_NODE *p_db);

AQBANKING_API AB_REFERENCE_ACCOUNT *AB_ReferenceAccount_fromDb(GWEN_DB_NODE *p_db);

AQBANKING_API int AB_ReferenceAccount_toDb(const AB_REFERENCE_ACCOUNT *p_struct, GWEN_DB_NODE *p_db);

AQBANKING_API void AB_ReferenceAccount_ReadXml(AB_REFERENCE_ACCOUNT *p_struct, GWEN_XMLNODE *p_db);

AQBANKING_API void AB_ReferenceAccount_WriteXml(const AB_REFERENCE_ACCOUNT *p_struct, GWEN_XMLNODE *p_db);

AQBANKING_API void AB_ReferenceAccount_toXml(const AB_REFERENCE_ACCOUNT *p_struct, GWEN_XMLNODE *p_db);

AQBANKING_API AB_REFERENCE_ACCOUNT *AB_ReferenceAccount_fromXml(GWEN_XMLNODE *p_db);

/** 
 * Check whether a given reference account info object matches the given criteria. 
 * @param a account info object to match 
 * @param iban IBAN to search for (wildcards and jokers allowed) 
 * @param bic BIC to search for (wildcards and jokers allowed) 
 * @param accountNumber account number to search for (wildcards and jokers allowed) 
 * @param subAccountNumber sub account number (wildcards and jokers allowed) 
 * @param country ISO code of the country (wildcards and jokers allowed) 
 * @param bankCode bank code to search for (wildcards and jokers allowed) 
 * @param ownerName owner name to search for (wildcards and jokers allowed) 
 * @param accountName account name to search for (wildcards and jokers allowed) 
 */ 
 AQBANKING_API int AB_ReferenceAccount_Matches(const AB_REFERENCE_ACCOUNT *a, const char *iban, const char *bic, const char *accountNumber, const char *subAccountNumber, const char *country, const char *bankCode, const char *ownerName, const char *accountName);
/** 
 * Find the first matching account info object in a list of account info objects. 
 * @param al list of account info objects among to search 
 @param iban IBAN to search for (wildcards and jokers allowed) 
 * @param bic BIC to search for (wildcards and jokers allowed) 
 * @param accountNumber account number to search for (wildcards and jokers allowed) 
 * @param subAccountNumber sub account number (wildcards and jokers allowed) 
 * @param country ISO code of the country (wildcards and jokers allowed) 
 * @param bankCode bank code to search for (wildcards and jokers allowed) 
 * @param ownerName owner name to search for (wildcards and jokers allowed) 
 * @param accountName account name to search for (wildcards and jokers allowed) 
 */ 
 AQBANKING_API AB_REFERENCE_ACCOUNT *AB_ReferenceAccount_List_FindFirst(const AB_REFERENCE_ACCOUNT_LIST *al, 
 const char *iban, const char *bic, const char *accountNumber, const char *subAccountNumber, const char *country, const char *bankCode, const char *ownerName, const char *accountName);
/** 
 * Find the next matching account info object in a list of account info objects. 
 * @param a previous matching account info objects among to search 
 * @param iban IBAN to search for (wildcards and jokers allowed) 
 * @param bic BIC to search for (wildcards and jokers allowed) 
 * @param accountNumber account number to search for (wildcards and jokers allowed) 
 * @param subAccountNumber sub account number (wildcards and jokers allowed) 
 * @param country ISO code of the country (wildcards and jokers allowed) 
 * @param bankCode bank code to search for (wildcards and jokers allowed) 
 * @param ownerName owner name to search for (wildcards and jokers allowed) 
 * @param accountName account name to search for (wildcards and jokers allowed) 
 */ 
 AQBANKING_API AB_REFERENCE_ACCOUNT *AB_ReferenceAccount_List_FindNext(AB_REFERENCE_ACCOUNT *a, const char *iban, const char *bic, const char *accountNumber, const char *subAccountNumber, const char *country, const char *bankCode, const char *ownerName, const char *accountName);
/* end-headers */


#ifdef __cplusplus
}
#endif

#endif

