/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.util.ArrayList;
import java.util.List;

public class TagModel {
    private String name;
    private final List<String> values = new ArrayList<String>();

    public TagModel() {
        this.setName("");
        this.setValue("");
    }

    public TagModel(String name) {
        this();
        this.setName(name);
    }

    public TagModel(String name, String value) {
        this();
        this.setName(name);
        this.setValue(value);
    }

    public final void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public String getName() {
        return this.name;
    }

    public void clearValues() {
        this.values.clear();
    }

    public final void setValue(String value) {
        this.clearValues();
        this.values.add(value == null ? "" : value);
    }

    public boolean hasValue(String value) {
        return this.values.contains(value == null ? "" : value);
    }

    public void addValue(String value) {
        String val;
        String string = val = value == null ? "" : value;
        if (this.hasValue(val)) {
            return;
        }
        this.values.add(val);
    }

    public void removeValue(String value) {
        this.values.remove(value == null ? "" : value);
    }

    public List<String> getValues() {
        return this.values;
    }

    public String getValue() {
        if (this.getValueCount() == 0) {
            return "";
        }
        if (this.getValueCount() == 1) {
            return this.values.get(0);
        }
        return String.join((CharSequence)";", this.values);
    }

    public int getValueCount() {
        return this.values.size();
    }

    public String toString() {
        return this.name + "=" + String.valueOf(this.values);
    }
}

