/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.sync;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryVersion;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.api.common.CloseableIterable;
import org.infinispan.api.common.process.CacheEntryProcessorResult;
import org.infinispan.api.common.process.CacheProcessorOptions;
import org.infinispan.api.configuration.CacheConfiguration;
import org.infinispan.api.sync.SyncCacheEntryProcessor;
import org.infinispan.api.sync.SyncContainer;
import org.infinispan.api.sync.SyncQuery;
import org.infinispan.api.sync.SyncStreamingCache;
import org.infinispan.api.sync.events.cache.SyncCacheEntryListener;

public interface SyncCache<K, V> {
    public String name();

    public CacheConfiguration configuration();

    public SyncContainer container();

    default public V get(K key) {
        return this.get(key, CacheOptions.DEFAULT);
    }

    default public V get(K key, CacheOptions options) {
        CacheEntry<K, V> entry = this.getEntry(key, options);
        return entry == null ? null : (V)entry.value();
    }

    default public CacheEntry<K, V> getEntry(K key) {
        return this.getEntry(key, CacheOptions.DEFAULT);
    }

    public CacheEntry<K, V> getEntry(K var1, CacheOptions var2);

    default public CacheEntry<K, V> put(K key, V value) {
        return this.put(key, value, CacheWriteOptions.DEFAULT);
    }

    public CacheEntry<K, V> put(K var1, V var2, CacheWriteOptions var3);

    default public void set(K key, V value) {
        this.set(key, value, CacheWriteOptions.DEFAULT);
    }

    default public void set(K key, V value, CacheWriteOptions options) {
        this.put(key, value, options);
    }

    default public CacheEntry<K, V> putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, CacheWriteOptions.DEFAULT);
    }

    public CacheEntry<K, V> putIfAbsent(K var1, V var2, CacheWriteOptions var3);

    default public boolean setIfAbsent(K key, V value) {
        return this.setIfAbsent(key, value, CacheWriteOptions.DEFAULT);
    }

    default public boolean setIfAbsent(K key, V value, CacheWriteOptions options) {
        CacheEntry<K, V> ce = this.putIfAbsent(key, value, options);
        return ce == null;
    }

    default public boolean replace(K key, V value, CacheEntryVersion version) {
        return this.replace(key, value, version, CacheWriteOptions.DEFAULT);
    }

    default public boolean replace(K key, V value, CacheEntryVersion version, CacheWriteOptions options) {
        CacheEntry<K, V> ce = this.getOrReplaceEntry(key, value, version, options);
        return ce != null && version.equals(ce.metadata().version());
    }

    default public CacheEntry<K, V> getOrReplaceEntry(K key, V value, CacheEntryVersion version) {
        return this.getOrReplaceEntry(key, value, version, CacheWriteOptions.DEFAULT);
    }

    public CacheEntry<K, V> getOrReplaceEntry(K var1, V var2, CacheEntryVersion var3, CacheWriteOptions var4);

    default public boolean remove(K key) {
        return this.remove(key, CacheOptions.DEFAULT);
    }

    default public boolean remove(K key, CacheOptions options) {
        CacheEntry<K, V> ce = this.getAndRemove(key, options);
        return ce != null;
    }

    default public boolean remove(K key, CacheEntryVersion version) {
        return this.remove(key, version, CacheOptions.DEFAULT);
    }

    public boolean remove(K var1, CacheEntryVersion var2, CacheOptions var3);

    default public CacheEntry<K, V> getAndRemove(K key) {
        return this.getAndRemove(key, CacheOptions.DEFAULT);
    }

    public CacheEntry<K, V> getAndRemove(K var1, CacheOptions var2);

    default public CloseableIterable<K> keys() {
        return this.keys(CacheOptions.DEFAULT);
    }

    public CloseableIterable<K> keys(CacheOptions var1);

    default public CloseableIterable<CacheEntry<K, V>> entries() {
        return this.entries(CacheOptions.DEFAULT);
    }

    public CloseableIterable<CacheEntry<K, V>> entries(CacheOptions var1);

    default public void putAll(Map<K, V> entries) {
        this.putAll(entries, CacheWriteOptions.DEFAULT);
    }

    public void putAll(Map<K, V> var1, CacheWriteOptions var2);

    default public Map<K, V> getAll(Set<K> keys) {
        return this.getAll(keys, CacheOptions.DEFAULT);
    }

    public Map<K, V> getAll(Set<K> var1, CacheOptions var2);

    default public Map<K, V> getAll(K ... keys) {
        return this.getAll(CacheOptions.DEFAULT, keys);
    }

    public Map<K, V> getAll(CacheOptions var1, K ... var2);

    default public Set<K> removeAll(Set<K> keys) {
        return this.removeAll(keys, CacheWriteOptions.DEFAULT);
    }

    public Set<K> removeAll(Set<K> var1, CacheWriteOptions var2);

    default public Map<K, CacheEntry<K, V>> getAndRemoveAll(Set<K> keys) {
        return this.getAndRemoveAll(keys, CacheWriteOptions.DEFAULT);
    }

    default public Map<K, CacheEntry<K, V>> getAndRemoveAll(Set<K> keys, CacheWriteOptions options) {
        HashMap<K, CacheEntry<K, V>> map = new HashMap<K, CacheEntry<K, V>>(keys.size());
        for (K key : keys) {
            map.put(key, this.getAndRemove(key));
        }
        return map;
    }

    default public long estimateSize() {
        return this.estimateSize(CacheOptions.DEFAULT);
    }

    public long estimateSize(CacheOptions var1);

    default public void clear() {
        this.clear(CacheOptions.DEFAULT);
    }

    public void clear(CacheOptions var1);

    default public <R> SyncQuery<K, V, R> query(String query) {
        return this.query(query, CacheOptions.DEFAULT);
    }

    public <R> SyncQuery<K, V, R> query(String var1, CacheOptions var2);

    public AutoCloseable listen(SyncCacheEntryListener<K, V> var1);

    default public <T> Set<CacheEntryProcessorResult<K, T>> process(Set<K> keys, SyncCacheEntryProcessor<K, V, T> processor) {
        return this.process(keys, processor, CacheProcessorOptions.DEFAULT);
    }

    public <T> Set<CacheEntryProcessorResult<K, T>> process(Set<K> var1, SyncCacheEntryProcessor<K, V, T> var2, CacheProcessorOptions var3);

    default public <T> Set<CacheEntryProcessorResult<K, T>> processAll(SyncCacheEntryProcessor<K, V, T> processor) {
        return this.processAll(processor, CacheProcessorOptions.DEFAULT);
    }

    public <T> Set<CacheEntryProcessorResult<K, T>> processAll(SyncCacheEntryProcessor<K, V, T> var1, CacheProcessorOptions var2);

    public SyncStreamingCache<K> streaming();
}

