/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.stream.Collectors;
import org.keycloak.Config;
import org.keycloak.OAuthErrorException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MigrationUtils {
    public static void addAdminRole(RealmModel realm, String roleName) {
        RoleModel role;
        ClientModel client = realm.getMasterAdminClient();
        if (client != null && client.getRole(roleName) == null) {
            role = client.addRole(roleName);
            role.setDescription("${role_" + roleName + "}");
            client.getRealm().getRole("admin").addCompositeRole(role);
        }
        if (!realm.getName().equals(Config.getAdminRealm()) && (client = realm.getClientByClientId("realm-management")) != null && client.getRole(roleName) == null) {
            role = client.addRole(roleName);
            role.setDescription("${role_" + roleName + "}");
            client.getRole("realm-admin").addCompositeRole(role);
        }
    }

    public static void updateOTPRequiredAction(RequiredActionProviderModel otpAction) {
        if (otpAction == null) {
            return;
        }
        if (!UserModel.RequiredAction.CONFIGURE_TOTP.name().equals(otpAction.getProviderId())) {
            return;
        }
        if (!"Configure Totp".equals(otpAction.getName())) {
            return;
        }
        otpAction.setName("Configure OTP");
    }

    public static void updateProtocolMappers(ProtocolMapperContainerModel client) {
        client.getProtocolMappersStream().filter(mapper -> !mapper.getConfig().containsKey("userinfo.token.claim") && mapper.getConfig().containsKey("id.token.claim")).peek(mapper -> mapper.getConfig().put("userinfo.token.claim", (String)mapper.getConfig().get("id.token.claim"))).collect(Collectors.toSet()).stream().forEach(arg_0 -> ((ProtocolMapperContainerModel)client).updateProtocolMapper(arg_0));
    }

    public static void migrateOldOfflineToken(KeycloakSession session, RealmModel realm, ClientModel client, UserModel user) throws OAuthErrorException {
        UserConsentModel consent;
        ClientScopeModel offlineScope = KeycloakModelUtils.getClientScopeByName(realm, "offline_access");
        if (offlineScope == null) {
            throw new OAuthErrorException("invalid_grant", "Offline Access scope not found");
        }
        if (client.isConsentRequired() && (consent = session.users().getConsentByClient(realm, user.getId(), client.getId())) != null) {
            if (client.isDisplayOnConsentScreen()) {
                consent.addGrantedClientScope((ClientScopeModel)client);
            }
            if (offlineScope.isDisplayOnConsentScreen()) {
                consent.addGrantedClientScope(offlineScope);
            }
            session.users().updateConsent(realm, user.getId(), consent);
        }
    }

    public static void setDefaultClientAuthenticatorType(ClientModel s) {
        s.setClientAuthenticatorType(KeycloakModelUtils.getDefaultClientAuthenticatorType());
    }

    public static boolean isOIDCNonBearerOnlyClient(ClientModel c) {
        return (c.getProtocol() == null || "openid-connect".equals(c.getProtocol())) && !c.isBearerOnly();
    }
}

