/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow.conditions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.workflow.WorkflowConditionProviderFactory;
import org.keycloak.models.workflow.conditions.UserAttributeWorkflowConditionProvider;

public class UserAttributeWorkflowConditionFactory
implements WorkflowConditionProviderFactory<UserAttributeWorkflowConditionProvider> {
    public static final String ID = "has-user-attribute";

    public UserAttributeWorkflowConditionProvider create(KeycloakSession session, Map<String, List<String>> config) {
        return new UserAttributeWorkflowConditionProvider(session, config);
    }

    public UserAttributeWorkflowConditionProvider create(KeycloakSession session, List<String> configParameters) {
        if (configParameters.size() % 2 != 0) {
            throw new IllegalArgumentException("Expected even number of configuration parameters (attribute key/value pairs)");
        }
        HashMap<String, List<String>> expectedAttributes = new HashMap<String, List<String>>();
        for (int i = 0; i < configParameters.size(); i += 2) {
            String key = configParameters.get(i);
            String value = configParameters.get(i + 1);
            List<String> values = List.of(value.split(","));
            expectedAttributes.put(key, values);
        }
        return this.create(session, expectedAttributes);
    }

    public String getId() {
        return ID;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }
}

