/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.internaldafny.types;

import BoundedInts_Compile.uint8;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;

public class HMacInput {
    public DigestAlgorithm _digestAlgorithm;
    public DafnySequence<? extends Byte> _key;
    public DafnySequence<? extends Byte> _message;
    private static final TypeDescriptor<HMacInput> _TYPE = TypeDescriptor.referenceWithInitializer(HMacInput.class, () -> HMacInput.Default());
    private static final HMacInput theDefault = HMacInput.create(DigestAlgorithm.Default(), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()));

    public HMacInput(DigestAlgorithm digestAlgorithm, DafnySequence<? extends Byte> key, DafnySequence<? extends Byte> message) {
        this._digestAlgorithm = digestAlgorithm;
        this._key = key;
        this._message = message;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        HMacInput o = (HMacInput)other;
        return Objects.equals(this._digestAlgorithm, o._digestAlgorithm) && Objects.equals(this._key, o._key) && Objects.equals(this._message, o._message);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._digestAlgorithm);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._key);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._message);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyPrimitivesTypes.HMacInput.HMacInput");
        s.append("(");
        s.append(Helpers.toString((Object)this._digestAlgorithm));
        s.append(", ");
        s.append(Helpers.toString(this._key));
        s.append(", ");
        s.append(Helpers.toString(this._message));
        s.append(")");
        return s.toString();
    }

    public static TypeDescriptor<HMacInput> _typeDescriptor() {
        return _TYPE;
    }

    public static HMacInput Default() {
        return theDefault;
    }

    public static HMacInput create(DigestAlgorithm digestAlgorithm, DafnySequence<? extends Byte> key, DafnySequence<? extends Byte> message) {
        return new HMacInput(digestAlgorithm, key, message);
    }

    public static HMacInput create_HMacInput(DigestAlgorithm digestAlgorithm, DafnySequence<? extends Byte> key, DafnySequence<? extends Byte> message) {
        return HMacInput.create(digestAlgorithm, key, message);
    }

    public boolean is_HMacInput() {
        return true;
    }

    public DigestAlgorithm dtor_digestAlgorithm() {
        return this._digestAlgorithm;
    }

    public DafnySequence<? extends Byte> dtor_key() {
        return this._key;
    }

    public DafnySequence<? extends Byte> dtor_message() {
        return this._message;
    }
}

