/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.AlgorithmSuiteId;
import software.amazon.cryptography.materialproviders.model.CommitmentPolicy;

public class ValidateCommitmentPolicyOnDecryptInput {
    private final AlgorithmSuiteId algorithm;
    private final CommitmentPolicy commitmentPolicy;

    protected ValidateCommitmentPolicyOnDecryptInput(BuilderImpl builder) {
        this.algorithm = builder.algorithm();
        this.commitmentPolicy = builder.commitmentPolicy();
    }

    public AlgorithmSuiteId algorithm() {
        return this.algorithm;
    }

    public CommitmentPolicy commitmentPolicy() {
        return this.commitmentPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected AlgorithmSuiteId algorithm;
        protected CommitmentPolicy commitmentPolicy;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ValidateCommitmentPolicyOnDecryptInput model) {
            this.algorithm = model.algorithm();
            this.commitmentPolicy = model.commitmentPolicy();
        }

        @Override
        public Builder algorithm(AlgorithmSuiteId algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public AlgorithmSuiteId algorithm() {
            return this.algorithm;
        }

        @Override
        public Builder commitmentPolicy(CommitmentPolicy commitmentPolicy) {
            this.commitmentPolicy = commitmentPolicy;
            return this;
        }

        @Override
        public CommitmentPolicy commitmentPolicy() {
            return this.commitmentPolicy;
        }

        @Override
        public ValidateCommitmentPolicyOnDecryptInput build() {
            if (Objects.isNull(this.algorithm())) {
                throw new IllegalArgumentException("Missing value for required field `algorithm`");
            }
            if (Objects.isNull(this.commitmentPolicy())) {
                throw new IllegalArgumentException("Missing value for required field `commitmentPolicy`");
            }
            return new ValidateCommitmentPolicyOnDecryptInput(this);
        }
    }

    public static interface Builder {
        public Builder algorithm(AlgorithmSuiteId var1);

        public AlgorithmSuiteId algorithm();

        public Builder commitmentPolicy(CommitmentPolicy var1);

        public CommitmentPolicy commitmentPolicy();

        public ValidateCommitmentPolicyOnDecryptInput build();
    }
}

